/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.common.QMGenerics;
import eu.qualimaster.common.QMInternal;
import eu.qualimaster.common.QMName;
import eu.qualimaster.common.QMNoSimulation;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IRegisteredStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.types.ITypeAnalyzer;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.types.RtVilTypeRegistry;

class TypeAnalyzer
implements ITypeAnalyzer {
    public static final String NAMESPACE = "qualimaster";
    private static final Map<String, TypeDescriptor<?>> FALLBACK_TYPES = new HashMap();
    private static final Set<Class<?>> IMPORTING = new HashSet();

    static {
        TypeAnalyzer.registerSpecialType(Serializable.class, TypeRegistry.anyType());
    }

    TypeAnalyzer() {
    }

    void setImportingTypes(List<Class<?>> importing) {
        for (Class<?> cls : importing) {
            IMPORTING.add(cls);
        }
    }

    private static void registerSpecialType(Class<?> cls, TypeDescriptor<?> descriptor) {
        if (cls != null) {
            FALLBACK_TYPES.put(cls.getSimpleName(), descriptor);
            FALLBACK_TYPES.put(cls.getName(), descriptor);
        }
    }

    public String getVilName(Class<?> cls) {
        String tmp;
        Object name = cls.getName().replace("$", "");
        QMName annotation = cls.getAnnotation(QMName.class);
        if (annotation != null && (tmp = annotation.name()) != null && tmp.length() > 0) {
            name = tmp;
        }
        name = RtVilTypeRegistry.strip((String)name, (String)"::");
        name = RtVilTypeRegistry.strip((String)name, (String)".");
        if (cls.isInterface() && ((String)name).startsWith("I") && ((String)name).length() > 1) {
            name = ((String)name).substring(1);
        }
        if (((String)name).length() > 0) {
            name = "qualimaster::" + (String)name;
        }
        return name;
    }

    public boolean isVisible(Class<?> cls) {
        return cls.getAnnotation(QMInternal.class) == null;
    }

    public boolean isVisible(Method method) {
        return !method.getDeclaringClass().isEnum() && method.getDeclaringClass() != Comparable.class && method.getDeclaringClass() != Enum.class && method.getAnnotation(QMInternal.class) == null;
    }

    public boolean isDisabledDuringSimulation(Method method) {
        return method.getAnnotation(QMNoSimulation.class) != null;
    }

    public boolean isVisible(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && field.getAnnotation(QMInternal.class) == null;
    }

    public boolean isVisible(Constructor<?> constructor) {
        Class<?> declaring = constructor.getDeclaringClass();
        return !declaring.isEnum() && constructor.getAnnotation(QMInternal.class) == null;
    }

    public IRegisteredStringValueProvider getStringValueProvider(final Class<?> cls) {
        return new IRegisteredStringValueProvider(){

            public String getStringValue(Object object, IStringValueProvider.StringComparator comparator) {
                Object result = object != null && object.getClass().isEnum() ? ((Enum)object).name() : "<" + cls.getSimpleName() + ">";
                return result;
            }
        };
    }

    public String getVilName(Method method) {
        QMName annotation = method.getAnnotation(QMName.class);
        return annotation == null ? null : annotation.name();
    }

    public String getVilName(Field field) {
        QMName annotation = field.getAnnotation(QMName.class);
        return annotation == null ? null : annotation.name();
    }

    public Class<?>[] getFieldGenerics(Field field) {
        return this.scanTypes(field.getAnnotation(QMGenerics.class));
    }

    public Class<?>[] getParameterGenerics(Method method, int index) {
        return this.scanTypes((QMGenerics)TypeHelper.getParameterAnnotation((Annotation[][])method.getParameterAnnotations(), (int)index, QMGenerics.class));
    }

    public Class<?>[] getParameterGenerics(Constructor<?> constructor, int index) {
        return this.scanTypes((QMGenerics)TypeHelper.getParameterAnnotation((Annotation[][])constructor.getParameterAnnotations(), (int)index, QMGenerics.class));
    }

    public Class<?>[] getReturnGenerics(Method method) {
        return this.scanTypes(method.getAnnotation(QMGenerics.class));
    }

    public TypeDescriptor<?> resolveTypeFallback(String name) {
        return FALLBACK_TYPES.get(name);
    }

    private Class<?>[] scanTypes(QMGenerics annotation) {
        Class[] result;
        if (annotation == null) {
            result = null;
        } else {
            result = annotation.types();
            if (result != null) {
                RtVilTypeRegistry registry = RtVilTypeRegistry.INSTANCE;
                int t = 0;
                while (t < result.length) {
                    Class cls = result[t];
                    if (IMPORTING.contains(cls) && !registry.hasType(this.getVilName(cls))) {
                        try {
                            RtVilTypeRegistry.registerRtType((Class)cls);
                        }
                        catch (VilException vilException) {
                            // empty catch block
                        }
                    }
                    ++t;
                }
            }
        }
        return result;
    }
}

