/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.coordination.events.AlgorithmProfilingEvent;
import eu.qualimaster.easy.extension.ObservableMapping;
import eu.qualimaster.easy.extension.internal.Bundle;
import eu.qualimaster.easy.extension.internal.PipelineContentsContainer;
import eu.qualimaster.easy.extension.internal.PipelineHelper;
import eu.qualimaster.easy.extension.internal.PipelineVisitor;
import eu.qualimaster.easy.extension.internal.Utils;
import eu.qualimaster.easy.extension.internal.VariableHelper;
import eu.qualimaster.events.EventHandler;
import eu.qualimaster.events.EventManager;
import eu.qualimaster.monitoring.events.FrozenSystemState;
import eu.qualimaster.monitoring.systemState.TypeMapper;
import eu.qualimaster.observables.IObservable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.rt.core.model.confModel.AbstractVariableIdentifier;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import org.apache.commons.lang.StringUtils;

public class IvmlElementIdentifier
extends AbstractVariableIdentifier<ObservableTuple>
implements PipelineVisitor.IVariableMapper {
    private static final String MAIN_PROJECT_ID = "Infrastructure:";
    private static final Set<String> PROFILING_PIPELINES = new HashSet<String>();
    private List<IDecisionVariable> pipelines;
    private Map<String, PipelineContentsContainer> pipelineInfos;
    private Map<String, List<String>> cachedIDSegments;
    private Map<IDecisionVariable, IDecisionVariable> varMapping = new HashMap<IDecisionVariable, IDecisionVariable>();

    static {
        EventManager.register((EventHandler)new ProfilingEventHandler());
    }

    public IvmlElementIdentifier(Configuration config) {
        this.pipelines = new ArrayList<IDecisionVariable>();
        for (IDecisionVariable variable : config) {
            if (!variable.getDeclaration().getType().getName().equals("Pipeline")) continue;
            this.pipelines.add(variable);
        }
        this.cachedIDSegments = new HashMap<String, List<String>>();
        this.pipelineInfos = new HashMap<String, PipelineContentsContainer>();
    }

    @Override
    public void map(IDecisionVariable original, IDecisionVariable copy) {
        if (original != null && copy != null) {
            this.varMapping.put(original, copy);
        }
    }

    private PipelineContentsContainer getPipelineInfos(String pipName) {
        PipelineContentsContainer infos = this.pipelineInfos.get(pipName);
        if (infos == null) {
            IDecisionVariable pipeline = null;
            int i = 0;
            int end = this.pipelines.size();
            while (i < end && pipeline == null) {
                IDecisionVariable tmpPip = this.pipelines.get(i);
                if (tmpPip.getNestedElement("name").getValue().getValue().equals(pipName)) {
                    pipeline = tmpPip;
                }
                ++i;
            }
            if (pipeline != null) {
                PipelineVisitor visitor = new PipelineVisitor(pipeline, this);
                infos = visitor.getPipelineContents();
            }
            this.pipelineInfos.put(pipName, infos);
        }
        return infos;
    }

    protected String variableToID(ObservableTuple variable) {
        AbstractIvmlVariable var;
        TypeMapper.TypeCharacterizer characterizer;
        String id = null;
        if (variable.element instanceof AbstractIvmlVariable && (characterizer = TypeMapper.findCharacterizer((IDatatype)(var = (AbstractIvmlVariable)variable.element).getIvmlType())) != null) {
            String prefix = characterizer.getFrozenStatePrefix();
            String key = characterizer.getFrozenStateKey(var.getDecisionVariable());
            id = prefix + ":" + key + ":" + (variable.observable == null ? null : variable.observable.name());
        }
        return id;
    }

    protected boolean isNestedVariable(String id) {
        return id != null && !id.startsWith(MAIN_PROJECT_ID) && StringUtils.countMatches((String)id, (String)":") > 1;
    }

    protected Iterator<String> getIDIterator(final String observableID) {
        final List<String> segments = this.splitID(observableID);
        return new Iterator<String>(){
            private int index = 1;
            private ObservableMappingType type = null;
            private String slotOverride = null;

            @Override
            public boolean hasNext() {
                return segments.size() > this.index;
            }

            @Override
            public String next() {
                Object id;
                try {
                    if (1 == this.index) {
                        this.index = Math.max(segments.size() - 2, 1);
                        String firstSegment = (String)segments.get(0);
                        if (firstSegment.equals("PipelineElement")) {
                            id = firstSegment + ":" + (String)segments.get(1) + ":" + (String)segments.get(this.index++);
                        } else if (firstSegment.equals("Actual")) {
                            id = "PipelineElement:" + (String)segments.get(1) + ":" + (String)segments.get(2);
                            ++this.index;
                            this.slotOverride = "actual";
                        } else {
                            if (firstSegment.equals("Algorithm")) {
                                this.type = ObservableMappingType.ALGORITHM;
                            }
                            id = firstSegment + ":" + (String)segments.get(this.index++);
                        }
                    } else {
                        String mappedValue;
                        id = segments.size() - 1 == this.index ? (this.slotOverride != null ? this.slotOverride : ((mappedValue = ObservableMappingType.getMapping(this.type, (String)(id = (String)segments.get(this.index++)))) != null ? mappedValue : null)) : (String)segments.get(this.index++);
                    }
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    throw new RuntimeException("Unable to split \"" + observableID + "\" into sufficient segments.", exc);
                }
                return id;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing segments are not supported. Tried this on: " + observableID);
            }
        };
    }

    private List<String> splitID(String id) {
        List<String> segments = this.cachedIDSegments.get(id);
        if (segments == null) {
            segments = new ArrayList<String>();
            this.cachedIDSegments.put(id, segments);
            String[] arraySegments = id.split(":");
            if ("Algorithm".equals(arraySegments[0])) {
                this.fillSegmentList(PipelineContentsContainer.MappedInstanceType.ALGORITHM, arraySegments, segments);
            } else if ("DataSource".equals(arraySegments[0])) {
                this.fillSegmentList(PipelineContentsContainer.MappedInstanceType.SOURCE, arraySegments, segments);
            } else if ("DataSink".equals(arraySegments[0])) {
                this.fillSegmentList(PipelineContentsContainer.MappedInstanceType.SINK, arraySegments, segments);
            }
            if (segments.isEmpty()) {
                int i = 0;
                while (i < arraySegments.length) {
                    segments.add(arraySegments[i]);
                    ++i;
                }
            }
        }
        return segments;
    }

    private void fillSegmentList(PipelineContentsContainer.MappedInstanceType type, String[] arraySegments, List<String> segments) {
        PipelineContentsContainer infos = this.getPipelineInfos(arraySegments[1]);
        if (infos != null) {
            IDecisionVariable mappedVar = infos.getMappedInstance(type, arraySegments[2]);
            if (mappedVar != null) {
                segments.add(arraySegments[0]);
                segments.add(mappedVar.getDeclaration().getName());
                segments.add(arraySegments[arraySegments.length - 1]);
            } else if (!infos.hasMapping(type, arraySegments[2])) {
                Bundle.getLogger(IvmlElementIdentifier.class).warn("No mapped variable found for: " + arraySegments[1] + "/" + arraySegments[2] + " with type " + String.valueOf((Object)type));
            }
        } else {
            String pipName = arraySegments[1];
            if (!PROFILING_PIPELINES.contains(pipName)) {
                Bundle.getLogger(IvmlElementIdentifier.class).warn("No pipeline information found for: " + pipName);
            }
        }
    }

    protected String iDecisionVariableToID(IDecisionVariable variable) {
        String id = null;
        TypeMapper.TypeCharacterizer characterizer = TypeMapper.findCharacterizer((IDatatype)variable.getDeclaration().getType());
        if (characterizer != null) {
            String key;
            IDecisionVariable pipelineVar = null;
            try {
                pipelineVar = PipelineHelper.obtainPipeline(variable.getConfiguration(), variable);
            }
            catch (ModelQueryException e) {
                Bundle.getLogger(IvmlElementIdentifier.class).debug(e.getMessage());
            }
            String prefix = characterizer.getFrozenStatePrefix();
            if (pipelineVar != null) {
                String pipName = VariableHelper.getName(pipelineVar);
                key = FrozenSystemState.obtainPipelineElementSubkey((String)pipName, (String)VariableHelper.getName(variable));
            } else {
                key = PipelineContentsContainer.isMappingVariable(variable) ? variable.getDeclaration().getName() : VariableHelper.getName(variable);
            }
            id = prefix + ":" + key;
        } else {
            String normalizedName;
            Object varName = VariableHelper.getName(variable);
            if (varName == null) {
                varName = variable.getDeclaration().getName();
            }
            if ((normalizedName = ObservableMapping.mapReverseGeneralObservable((String)varName)) != null) {
                varName = ":" + normalizedName;
            }
            id = MAIN_PROJECT_ID + (String)varName;
        }
        return id;
    }

    protected Object mapValue(String id, Object oValue) {
        Object result = oValue;
        if (id.startsWith("Actual:")) {
            int ePos = id.lastIndexOf(":");
            if (ePos > 0) {
                int sPos = id.lastIndexOf(":", ePos - 1);
                if (sPos > 0) {
                    result = id.substring(sPos + 1, ePos);
                }
            } else {
                Bundle.getLogger(IvmlElementIdentifier.class).warn("Active id " + id + "does not comply to structure conventions: Active:pipelineElement:algorithm:observable. Ignoring algorithm change");
            }
        }
        return result;
    }

    protected IDecisionVariable mapVariable(IDecisionVariable variable) {
        IDecisionVariable tmp;
        IDecisionVariable result = variable;
        if (variable != null && (tmp = this.varMapping.get(variable)) != null) {
            result = tmp;
        }
        return result;
    }

    protected Value toIVMLValue(IDecisionVariable trgVariable, Object oValue) throws ValueDoesNotMatchTypeException {
        BooleanValue result = null;
        IDatatype type = trgVariable.getDeclaration().getType();
        if (TypeQueries.isReference((IDatatype)type) && trgVariable.getDeclaration().getName().equals("actual")) {
            IDecisionVariable available = null;
            if (trgVariable.getParent() instanceof IDecisionVariable) {
                try {
                    available = PipelineHelper.getAvailable((IDecisionVariable)trgVariable.getParent(), oValue.toString());
                }
                catch (VilException e) {
                    Bundle.getLogger(IvmlElementIdentifier.class).warn("Please check model structure! Cannot find slots  for available on " + trgVariable.getQualifiedName() + ". Ignoring algorithm change.");
                }
            }
            if (available != null) {
                result = ValueFactory.createValue((IDatatype)trgVariable.getDeclaration().getType(), (Object[])new Object[]{available.getDeclaration()});
            } else {
                Bundle.getLogger(IvmlElementIdentifier.class).warn("Cannot find active algorithm for " + String.valueOf(oValue) + " in the available algorithms of " + trgVariable.getQualifiedName() + ". Ignoring algorithm change");
            }
        } else {
            if (IntegerType.TYPE.isAssignableFrom(type) && oValue instanceof Double) {
                oValue = ((Double)oValue).intValue();
            } else if (BooleanType.TYPE.isAssignableFrom(type) && oValue instanceof Double) {
                BooleanValue booleanValue = result = (Double)oValue >= 0.5 ? BooleanValue.TRUE : BooleanValue.FALSE;
            }
            if (result == null) {
                result = ValueFactory.createValue((IDatatype)type, (Object[])new Object[]{oValue});
            }
        }
        return result;
    }

    protected void assignValue(IDecisionVariable variable, Value value) throws ConfigurationException {
        super.assignValue(variable, value);
        if (variable.getParent() instanceof IDecisionVariable) {
            IDecisionVariable parentVariable = (IDecisionVariable)variable.getParent();
            String variableName = variable.getDeclaration().getName();
            String typeName = parentVariable.getDeclaration().getType().getName();
            if ("Pipeline".equals(typeName) && "hosts".equals(variableName)) {
                String pipeline = parentVariable.getDeclaration().getName();
                PipelineContentsContainer infos = this.getPipelineInfos(pipeline);
                if (infos != null) {
                    List<IDecisionVariable> familyElements = infos.getFamilyElements();
                    for (IDecisionVariable familyElement : familyElements) {
                        this.setValueForAvailableAlgorithms(value, familyElement, "pipeline_Hosts");
                    }
                }
            } else if ("FamilyElement".equals(typeName)) {
                if ("items".equals(variableName)) {
                    this.setValueForAvailableAlgorithms(value, parentVariable, "family_Items");
                } else if ("predecessorItems".equals(variableName)) {
                    this.setValueForAvailableAlgorithms(value, parentVariable, "family_PredecessorItems");
                } else if ("predictedItemsThreshold".equals(variableName)) {
                    this.setValueForAvailableAlgorithms(value, parentVariable, "family_PredictedItemsThreshold");
                }
            }
        }
    }

    protected AssignmentState getAssignmentState() {
        return AssignmentState.USER_ASSIGNED;
    }

    private void setValueForAvailableAlgorithms(Value value, IDecisionVariable familyElement, String slot) throws ConfigurationException {
        Value refferencedAlgos;
        IDecisionVariable availableAlgos = familyElement.getNestedElement("available");
        List<IDecisionVariable> algos = null;
        if (availableAlgos != null && (refferencedAlgos = availableAlgos.getValue()) != null && refferencedAlgos instanceof ContainerValue) {
            ContainerValue container = (ContainerValue)refferencedAlgos;
            algos = Utils.extractVariables(container, familyElement.getConfiguration());
        }
        if (algos != null) {
            for (IDecisionVariable algorithm : algos) {
                IDecisionVariable algoSlot = algorithm.getNestedElement(slot);
                if (algoSlot == null) continue;
                algoSlot.setValue(value, (IAssignmentState)this.getAssignmentState());
            }
        }
    }

    private static enum ObservableMappingType {
        ALGORITHM;


        private static String getMapping(ObservableMappingType type, String observable) {
            String variableName = null;
            if (type != null) {
                switch (type) {
                    case ALGORITHM: {
                        variableName = ObservableMapping.mapAlgorithmObservable(observable);
                        break;
                    }
                    default: {
                        variableName = ObservableMapping.mapGeneralObservable(observable);
                        break;
                    }
                }
            } else {
                variableName = ObservableMapping.mapGeneralObservable(observable);
            }
            return variableName;
        }
    }

    public static class ObservableTuple {
        private IvmlElement element;
        private IObservable observable;

        public ObservableTuple(IvmlElement element, IObservable observable) {
            this.element = element;
            this.observable = observable;
        }
    }

    private static class ProfilingEventHandler
    extends EventHandler<AlgorithmProfilingEvent> {
        protected ProfilingEventHandler() {
            super(AlgorithmProfilingEvent.class);
        }

        protected void handle(AlgorithmProfilingEvent event) {
            switch (event.getStatus()) {
                case START: {
                    PROFILING_PIPELINES.add(event.getPipeline());
                    break;
                }
                case END: {
                    PROFILING_PIPELINES.remove(event.getPipeline());
                    break;
                }
            }
        }
    }
}

