/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.common.QMInternal;
import eu.qualimaster.easy.extension.internal.PipelineHelper;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;

@Instantiator(value="obtainPipelineElement")
public class PipelineElementHelper
implements IVilType {
    public static DecisionVariable obtainPipelineElement(net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration config, String variableName) throws VilException {
        IDecisionVariable tmp;
        DecisionVariable result = null;
        DecisionVariable pip = null;
        if (variableName != null && config != null) {
            variableName = variableName.replace(String.valueOf('.'), "::");
            pip = PipelineHelper.obtainPipeline(config, variableName);
        }
        if (pip != null && (tmp = PipelineElementHelper.obtainPipelineElement(pip.getDecisionVariable(), variableName)) != null) {
            result = config.getByName(Configuration.getInstanceName((IDecisionVariable)tmp));
        }
        return result;
    }

    private static IDecisionVariable obtainPipelineElement(IDecisionVariable pip, String variableName) {
        IDecisionVariable tmp = null;
        if (pip != null) {
            String scopeName = pip.getDeclaration().getParent().getName();
            String tmpName = PipelineElementHelper.cutPrefix(variableName, scopeName);
            tmpName = PipelineElementHelper.cutPrefix(tmpName, "::");
            tmp = PipelineHelper.obtainPipelineElementByName(pip, null, tmpName);
            int pos = 0;
            while (tmp == null && pos >= 0) {
                pos = tmpName.lastIndexOf("::");
                if (pos > 0) {
                    tmpName = tmpName.substring(0, pos);
                    tmp = PipelineHelper.obtainPipelineElementByName(pip, null, tmpName);
                }
                --pos;
            }
        }
        return tmp;
    }

    @QMInternal
    public static IDecisionVariable findPipelineElement(Configuration config, String variableName) {
        IDecisionVariable pip = null;
        if (variableName != null && config != null) {
            String vName = variableName = variableName.replace(String.valueOf('.'), "::");
            Project prj = config.getProject();
            int pos = vName.indexOf("::");
            if (pos > 0) {
                prj = ModelQuery.findProject((Project)config.getProject(), (String)vName.substring(0, pos));
                vName = vName.substring(pos + "::".length());
            }
            if (prj != null) {
                AbstractVariable var;
                pos = vName.indexOf("::");
                if (pos > 0) {
                    vName = vName.substring(0, pos);
                }
                try {
                    var = ModelQuery.findVariable((IResolutionScope)prj, (String)vName, null);
                }
                catch (ModelQueryException e) {
                    var = null;
                }
                if (var != null) {
                    pip = config.getDecision(var);
                }
            }
        }
        return PipelineElementHelper.obtainPipelineElement(pip, variableName);
    }

    private static String cutPrefix(String name, String prefix) {
        String result = name;
        if (name.startsWith(prefix)) {
            result = name.substring(prefix.length());
        }
        return result;
    }
}

