/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.easy.extension.internal.Bundle;
import eu.qualimaster.easy.extension.internal.PipelineVisitor;
import eu.qualimaster.easy.extension.internal.VariableHelper;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class Utils {
    public static Compound findCompound(Project project, String name) throws ModelQueryException {
        return (Compound)ModelQuery.findType((IResolutionScope)project, (String)name, Compound.class);
    }

    public static IDecisionVariable findNamedVariable(Configuration config, IDatatype type, String name) throws ModelQueryException {
        IDecisionVariable result = VariableHelper.findNamedVariable(config, type, name);
        if (result == null) {
            throw new ModelQueryException(type.getName() + " '" + name + "' not found", 10151);
        }
        return result;
    }

    public static IDecisionVariable findAlgorithm(IDecisionVariable family, String name, boolean asReference) throws ModelQueryException {
        IDecisionVariable result = null;
        IDecisionVariable members = family.getNestedElement("members");
        if (members == null) {
            throw new ModelQueryException("'members' not found in variable '" + family.getDeclaration().getName() + "'", 10151);
        }
        int n = 0;
        while (result == null && n < members.getNestedElementsCount()) {
            IDecisionVariable algoRef = members.getNestedElement(n);
            IDecisionVariable algorithm = Configuration.dereference((IDecisionVariable)algoRef);
            if (VariableHelper.hasName(algorithm, name)) {
                result = asReference ? algoRef : algorithm;
            }
            ++n;
        }
        if (result == null) {
            throw new ModelQueryException("algorithm '" + name + "' not found in variable '" + family.getDeclaration().getName() + "'", 10151);
        }
        return result;
    }

    public static FreezeBlock createFreezeBlock(List<IFreezable> freezables, Project project, Project fallbackForType) throws CSTSemanticException, ValueDoesNotMatchTypeException, ModelQueryException {
        IFreezable[] tmp = new IFreezable[freezables.size()];
        freezables.toArray(tmp);
        return Utils.createFreezeBlock(tmp, project, fallbackForType);
    }

    public static FreezeBlock createFreezeBlock(IFreezable[] freezables, Project project, Project fallbackForType) throws CSTSemanticException, ValueDoesNotMatchTypeException, ModelQueryException {
        FreezeBlock result = null;
        FreezeVariableType iterType = new FreezeVariableType(freezables, (IModelElement)project);
        DecisionVariableDeclaration iter = new DecisionVariableDeclaration("f", (IDatatype)iterType, (IModelElement)project);
        Enum type = ModelQuery.findEnum((IResolutionScope)project, (String)"BindingTime");
        if (type == null && fallbackForType != null) {
            type = ModelQuery.findEnum((IResolutionScope)fallbackForType, (String)"BindingTime");
        }
        String butOperation = "==";
        EnumLiteral literal = type.get("runtime");
        if (literal == null) {
            literal = type.get("runtimeMon");
            butOperation = ">=";
        }
        ConstantValue runtime = new ConstantValue(ValueFactory.createValue((IDatatype)type, (Object[])new Object[]{literal}));
        AttributeVariable iterEx = new AttributeVariable((ConstraintSyntaxTree)new Variable((AbstractVariable)iter), iterType.getAttribute("bindingTime"));
        OCLFeatureCall op = new OCLFeatureCall((ConstraintSyntaxTree)iterEx, butOperation, new ConstraintSyntaxTree[]{runtime});
        op.inferDatatype();
        result = new FreezeBlock(freezables, iter, (ConstraintSyntaxTree)op, (IModelElement)project);
        return result;
    }

    public static FreezeBlock createFreezeBlock(Project project) throws CSTSemanticException, ValueDoesNotMatchTypeException, ModelQueryException {
        ArrayList<IFreezable> freezables = new ArrayList<IFreezable>();
        int e = 0;
        while (e < project.getElementCount()) {
            ContainableModelElement elt = project.getElement(e);
            if (elt instanceof IFreezable) {
                freezables.add((IFreezable)elt);
            }
            ++e;
        }
        FreezeBlock result = Utils.createFreezeBlock(freezables, project, project);
        project.add((ContainableModelElement)result);
        return result;
    }

    public static void addRuntimeAttributeToProject(Project project, Project fallbackForType) throws CSTSemanticException, ValueDoesNotMatchTypeException, ModelQueryException {
        Enum type = ModelQuery.findEnum((IResolutionScope)project, (String)"BindingTime");
        if (type == null && fallbackForType != null) {
            type = ModelQuery.findEnum((IResolutionScope)fallbackForType, (String)"BindingTime");
        }
        EnumLiteral literal = type.get("compile");
        Attribute attr = new Attribute("bindingTime", (IDatatype)type, (IModelElement)project, (IAttributableElement)project);
        attr.setValue((ConstraintSyntaxTree)new ConstantValue(ValueFactory.createValue((IDatatype)type, (Object[])new Object[]{literal})));
        project.add((ContainableModelElement)attr);
    }

    public static IDecisionVariable extractVariable(ReferenceValue refValue, Configuration config) {
        IDecisionVariable result = null;
        if (refValue.getValue() != null) {
            result = config.getDecision(refValue.getValue());
        } else {
            Bundle.getLogger(PipelineVisitor.class).error("Expressions are currently not supported for extracting IDecisionVariables from a ReferenceValue");
        }
        return result;
    }

    public static List<IDecisionVariable> extractVariables(ContainerValue refValues, Configuration config) {
        ArrayList<IDecisionVariable> result = new ArrayList<IDecisionVariable>();
        int i = 0;
        int end = refValues.getElementSize();
        while (i < end) {
            IDecisionVariable referrencedVar;
            Value nestedValue = refValues.getElement(i);
            if (nestedValue instanceof ReferenceValue && (referrencedVar = Utils.extractVariable((ReferenceValue)nestedValue, config)) != null) {
                result.add(referrencedVar);
            }
            ++i;
        }
        return result;
    }
}

