//package gr.tuc.softnet.ap0n;
//
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import java.io.BufferedReader;
//import java.io.File;
//import java.io.FileInputStream;
//import java.io.FileReader;
//import java.io.IOException;
//import java.io.InputStreamReader;
//import java.util.ArrayDeque;
//import java.util.LinkedList;
//import java.util.List;
//import java.util.Queue;
//import java.util.Random;
//import java.util.Scanner;
//
//import gr.tuc.softnet.ap0n.graph.Edge;
//import gr.tuc.softnet.ap0n.graph.Snapshot;
//import gr.tuc.softnet.ap0n.graph.Vertex;
//import gr.tuc.softnet.ap0n.index.VolatileIndex;
//
///**
// * Created by ap0n on 2/9/2016.
// */
//public class Tester {
//
//  public final static Logger logger = LoggerFactory.getLogger(Tester.class);
//
//
//  public static void main(String[] args) {
//    Tester.logger.info("Starting");
//
//    try {
//      VolatileIndex index = new VolatileIndex();
//      runReadFull(index, args[0], Integer.parseInt(args[1]));
//
//    } catch (Exception e) {
//      e.printStackTrace();
//    }
//  }
//
//  public static void runReadFull(VolatileIndex index, String path, int operations_count) {
//    try {
//      if (index == null) {
//        index = new VolatileIndex();
//      }
//      Queue<String> lines = new ArrayDeque<>(operations_count);
//      logger.info("Queue allocated");
//      Scanner fscanner = new Scanner(new FileInputStream(new File(path)));
//      while (fscanner.hasNextLine()) {
//        lines.add(fscanner.nextLine());
//      }
//
//      logger.info("Data loaded. *Log memory* and then type something measuring splitting time");
//
//      BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
//      {
//        try {
//          String input = br.readLine();
//        } catch (IOException e) {
//          e.printStackTrace();
//        }
//      }
//
//      Queue<String> copied_data = new ArrayDeque<>(lines);
//
//      // Select 100 random timestamps for the queries
//      int query_count = 100;
//      Random r = new Random();
//      Object[] data_array = copied_data.toArray();
//      Queue<Long> query_timestamps = new ArrayDeque<>(query_count);
//      for (int i = 0; i < query_count; i++) {
//        int indx = r.nextInt(data_array.length);
//        String s = (String) data_array[indx];
//        long t = Long.parseLong(s.split(",")[3]);
//        query_timestamps.add(t);
//      }
//      data_array = null;
//      r = null;
//
//      long splitting_start = System.currentTimeMillis();
//      while (copied_data.size() > 0) {
//        String[] a = copied_data.poll().split(",");
//      }
//      copied_data = null;
//
//      long splitting_millis = System.currentTimeMillis() - splitting_start;
//      logger.info("Splitting timing done: " + splitting_millis);
//      long end = 0;
//      long start = System.currentTimeMillis();
//
//      while (lines.size() > 0) {
//        String[] attrs = lines.poll().split(",");
//        if (attrs[0].equals("a")) {
//          String id = attrs[1];
//          long timestamp = Long.parseLong(attrs[2]);
//          index.addGraphNode(new Vertex(id, timestamp));
//        } else if (attrs[0].equals("e")) {
//          // addEdge,idA,idB,timestamp
//          String idA = attrs[1];
//          String idB = attrs[2];
//          long timestamp = Long.parseLong(attrs[3]);
//          index.addGraphEdge(new Edge(idA, idB, timestamp));
//        } else if (attrs[0].equals("x")) {
//          // expEdge,idA,idB,timestamp
//          String idA = attrs[1];
//          String idB = attrs[2];
//          long timestamp = Long.parseLong(attrs[3]);
//          index.expireEdge(new Edge(idA, idB, timestamp));
//        } else if (attrs[0].equals("warn")) {
//          // warn,line
//          System.err.println("attrs[1]");
//        } else {
//          throw new RuntimeException("Wrong input file");
//        }
//      }
//      end = System.currentTimeMillis();
//
//      long millis = end - start;
//      logger.info("Operations duration (ms): " + (millis - splitting_millis));
//
//      Tester.logger.info("Done. *Log memory* and then type something to continue to the query");
//
//      {
//        try {
//          String input = br.readLine();
//        } catch (IOException e) {
//          e.printStackTrace();
//        }
//      }
//
//      // Start the snapshot queries
//      List<Snapshot> snapshots = new LinkedList<>();
//
//      long s = System.currentTimeMillis();
//
//      while (query_timestamps.size() > 0) {
//        snapshots.add(index.getSnapshot(query_timestamps.poll()));
//      }
//      long e = System.currentTimeMillis();
//      logger.info(query_count + " snapshot queries duration (ms): " + (e - s));
//
//      Tester.logger.info("*Log time* and then type something to print your snapshot");
//
//      {
//        try {
//          String input = br.readLine();
//        } catch (IOException ee) {
//          ee.printStackTrace();
//        }
//      }
//      for (Snapshot snapshot : snapshots) {
//        System.out.println();
//        System.out.println(snapshot.getTimestamp());
//        snapshot.printStats();
//      }
//
//    } catch (Exception e) {
//      logger.error(e.getMessage(), e);
//    }
//  }
//
//  public static void runFullTimed(VolatileIndex index, String path) {
//    long vertex_add_total = 0;
//    long edge_add_total = 0;
//    long edge_exp_total = 0;
//
//    try {
//      if (index == null) {
//        index = new VolatileIndex();
//      }
//      BufferedReader bufferedReader =
//          new BufferedReader(new FileReader(path));
//      Queue<String[]> lines = new ArrayDeque<>();
//      String line;
//      while ((line = bufferedReader.readLine()) != null) {
//        lines.add(line.split(","));
//      }
//
//      System.out.println("Data loaded");
//      long end = 0;
//      long start = System.currentTimeMillis();
//
//      while (lines.size() > 0) {
//        String[] attrs = lines.poll();
//        if (attrs[0].equals("a")) {
//          String id = attrs[1];
//          long timestamp = Long.parseLong(attrs[2]);
//          long now = System.currentTimeMillis();
//          index.addGraphNode(new Vertex(id, timestamp));
//          long e = System.currentTimeMillis();
//          vertex_add_total += (e - now);
//        } else if (attrs[0].equals("e")) {
//          // addEdge,idA,idB,timestamp
//          String idA = attrs[1];
//          String idB = attrs[2];
//          long timestamp = Long.parseLong(attrs[3]);
//          long now = System.currentTimeMillis();
//          index.addGraphEdge(new Edge(idA, idB, timestamp));
//          edge_add_total += (System.currentTimeMillis() - now);
//        } else if (attrs[0].equals("x")) {
//          // expEdge,idA,idB,timestamp
//          String idA = attrs[1];
//          String idB = attrs[2];
//          long timestamp = Long.parseLong(attrs[3]);
//          long now = System.currentTimeMillis();
//          index.expireEdge(new Edge(idA, idB, timestamp));
//          edge_exp_total += (System.currentTimeMillis() - now);
//        } else if (attrs[0].equals("warn")) {
//          // warn,line
//          System.err.println("attrs[1]");
//        } else {
//          throw new RuntimeException("Wrong input file");
//        }
//      }
//      end = System.currentTimeMillis();
//
//      long millis = end - start;
//      System.out.println("Total time (ms): " + millis);
//
//      System.out.println("Total vertex addition time (ms): " + vertex_add_total);
//      System.out.println("Total edge addition time (ms): " + edge_add_total);
//      System.out.println("Total edge expiration time (ms): " + edge_exp_total);
//
//    } catch (Exception e) {
//      e.printStackTrace();
//    }
//  }
//
//  public static void runVertexAdditions(VolatileIndex index, String path) {
//    try {
//      if (index == null) {
//        index = new VolatileIndex();
//      }
//      BufferedReader bufferedReader =
//          new BufferedReader(new FileReader(path));
//      Queue<String[]> lines = new ArrayDeque<>();
//      String line;
//      while ((line = bufferedReader.readLine()) != null) {
//        lines.add(line.split(","));
//      }
//
//      System.out.println("Data loaded");
//      long end = 0;
//      long start = System.currentTimeMillis();
//      while (lines.size() > 0) {
//        String[] attrs = lines.poll();
//        String id = attrs[1];
//        long timestamp = Long.parseLong(attrs[2]);
//        index.addGraphNode(new Vertex(id, timestamp));
//      }
//      end = System.currentTimeMillis();
//
//      long millis = end - start;
//      System.out.println("Time for adding vertices (ms): " + millis);
//
//    } catch (Exception e) {
//      e.printStackTrace();
//    }
//  }
//
//  public static void runEdgeAdditions(VolatileIndex index, String path) {
//    try {
//      if (index == null) {
//        index = new VolatileIndex();
//      }
//      BufferedReader bufferedReader =
//          new BufferedReader(new FileReader(path));
//      Queue<String[]> lines = new ArrayDeque<>();
//      String line;
//      while ((line = bufferedReader.readLine()) != null) {
//        lines.add(line.split(","));
//      }
//
//      System.out.println("Data loaded");
//      long end = 0;
//      long start = System.currentTimeMillis();
//
//      while (lines.size() > 0) {
//        String[] attrs = lines.poll();
//        String idA = attrs[1];
//        String idB = attrs[2];
//        long timestamp = Long.parseLong(attrs[3]);
//        index.addGraphEdge(new Edge(idA, idB, timestamp));
//      }
//      end = System.currentTimeMillis();
//
//      long millis = end - start;
//      System.out.println("Total time for adding edges (ms): " + millis);
//    } catch (Exception e) {
//      e.printStackTrace();
//    }
//  }
//}
