package gr.tuc.softnet.ap0n.graph;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

/**
 * Created by Apostolos Nydriotis on 2014/11/25.
 */

// TODO: Not sure we need this one.
public class Graph implements Serializable {

  private static final long serialVersionUID = 6785449994905641556L;
  TreeSet<Edge> edges;
  Map<String, Vertex> nodes;

  public Graph() {
    edges = new TreeSet<Edge>();
    nodes = new HashMap<String, Vertex>();
  }

  public Graph(Graph other) {
    edges = new TreeSet<Edge>(other.getEdges());
    nodes = new HashMap<String, Vertex>(other.getNodes());
  }

  public TreeSet<Edge> getEdges() {
    return edges;
  }

  public Map<String, Vertex> getNodes() {
    return nodes;
  }

  public void addNode(Vertex v) {
    nodes.put(v.getId(), v);
  }

  public void addEdge(Edge edge) {
    edges.add(edge);
  }

  // For Qualimaster results
  public String toJsonString() {

    // entry: {"vertices" : ["v0","v1"], "edges" : ["v0,v1", "v1,v2"]}

    StringBuilder sb = new StringBuilder();

    sb.append("{\"V\":[");
    for (Map.Entry<String, Vertex> e : nodes.entrySet()) {
      sb.append("\"").append(e.getValue().getId()).append("\",");
    }
    if (nodes.entrySet().size() > 0) {  // remove the last ','
      sb.setLength(sb.length() - 1);
    }
    sb.append("],\"E\":[");
    for (Edge e : edges) {
      sb.append("\"").append(e.getIdA()).append(",").append(e.getIdB()).append("\",");
    }
    if (edges.size() > 0) {  // remove the last ','
      sb.setLength(sb.length() - 1);
    }
    sb.append("]}");

    return sb.toString();
  }

  @Override
  public String toString() {
    String result = "Nodes";
    for (Map.Entry<String, Vertex> e : nodes.entrySet()) {
      result += "\n" + e.getValue().toString();
    }

    result += "\nEdges";
    for (Edge e : edges) {
      result += "\n" + e.toString();
    }

    return result;
  }

  public void printStats() {
    System.out.println("Vertices: " + nodes.size());
    System.out.println("Edges: " + edges.size());
  }

//  public void print() {
//    System.out.println("Vertices");
//    for (Map.Entry<String, Vertex> e : nodes.entrySet()) {
//      e.getValue().print();
//    }
//
//    System.out.println("Edges");
//    for (Edge e : edges) {
//      e.print();
//    }
//  }
}
