package gr.tuc.softnet.ap0n.graph;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

/**
 * Created by Apostolos Nydriotis on 2014/11/26.
 */
public class Snapshot implements Serializable {

  private static final long serialVersionUID = -3529945020463079294L;
  long timestamp;
  Graph graph;

  public Snapshot() {
    timestamp = 0L;
    graph = new Graph();
  }

  public Snapshot(Snapshot other) {
    timestamp = other.timestamp;
    graph = new Graph(other.graph);
  }

  public Snapshot(long timestamp, Graph graph) {
    this.timestamp = timestamp;
    this.graph = graph;
  }

  /**
   *Merges argument snapshot to this snapshot
   * @param o
   * @throws IllegalArgumentException
   */
  public void mergeSnapshot(Snapshot o) throws IllegalArgumentException {
    if (timestamp != o.timestamp) {
      throw new IllegalArgumentException("Can't merge snapshots with different timestamps");
    }

    // Merge Vertices
    for (Vertex v : o.getGraph().getNodes().values()) {
      graph.addNode(v);
    }

    // Merge edges
    Iterator<Edge> otherEdges = o.getGraph().getEdges().iterator();
    while (otherEdges.hasNext()) {
      graph.addEdge(otherEdges.next());
    }
  }

  public long getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(long timestamp) {
    this.timestamp = timestamp;
  }

  public Graph getGraph() {
    return graph;
  }

  public void setGraph(Graph graph) {
    this.graph = graph;
  }

  @Override
  public String toString() {
    return "Snapshot: " + timestamp + "\n" + graph.toString();
  }

  public String toJsonString() {
    StringBuilder sb = new StringBuilder();

//     entry {"time":"MM/dd/yyyy,HH:mm:ss",graph.toJsonString()}

    DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy,HH:mm:ss");

    sb.append("{\"t\":")
        .append("\"").append(dateFormat.format(new Date(timestamp))).append("\"").append(",")
        .append("\"G\":").append(graph.toJsonString())
        .append("}");

    return sb.toString();
  }

  public void printStats() {
    graph.printStats();
  }
}
