package gr.tuc.softnet.ap0n.graph;

//import com.sleepycat.persist.model.Persistent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 * Created by Apostolos Nydriotis on 2014/11/20.
 */
//@Persistent
public class Vertex implements Comparable<Vertex>, Serializable {

  private static final long serialVersionUID = -8162284555591508155L;
  public final static int COUNT_OF_ATTRIBUTES = 1;
  private String id;
  private long timestamp;
  private String[] attributes;

  public Vertex() {
    attributes = new String[COUNT_OF_ATTRIBUTES];
    for (int i = 0; i < COUNT_OF_ATTRIBUTES; i++) {
      attributes[i] = "";
    }
  }

  public Vertex(String id) {
    this.id = id;
    this.timestamp = -1;
    attributes = new String[COUNT_OF_ATTRIBUTES];
    for (int i = 0; i < COUNT_OF_ATTRIBUTES; i++) {
      attributes[i] = "";
    }
  }

  public Vertex(String id, long timestamp) {
    this.id = id;
    this.timestamp = timestamp;
    attributes = new String[COUNT_OF_ATTRIBUTES];
    for (int i = 0; i < COUNT_OF_ATTRIBUTES; i++) {
      attributes[i] = "";
    }
  }

  public Vertex(Vertex o) {  // Copy Constructor
    this.id = o.id;
    this.timestamp = o.timestamp;
    this.attributes = new String[COUNT_OF_ATTRIBUTES];
    for (int i = 0; i < COUNT_OF_ATTRIBUTES; i++) {
      this.attributes[i] = o.attributes[i];
    }
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(long timestamp) {
    this.timestamp = timestamp;
  }

  public String[] getAttributes() {
    return attributes;
  }

  public String getAttribute(int attributeIndex) {
    assert attributeIndex >= 0 && attributeIndex < COUNT_OF_ATTRIBUTES;
    return attributes[attributeIndex];
  }

  public void setAttributes(int attributeIndex, String value) {
    assert attributeIndex >= 0 && attributeIndex < COUNT_OF_ATTRIBUTES;
    attributes[attributeIndex] = value;
  }

  public String toString(Boolean printAttributes) {
    StringBuilder sb = new StringBuilder();
    sb.append("[").append(timestamp).append(":").append(id);
    if (printAttributes) {
      for (String s : attributes) {
        if (s != null) {
          sb.append(" {").append(s).append("}");
        }
      }
    }
    sb.append("]");
    return sb.toString();
  }

  @Override
  public String toString() {
    return toString(true);
  }

//  @Override
//  public boolean equals(Object o) {
//    if (o.getClass() != this.getClass()){
//      throw new IllegalArgumentException("Wrong class: " + o.getClass());
//    }
//
//    if (((Vertex) o).getId() == id) {
//      return true;
//    }
//    return false;
//  }

  @Override
  public int compareTo(Vertex o) {
    if (timestamp < o.timestamp) {
      return -1;
    } else if (timestamp > o.timestamp) {
      return 1;
    }
    return id.compareTo(o.id);
  }

//  private void writeObject(ObjectOutputStream out) throws IOException {
//    out.defaultWriteObject();
//    for (String s : attributes) {
//      out.writeInt(s.length());
//      out.writeUTF(s);
//    }
//  }
//
//  private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
//    in.defaultReadObject();
//    attributes = new String[COUNT_OF_ATTRIBUTES];
//    for (int i = 0; i < COUNT_OF_ATTRIBUTES; i++) {
//      attributes[i] = in.readUTF();
//    }
//  }
}
