package gr.tuc.softnet.ap0n.index;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import gr.tuc.softnet.ap0n.graph.Edge;
import gr.tuc.softnet.ap0n.graph.Vertex;
import gr.tuc.softnet.ap0n.index.imp.INVersionNode;
import gr.tuc.softnet.ap0n.utils.D;
import gr.tuc.softnet.ap0n.utils.DEntry;
import gr.tuc.softnet.ap0n.utils.Interval;
import gr.tuc.softnet.ap0n.utils.PathQueryType;

/**
 * Created by ap0n on 14/10/2016.
 */
public class QueryExecutor {

  private VolatileIndex index;
  private Interval queryInterval;
  private Vertex na, nb, ns, ne;
  private PathQueryType type;
  private D d;

  public QueryExecutor(VolatileIndex index, Interval queryInterval,
                       Vertex na, Vertex nb, PathQueryType type) {
    this.index = index;
    this.queryInterval = queryInterval;
    this.na = na;
    this.nb = nb;
    this.type = type;
    this.d = null;
  }

  public DEntry execute() throws Exception {
    // Get the nodes
    VolatileIndexKey keyS = index.getIndexKey(na.getId());
    VolatileIndexKey keyE = index.getIndexKey(nb.getId());
    if (keyS == null || keyE == null) {
      return null;
    }
    ns = ((INVersionNode) keyS.getNodes().first()).getVertex();
    ne = ((INVersionNode) keyE.getNodes().first()).getVertex();

    // Set the correct order of the nodes
    if (ns.getTimestamp() > ne.getTimestamp()) {
      Vertex tmpNs = ne;
      ne = ns;
      ns = tmpNs;
    }

    // Get the intervals
    List<Interval> tmpIntervals = index.getNodeLifetimes(ns);  // Start node lifetimes
    tmpIntervals.add(queryInterval);  // query interval
    tmpIntervals.addAll(index.getNodeLifetimes(ne));  // Goal node lifetimes
    Interval nsInterval = Interval.getIntersection(tmpIntervals);  // should be a list of intervals

    Set<Edge> el = index.getAliveEdges(nsInterval);

    d = new D();
    d.addDEntry(new DEntry(ns.getId(), nsInterval, false, type));

    while (true) {
      DEntry tuple = d.getFirstNotVisited();
      if (tuple == null) {
        break;
      }
      tuple.setVisited(true);

      Iterator<Edge> edgeIterator = el.iterator();
      boolean processingEdgeToEnd = false;
      Edge edgeToEnd = null;
      Edge currentEdge = null;
      if (edgeIterator.hasNext()) {
        currentEdge = edgeIterator.next();
      }
      while (currentEdge != null) {
        if (currentEdge.reachesNode(tuple.getVertex())
            && currentEdge.reachesNode(ne.getId())) {
          // It's an edge to the end node. We must process it last
          if (edgeToEnd != null && !edgeToEnd.getId().equals(currentEdge.getId())) {
            // No other edge should reach the end vertex from this vertex.
            throw new RuntimeException("More than one edges to end");
          }
          edgeToEnd = currentEdge;

          if (edgeIterator.hasNext()) {
            currentEdge = edgeIterator.next();
            continue;
          }
        }

        if (!currentEdge.reachesNode(tuple.getVertex())) {
          // Edge doesn't reach the vertex we process
          if (edgeIterator.hasNext()) {
            // If there are more edges continue with them
            currentEdge = edgeIterator.next();
            continue;
          } else if (edgeToEnd != null) {
            // If there aren't, check if there is an edge to end-vertex to process
            currentEdge = edgeToEnd;
            processingEdgeToEnd = true;
          } else {
            // If there isn't, go on with the next tuple
            break;
          }
        }

        DEntry r = processEdgeForTuple(currentEdge, tuple);
        if (r != null) {
          return r;
        }

        // Continue the iteration over the edges (if possible)
        if (edgeIterator.hasNext()) {
          currentEdge = edgeIterator.next();
        } else if (edgeToEnd != null && !processingEdgeToEnd) {
          currentEdge = edgeToEnd;
          processingEdgeToEnd = true;
        } else {
          currentEdge = null;  // break could be used as well
        }

      }  // end of while
    }  // end of while
    return null;
  }

  private DEntry processEdgeForTuple(Edge currentEdge, DEntry tuple) throws Exception {
    String nFound = currentEdge.getIdA();
    if (tuple.getVertex().equals(nFound)) {
      nFound = currentEdge.getIdB();
    }

    Interval nsNfInterval = Interval.getIntersection(currentEdge.getLifetime(),
                                                     tuple.getInterval());
    if (nsNfInterval == null) {
      return null;  // continue with the next edge
    }

    boolean addVisitedTuple = false;

    if (type == PathQueryType.EARLIEST) {

      if (nFound.equals(ne.getId()) && queryInterval.contains(nsNfInterval)) {
        DEntry tmpNotVisited = d.getEarlierThan(nsNfInterval.getStart() - 1, false);
        if (tmpNotVisited != null) {
          addVisitedTuple = true;
        } else {
          DEntry tmpVisited = d.getEarlierThan(nsNfInterval.getStart() - 1, true, nFound);
          if (tmpVisited != null) {
            return tmpVisited;
          } else {
            List<String> p = new LinkedList<>(tuple.getPath());
            p.add(nFound);
            return new DEntry(nFound, p, nsNfInterval, true, type);
          }
        }
      }
    } else {
      // SHORTEST, REACHABILITY & CONTINUOUS path queries
      if (nFound.equals(ne.getId())
          && ((type == PathQueryType.SHORTEST && queryInterval.contains(nsNfInterval))
              || (type == PathQueryType.REACHABILITY && queryInterval.contains(nsNfInterval))
              || (type == PathQueryType.CONTINUOUS && queryInterval.equals(nsNfInterval)))) {
        List<String> p = new LinkedList<>(tuple.getPath());
        p.add(nFound);
        return new DEntry(nFound, p, nsNfInterval, false, type);
      } else if (type == PathQueryType.CONTINUOUS && (d.contains(nFound)
                                                      || !queryInterval.equals(nsNfInterval))) {
        return null;  // continue with the next edge
      }
    }

    List<String> p = new LinkedList<>(tuple.getPath());
//    Vertex nFoundVertex = index.getFirstVersionNode(nFound);
    if (p.contains(nFound) || nFound.equals(ns.getId())) {
      // Avoid circles
      return null;  // continue with the next edge
    }
    p.add(nFound);
    d.addDEntry(new DEntry(nFound, p, nsNfInterval, addVisitedTuple, type));
    return null;
  }
}
