package gr.tuc.softnet.ap0n.index;

//import com.sleepycat.persist.model.Entity;
//import com.sleepycat.persist.model.PrimaryKey;
//import com.sleepycat.persist.model.Relationship;
//import com.sleepycat.persist.model.SecondaryKey;

//import org.hibernate.search.annotations.Analyze;
//import org.hibernate.search.annotations.DocumentId;
//import org.hibernate.search.annotations.Field;
//import org.hibernate.search.annotations.Index;
//import org.hibernate.search.annotations.Indexed;
//import org.hibernate.search.annotations.Store;

import java.io.Serializable;
import java.util.TreeSet;

import gr.tuc.softnet.ap0n.index.imp.INVersionNode;
import gr.tuc.softnet.ap0n.index.inf.INNode;

/**
 * Created by Apostolos Nydriotis on 2014/11/20.
 */

//@Entity  // berkeleyDB
//@Indexed  // hibernate search
public class VolatileIndexKey implements Serializable, Comparable<VolatileIndexKey> {

  TreeSet<INNode> nodes;  // Sorted by timestamp

//  @PrimaryKey  // berkeleyDB
//  @DocumentId  // hibernate search
  private String id;

//  @SecondaryKey(relate = Relationship.MANY_TO_ONE)  // berkeleyDB
//  @Field(gr.tuc.softnet.ap0n.index = Index.YES, analyze = Analyze.NO, store = Store.YES)  // hibernate search
  private long timestamp;

  public VolatileIndexKey() {
    nodes = new TreeSet<INNode>();
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(long timestamp) {
    this.timestamp = timestamp;
  }

  public void addNode(INNode newNode) {
    nodes.add(newNode);
  }

  public TreeSet<INNode> getNodes() {
    return nodes;
  }

  public boolean isAlive(long timestamp) {
    boolean isAlive = false;
    for (INNode n : nodes) {
      if (n.getType() == IndexNodeType.VERSION) {
        if (n.getTimestamp() <= timestamp) {
          INVersionNode v = (INVersionNode) n;
          if (v.isDeletion()) {
            isAlive = false;
          } else {
            isAlive = true;
          }
        }
      }
      if (n.getTimestamp() >= timestamp) {
        break;
      }
    }
    return isAlive;
  }

  @Override
  public int compareTo(VolatileIndexKey o) {
    if (this.timestamp != o.timestamp) {
      return (int) (this.timestamp - o.timestamp);
    }
    return this.id.compareTo(o.id);
  }
}
