package gr.tuc.softnet.ap0n.index.imp;

import java.util.HashMap;
import java.util.Map;

import gr.tuc.softnet.ap0n.graph.Edge;

/**
 * Created by ap0n on 16/5/2016.
 */
public class IEEdgeNode {
  private long timestamp;
  private Map<String, Edge> unbounded;  // F list
  private Map<String, Edge> bounded;  // C list. Timestamp of edges is the deletion timestamp

  public IEEdgeNode() {
    timestamp = 0;
    unbounded = new HashMap<>();
    bounded = new HashMap<>();
  }

  public IEEdgeNode(long timestamp) {
    this.timestamp = timestamp;
    unbounded = new HashMap<>();
    bounded = new HashMap<>();
  }

  public long getTimestamp() {
    return timestamp;
  }

  public void addUnboundedEdge(Edge edge) {
    unbounded.put(getIdForEdge(edge), edge);
  }

  public void expireEdge(Edge edge) {
    moveTobounded(edge);
  }

  public Long getDeletionTimestamp(Edge edge) {
    String edgeId = getIdForEdge(edge);
    Edge e = unbounded.get(edgeId);
    if (e == null) {
      // Edge is bounded or instant
      e = bounded.get(edgeId);
      if (e == null) {
        throw new RuntimeException("Edge not in I-E!");
      }
      return e.getTimestamp();
    } else {
      // Edge is unbounded
      return null;
    }
  }

  public Map<String, Edge> getUnbounded() {
    return unbounded;
  }

  public Map<String, Edge> getBounded() {
    return bounded;
  }

  @Override
  public String toString() {
    StringBuilder s = new StringBuilder();
    s.append("t: ").append(timestamp).append("\tUnbounded: ");
    for (Edge e : unbounded.values()) {
      s.append(e.toString()).append(" ");
    }
    s.append("\n\tBounded:");
    for (Edge e : bounded.values()) {
      s.append(" ").append(e.toString());
    }
    return s.append("\n").toString();
  }

  private void moveTobounded(Edge edge) {
    String edgeId = getIdForEdge(edge);
    Edge removed = unbounded.remove(edgeId);
    if (removed == null) {
      throw new RuntimeException("Trying to remove a non existing edge! " + edge.toString());
    }
    // Not inserting removed so that the timestamp of the inserted edge is that of the deletion
    removed.getLifetime().setEnd(edge.getTimestamp());
    removed.setTimestamp(edge.getTimestamp());  // TODO: Maybe not necessary
    bounded.put(edgeId, removed);
  }

  private String getIdForEdge(Edge edge) {
    return edge.getIdA() + "," + edge.getIdB();
  }
}
