package gr.tuc.softnet.ap0n.index.imp;

//import com.sleepycat.persist.model.Persistent;

import java.io.Serializable;

import gr.tuc.softnet.ap0n.index.EdgeOperation;
import gr.tuc.softnet.ap0n.index.IndexNodeType;

/**
 * Created by Apostolos Nydriotis on 2015/05/14.
 */
//@Persistent  // BerkeleyDB
public class INEdgeNode extends INNodeBase {

  private String neighbourId;
  private EdgeOperation operation;

  public INEdgeNode() {}

  public INEdgeNode(String neighbourId, EdgeOperation operation, long timestamp) {
    this.timestamp = timestamp;
    this.neighbourId = neighbourId;
    this.operation = operation;
  }

  public INEdgeNode(INEdgeNode o) {
    this.timestamp = o.timestamp;
    this.neighbourId = o.neighbourId;
    this.operation = o.operation;
  }

  public IndexNodeType getType() {
    return IndexNodeType.EDGE;
  }

  public String getId() {
    return neighbourId;
  }

  public EdgeOperation getOperation() {
    return operation;
  }

  @Override
  public String toString() {
    if (operation == EdgeOperation.DELETION) {
      return "-" + "(id:" + neighbourId + ",t:" + timestamp + ")";
    }
    return "+" + "(id:" + neighbourId + ",t:" + timestamp + ")";
  }

  public void setTimestamp(long timestamp) {
    this.timestamp = timestamp;
  }
}
