package gr.tuc.softnet.ap0n.index.imp;

//import com.sleepycat.persist.model.Persistent;

import gr.tuc.softnet.ap0n.index.IndexNodeType;
import gr.tuc.softnet.ap0n.index.inf.INNode;

/**
 * Created by Apostolos Nydriotis on 2015/05/14.
 */
//@Persistent
public abstract class INNodeBase implements INNode {
  protected long timestamp;

  public long getTimestamp() {
    return timestamp;
  }

  /**
   * @param other IndexNode to compare to this IndexNode
   * @return 0 -1, +1 if this is equal to, less than, or more than the other respectively
   */
  public int compareTo(INNode other) {
    if (this.getTimestamp() > other.getTimestamp()) {
      return 1;
    } else if (this.getTimestamp() < other.getTimestamp()) {
      return -1;
    }

    if (getType() == IndexNodeType.VERSION && other.getType() == IndexNodeType.EDGE) {
      // For equal timestamps, version nodes should precede edge nodes
      return -1;
    } else if (getType() == IndexNodeType.EDGE && other.getType() == IndexNodeType.VERSION) {
      return 1;
    }

    return getId().compareTo(other.getId());
  }

}
