package gr.tuc.softnet.ap0n.index.imp;

//import com.sleepycat.persist.model.Persistent;

import gr.tuc.softnet.ap0n.graph.Vertex;
import gr.tuc.softnet.ap0n.index.IndexNodeType;

/**
 * Created by Apostolos Nydriotis on 2014/11/20.
 */
//@Persistent  // BerkeleyDB
public class INVersionNode extends INNodeBase {

  private boolean deletion;
  private Vertex vertex;

  @Override
  public long getTimestamp() {
    return vertex.getTimestamp();
  }

  public IndexNodeType getType() {
    return IndexNodeType.VERSION;
  }

  public boolean isDeletion() {
    return deletion;
  }

  public void setDeletion(boolean deletion) {
    this.deletion = deletion;
  }

  public String getId() {
    return vertex.getId();
  }

  public void setId(String id) {
    vertex.setId(id);
  }

  public Vertex getVertex() {
    return vertex;
  }

  public void setVertex(Vertex vertex) {
    this.vertex = vertex;
  }

  @Override
  public String toString() {
    if (deletion) {
      return "-" + vertex.toString();
    }
    return "+" + vertex.toString();
  }
}
