package gr.tuc.softnet.ap0n.kat.data;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;

import gr.tuc.softnet.ap0n.graph.Edge;
import gr.tuc.softnet.ap0n.graph.Vertex;
import gr.tuc.softnet.ap0n.kat.utilities.GlobalProperties;

public class Bibliographic extends ModificationLists {

  public final static int CURRENTYEAR = 2020;
  public final static int LINESTOPROCESS = 100000;

  public final static String POSITIONS[][] = {
      {"master student", "PhD student"},
      {"senior researcher", "research collaborator"},
      {"research collaborator", "adjunct faculty"},
      {"academic staff", "principal research scientist"}
  };
  PrintWriter writer;
  Random randomGenerator = new Random();
  private ArrayList<String> tmp_authors = new ArrayList<String>();
  private ArrayList<Vertex> tmp_authors_thevertexobject = new ArrayList<Vertex>();

  private ArrayList<String> tmp_coauthors_previousyear = new ArrayList<String>();
  private ArrayList<String> tmp_coauthors_currentyear = new ArrayList<String>();
  private ArrayList<Edge> tmp_coauthors_theedgeobject = new ArrayList<Edge>();

  private Object[] delCoauthorsPerYear = new Object[CURRENTYEAR];
  private Object[]
      newCoauthorsPerYear =
      new Object[CURRENTYEAR];
  // I.e., year is the gr.tuc.softnet.ap0n.index and content is {{authora, authorb}, {authora,authorc}, ...}
  //	private Object[] newAuthorsPerYear = new Object[CURRENTYEAR]; // I.e., year is the gr.tuc.softnet.ap0n.index and content is {authora, authorb, ...}
  private Object[]
      modAuthorValuesPerYear =
      new Object[CURRENTYEAR];
  // I.e., year is the gr.tuc.softnet.ap0n.index and content is {authora, authorb, ...}

  public Bibliographic(GlobalProperties.VG_Dataset dataset) throws Exception {
    super(dataset);
    // TODO Auto-generated constructor stub
  }

  public void processSourceFile() throws Exception {
    for (int i = 1900; i <= 2019; i++) {
      delCoauthorsPerYear[i] = new ArrayList<String[]>();
      newCoauthorsPerYear[i] = new ArrayList<String[]>();
      //newAuthorsPerYear[i] = new ArrayList<String>();
    }
    String FILE = GlobalProperties.DIR_ProjectDataset + "/" + dataset.name() + ".vg";
    writer = new PrintWriter(FILE, "UTF-8");
    loadFilePath();
    createModifications();
    writer.close();
  }

  public void createModifications() throws Exception {
    int randomInt = 0;
    tmp_coauthors_previousyear = new ArrayList<String>();
    tmp_coauthors_currentyear = new ArrayList<String>();

    for (int i = 1900; i <= 2019; i++) {
      ArrayList<Modification> mod_list = new ArrayList<Modification>();
      //modAuthorValuesPerYear[i]= new ArrayList<String[]>();
      System.out.println("\nYEAR " + i);

      ArrayList<String[]> coauthors_list = (ArrayList<String[]>) newCoauthorsPerYear[i];
      //System.out.print("\nnew coauthors: " );
      for (String[] coauthor_pair : coauthors_list) {
        tmp_coauthors_currentyear
            .add(coauthor_pair[0] + GlobalProperties.DELIMITER_Attributes + coauthor_pair[1]);
        System.err.println("..." + coauthor_pair[0] + ".");
        System.err.println("..." + coauthor_pair[1] + ".");
        int pos_a = tmp_authors.indexOf(coauthor_pair[0]);
        int pos_b = tmp_authors.indexOf(coauthor_pair[1]);
        System.err.println(tmp_authors.size() + " " + tmp_authors_thevertexobject.size());
        System.err.println(pos_a + "  " + pos_b);
        Vertex va = tmp_authors_thevertexobject.get(pos_a);
        if (va == null) {
          Modification mod = new Modification();
          String[] tmp = POSITIONS[0];
          //int l = tmp.length;
          //l =  randomGenerator.nextInt(l);
          String position = POSITIONS[0][randomGenerator.nextInt((POSITIONS[0]).length)];
          String[] attributes = {"position=" + position};
          va = mod.addVertex(coauthor_pair[0], i, attributes);
          writer.write(mod.toString(i));
          tmp_authors_thevertexobject.set(pos_a, va);
          System.err.println(pos_a + " is now " + tmp_authors_thevertexobject.get(pos_a).getId());
          mod_list.add(mod);
          generateVertexValueMofications(coauthor_pair[0], i);
        }
        Vertex vb = tmp_authors_thevertexobject.get(pos_b);
        if (vb == null) {
          Modification mod = new Modification();
          String position = POSITIONS[0][randomGenerator.nextInt((POSITIONS[0]).length)];
          String[] attributes = {"position=" + position};
          vb = mod.addVertex(coauthor_pair[1], i, attributes);
          writer.write(mod.toString(i));
          tmp_authors_thevertexobject.set(pos_b, vb);
          System.err.println(pos_b + " is now " + tmp_authors_thevertexobject.get(pos_b).getId());
          mod_list.add(mod);
          generateVertexValueMofications(coauthor_pair[1], i);
        }

        Modification mod = new Modification();
        mod.addEdge(va, vb);
        writer.write(mod.toString(i));
        mod_list.add(mod);
        //System.out.print(coauthor_pair[0] + "+" + coauthor_pair[1] + "; ");
      }

      for (int l = 0; l < tmp_coauthors_previousyear.size(); l++) {
        String coauthor_label = tmp_coauthors_previousyear.get(l);
        if (!tmp_coauthors_currentyear.contains(coauthor_label)) {
          String[] coauthor_pair = {"", ""};
          coauthor_pair[0] =
              coauthor_label
                  .substring(0, coauthor_label.indexOf(GlobalProperties.DELIMITER_Attributes));
          coauthor_pair[1] =
              coauthor_label.substring(
                  GlobalProperties.DELIMITER_Attributes.length() + coauthor_label
                      .indexOf(GlobalProperties.DELIMITER_Attributes));
          //System.out.println("--> '"+coauthor_pair[0]+"'");
          //System.out.println("--> '"+coauthor_pair[1]+"'");
          int pos_a = tmp_authors.indexOf(coauthor_pair[0]);
          int pos_b = tmp_authors.indexOf(coauthor_pair[1]);
          if (pos_a != -1 && pos_b != -1) {
            Vertex va = tmp_authors_thevertexobject.get(pos_a);
            Vertex vb = tmp_authors_thevertexobject.get(pos_b);

            Modification mod = new Modification();
            mod.delEdge(va, vb);
            writer.write(mod.toString(i));
            mod_list.add(mod);
          }
        }
      }
      tmp_coauthors_previousyear = tmp_coauthors_currentyear;
      tmp_coauthors_currentyear = new ArrayList<String>();

      ArrayList<String[]> valueModifications = (ArrayList<String[]>) modAuthorValuesPerYear[i];
      if (valueModifications != null) {
        for (String[] modification : valueModifications) {
          Modification mod = new Modification();
          String[] attributes = {"position=" + modification[1]};
          mod.modVertexValue(modification[0], i, attributes);
          writer.write(mod.toString(i));
          mod_list.add(mod);
          System.out.println(
              "vertex '" + modification[0] + "' has new attr: position='" + modification[1] + "'");
        }
      }

      if (mod_list.size() != 0) {
        addModificationsForTime(i, mod_list);
      }

      mod_list = new ArrayList<Modification>();


    }


  }

  public void loadFilePath() throws Exception {
    String filepath = GlobalProperties.DBLP_XmlFile;
    BufferedReader br = new BufferedReader(new FileReader(filepath));
    StringBuilder sb = new StringBuilder();
    String line = br.readLine();

    int publication_counter = 0;
    int publication_year = 0;
    ArrayList<String> publication_authors = new ArrayList<String>();
    int cnt = 0;
    while (line != null && cnt <= LINESTOPROCESS) {
      sb.append(line);
      sb.append(System.lineSeparator());
      line = br.readLine();
      if (line.contains("key=\"")) {
        if (publication_authors.size() >= 2) {
          addCoauthors(publication_year, publication_authors);
          //System.out.print("==========\nnew publication in ");
          //System.out.println(publication_year + " with co-authors " + publication_authors.toString());
        }

        publication_year = 0;
        publication_authors = new ArrayList<String>();
        publication_counter++;
      }
      if (line.contains("<year>")) {
        String year = line.replace("<year>", "").replace("</year>", "").replace(" ", "");
        publication_year = Integer.parseInt(year);
      }
      if (line.contains("<author>")) {
        publication_authors.add(line.replace("<author>", "").replace("</author>", ""));
      }
      //System.out.println(line);
      cnt++;
    }
    br.close();
  }

  public void addCoauthors(int publication_year, ArrayList<String> publication_authors)
      throws Exception {
    //System.out.println(publication_authors);

    for (int i = 0; i < publication_authors.size(); i++) {
      String author_a = publication_authors.get(i);
      // check if author was already found, i.e., is contained in the tmp_authors
      // if not place him/her in the new authors for the particular year
      if (!tmp_authors.contains(author_a)) {
        tmp_authors.add(author_a);
        //System.err.println("->"+author_a+" "+(tmp_authors.size()-1)+"/");
        tmp_authors_thevertexobject.add(null);
        //System.err.println("->"+author_a+" "+(tmp_authors_thevertexobject.size()-1)+"/");
      }
      for (int j = i + 1; j < publication_authors.size(); j++) {
        //System.out.println(publication_authors.contains(i) + "     "  + publication_authors.contains(j));

        String author_b = publication_authors.get(j);
        if (!tmp_authors.contains(author_b)) {
          tmp_authors.add(author_b);
          //System.err.println("->"+author_b+" "+(tmp_authors.size()-1)+"/");
          tmp_authors_thevertexobject.add(null);
          //System.err.println("->"+author_b+" "+(tmp_authors_thevertexobject.size()-1)+"/");
        }
        String coauthorship_1 = author_a + " - " + author_b;
        String coauthorship_2 = author_b + " - " + author_a;
        if (!tmp_coauthors_currentyear.contains(coauthorship_1) && !tmp_coauthors_currentyear
            .contains(coauthorship_2)) {
          tmp_coauthors_currentyear.add(coauthorship_1);
          tmp_coauthors_currentyear.add(coauthorship_2);
          String[] c = {author_a, author_b};
          ArrayList<String[]>
              coauthors_of_year =
              (ArrayList<String[]>) newCoauthorsPerYear[publication_year];

          coauthors_of_year.add(c);
          newCoauthorsPerYear[publication_year] = coauthors_of_year;
        }
      }
    }
  }

  private void generateVertexValueMofications(String author, int year) throws Exception {

    int randomInt = 0;
    int years = 6;
    if ((years + year + 1) > CURRENTYEAR) {
      return;
    }
    for (int i = 1; i < POSITIONS.length; i++) {
      //randomInt = randomGenerator.nextInt((POSITIONS[i]).length);
      int after_years = randomGenerator.nextInt(years);
      String[] values = {author, POSITIONS[i][randomInt]};
      if ((ArrayList<String[]>) modAuthorValuesPerYear[year + after_years] == null) {
        modAuthorValuesPerYear[year + after_years] = new ArrayList<String[]>();
      }
      ((ArrayList<String[]>) modAuthorValuesPerYear[year + after_years]).add(values);
      years--;
    }
  }

}





