package gr.tuc.softnet.ap0n.kat.data;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;

import gr.tuc.softnet.ap0n.kat.utilities.GlobalProperties;

public class Financial extends ModificationLists {

  PrintWriter writer;
  private double correlation_threshold = 0.8;
  private int reporting_graphs = 20;


  public Financial(double ct, int rg, GlobalProperties.VG_Dataset dataset) throws Exception {
    super(dataset);
    correlation_threshold = ct;
    reporting_graphs = rg;
  }

  public void processSourceFile() throws Exception {

    String FILE = GlobalProperties.DIR_ProjectDataset + "/" + dataset.name() + ".vg";
    writer = new PrintWriter(FILE, "UTF-8");
    loadPathName();
    //loadAllStockNames();
    writer.close();
  }

  public void loadPathName() throws Exception {
    String filepath = GlobalProperties.DIR_ProjectDataset + "/" + dataset.name() + ".txt";
    ArrayList<String> found_stocks = new ArrayList<String>();

    BufferedReader br = new BufferedReader(new FileReader(filepath));
    String line = br.readLine();
    long current_timestamp = -1;
    ArrayList<String> previous_nodes = new ArrayList<String>();
    ArrayList<String> current_nodes = new ArrayList<String>();
    ArrayList<String> previous_edges = new ArrayList<String>();
    ArrayList<String> current_edges = new ArrayList<String>();
    int counter = 0;
    while (line != null) {
      counter++;
      ArrayList<String> attributes = separate(line, GlobalProperties.DELIMITER_Attributes);
      long found_timestamp = Long.parseLong(attributes.get(0).trim());
      if (current_timestamp == -1) {
        current_timestamp = found_timestamp;
      }

      if (found_timestamp != current_timestamp) {
        // include code here
        for (String previous_edge : previous_edges) {
          if (!current_edges.contains(previous_edge)) {
            ArrayList<String> sep = separate(previous_edge, GlobalProperties.DELIMITER_Attributes);
            if ((counter % reporting_graphs) == 0) {
//              System.err.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
//                                 + Modification.SingleMod.DISAPPEARING_EDGE
//                                 + GlobalProperties.DELIMITER_Attributes + sep.contains(0)
//                                 + GlobalProperties.DELIMITER_Attributes + sep.contains(1));
              writer.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
                             + Modification.SingleMod.DISAPPEARING_EDGE
                             + GlobalProperties.DELIMITER_Attributes + sep.get(0)
                             + GlobalProperties.DELIMITER_Attributes + sep.get(1));
            }
          }
        }
        for (String previous_node : previous_nodes) {
          if (!current_nodes.contains(previous_nodes)) {
            if ((counter % reporting_graphs) == 0) {
//              System.err.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
//                                 + Modification.SingleMod.DISAPPEARING_NODE
//                                 + GlobalProperties.DELIMITER_Attributes + previous_node);
              writer.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
                             + Modification.SingleMod.DISAPPEARING_NODE
                             + GlobalProperties.DELIMITER_Attributes + previous_node);
            }
          }
        }
        previous_nodes = current_nodes;
        current_nodes = new ArrayList<String>();
        previous_edges = current_edges;
        current_edges = new ArrayList<String>();
        current_timestamp = found_timestamp;
      }

      if (!found_stocks.contains(attributes.get(1))) {
        found_stocks.add(attributes.get(1));
        if ((counter % reporting_graphs) == 0) {
//          System.err.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
//                             + Modification.SingleMod.APPEARING_NODE
//                             + GlobalProperties.DELIMITER_Attributes + attributes.contains(1)
//                             + GlobalProperties.DELIMITER_Attributes + "provider=NasdaqGS");
          writer.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
                         + Modification.SingleMod.APPEARING_NODE
                         + GlobalProperties.DELIMITER_Attributes + attributes.get(1)
                         + GlobalProperties.DELIMITER_Attributes + "provider=NasdaqGS");
        }
      }
      if (!found_stocks.contains(attributes.get(2))) {
        found_stocks.add(attributes.get(2));
        if ((counter % reporting_graphs) == 0) {
//          System.err.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
//                             + Modification.SingleMod.APPEARING_NODE
//                             + GlobalProperties.DELIMITER_Attributes + attributes.contains(2)
//                             + GlobalProperties.DELIMITER_Attributes + "provider=NasdaqGS");
          writer.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
                         + Modification.SingleMod.APPEARING_NODE
                         + GlobalProperties.DELIMITER_Attributes + attributes.get(2)
                         + GlobalProperties.DELIMITER_Attributes + "provider=NasdaqGS");
        }
      }

      if (Double.parseDouble(attributes.get(3)) >= correlation_threshold) {
        current_nodes.add(attributes.get(1));
        current_nodes.add(attributes.get(2));
        current_edges
            .add(attributes.get(1) + GlobalProperties.DELIMITER_Attributes + attributes.get(2));
        if ((counter % reporting_graphs) == 0) {
//          System.err.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
//                             + Modification.SingleMod.APPEARING_EDGE
//                             + GlobalProperties.DELIMITER_Attributes + attributes.contains(1)
//                             + GlobalProperties.DELIMITER_Attributes + attributes.contains(2));
          writer.println(current_timestamp + GlobalProperties.DELIMITER_Attributes
                         + Modification.SingleMod.APPEARING_EDGE
                         + GlobalProperties.DELIMITER_Attributes + attributes.get(1)
                         + GlobalProperties.DELIMITER_Attributes + attributes.get(2));
        }
      }
      line = br.readLine();
    }
    br.close();
  }


  public void loadAllStockNames() throws Exception {
    String filepath = GlobalProperties.DIR_ProjectDataset + "/" + dataset.name() + ".txt";

    BufferedReader br = new BufferedReader(new FileReader(filepath));
    String line = br.readLine();
    while (line != null) {
      ArrayList<String> attributes = separate(line, GlobalProperties.DELIMITER_Attributes);
      //    if ( !all_stock_names.contains(attributes.contains(1)) )  all_stock_names.add(attributes.contains(1));
      //  if ( !all_stock_names.contains(attributes.contains(2)) )  all_stock_names.add(attributes.contains(2));
      line = br.readLine();
    }
    br.close();
  }


}
