/*
 ============================================================================
 Name        : Hayashi_Yoshida_time_window.c
 Author      : Gregory Chrysos
 Version     :
 Copyright   : TSI-MHL Technical University of Crete
 Description : Hayashi-Yoshida Algorithm over Time Window
 ============================================================================
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <stddef.h>
//#include <mysql.h>
//#include <my_global.h>


////////////////////////////////USER DEFINED VARIABLES
#define NO_STOCKS 1000 			//MAX NUMBER OF INPUT STOCK MARKETS
#define NO_TRANSACTIONS 3000000 //MAX NUMBER OF TRANSACTIONS
#define WINDOW_SIZE 30			//SIZE OF PROCESSING WINDOW IN SECONDS
//////////////////////////////

float q[NO_STOCKS][WINDOW_SIZE + 2][2]; // the queues that keep the transactions of each stock market
int rear[NO_STOCKS], front[NO_STOCKS];  //the pointers for the queues
int max_queue_size = WINDOW_SIZE + 2;  //The max queue size must be at least 2 more than WINDOW_SIZE

void enqueue(int stock_id, float new_value, float timestamp);
void dequeue(int stock_id);
void qdisplay(int stock_id);
void hayashi_software(int starting_window_point, int ending_window_point, float **correlation);

double t1_total, t2_total, total_time_hw = 0, total_time_sw = 0;

int main(int argc, char *argv[])
{
	int cnt = 0;
	//fprintf(stdout, "%s\n", "started");
/*
		MYSQL *con = mysql_init(NULL);
		if (con == NULL)  {
			fprintf(stderr, "%s\n", mysql_error(con));
			exit(1);
		}
		if (mysql_real_connect(con, "localhost", "ioannou", "root.kat*",
		          "dynamicgraphs", 0, NULL, 0) == NULL) {
			finish_with_error(con);
		}
		if (mysql_query(con, "INSERT INTO `dynamicgraphs`.`syntheticaedge`"
				"(`timestamp`,`nodeA`,`nodeB`,`type`)"
				"VALUES('2010','a','b','d');")) {
			finish_with_error(con);
		}
		exit(1);
*/
	FILE *fp, * fp1;
	char **stocks, stock_name[100];
	unsigned int transaction_time_hour, transaction_time_min, transaction_time_sec;
	char buffer[500];
	float stock_value;
	int i = 0, j = 0, k = 0;

	float **streaming_data;
	float **correlation;

	printf("\nusage: HayashiYoshidaTimeWindow filewithticks filetowritecorrelations");
	printf("\nE.g., HayashiYoshidaTimeWindow.exe C:/katerina/eclipse/montage/volatile-graphs/datasets/Synthetic1000.txt   C:/katerina/eclipse/montage/volatile-graphs/datasets/Correlations_Synthetic1000.txt");


	printf("\n");

///////////////////////////////////////////////////////////////////INPUT DATASETS AND OUTPUT FILE
	//fp = fopen("INPUT/input_dataset_2.txt","r");
	//fp = fopen("C:/Users/katerina/Desktop/INPUT/input_dataset_1000.txt","r");
	//fp1 = fopen("C:/Users/katerina/Desktop/INPUT/Correlation_results.txt","w");
	fp = fopen(argv[1],"r");
	fp1 = fopen(argv[2],"w");

/////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////Create Correlation Matrix
	correlation = (float**) malloc(NO_STOCKS*sizeof(float*));
	for (i = 0; i < NO_STOCKS; i++)
	{
		correlation[i] = (float*) malloc(NO_STOCKS*sizeof(float));
	}
/////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////Initialise Queues
	for (i = 0; i < NO_STOCKS; i++)
	{
		rear[i] = -1;
		front[i] = -1;
	}
/////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////Create data streaming array
	streaming_data = (float**) malloc(NO_TRANSACTIONS*sizeof(float *));
	for (i = 0; i < NO_TRANSACTIONS; i++)
	{
		streaming_data[i] = (float*) malloc(3*sizeof(float));
	}
/////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////Create the stock markets array
	stocks = (char**) malloc(NO_STOCKS*sizeof(char*));
	for (i = 0; i < NO_STOCKS; i++)
	{
		stocks[i] = (char*) malloc(100*sizeof(char));
	}
////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////Reading the streaming data and parsing
	if (fp == NULL)
	{
		printf("Error reading\n");
		exit(-1);
	}
	j = 0;

	int last_stock_id = 0;
	float last_stock_market = -1;
	float last_time_transaction = -1;

	while(!feof(fp))
	{

		fscanf(fp, "%s[^ ]", buffer);


		k = 0;
		i = 0;
		while(buffer[k] != ',')
		{
			stock_name[i] = buffer[k];
			//printf("%s\n",stock_name);
			k++;
			i++;
		}
		stock_name[i] = '\0';

		k++;
		while(buffer[k] != ',')
		{
			k++;
		}

		k++;
		transaction_time_hour = atoi(&buffer[k]);

		while(buffer[k] != ':')
		{
			k++;
		}

		k++;
		transaction_time_min = atoi(&buffer[k]);

		while(buffer[k] != ':')
		{
			k++;
		}

		k++;
		transaction_time_sec = atoi(&buffer[k]);

		k++;

		while(buffer[k] != ',')
		{
			k++;
		}
		k++;
		stock_value = atof(&buffer[k]);



		for (i = 0; i < NO_STOCKS; i++)
		{
			if (strcmp(stock_name, stocks[i]) == 0)
				break;
		}

		if(i == NO_STOCKS)
		{
			strcpy(stocks[last_stock_id], stock_name);
			i = last_stock_id;
			last_stock_id ++;
		}

		if(last_stock_market == i && last_time_transaction == (float)(transaction_time_hour*3600 + transaction_time_min*60 + transaction_time_sec))
		{
			continue;
		}
		else
		{
			last_stock_market = i;
			last_time_transaction = (float)(transaction_time_hour*3600 + transaction_time_min*60 + transaction_time_sec);

			streaming_data[j][0] = (float)i;
			streaming_data[j][1] = (float)(transaction_time_hour*3600 + transaction_time_min*60 + transaction_time_sec);
			streaming_data[j][2] = stock_value;

			j++;
		}
		if(j == NO_TRANSACTIONS-1)
			break;
	}

	fclose(fp);


/*
	fp = fopen("Symbollist.txt","w");

	for(j = 0; j < last_stock_id; j++)
	{
		fprintf(fp, "%s\n",stocks[j]);
	}

	fclose(fp);
*/
	int total_no_transactions = j;

///////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////Prepare the data and move the processing window
	int last_timestamp = (int)streaming_data[total_no_transactions-1][1];

	//compute the correlation per second
	for(i = (int)streaming_data[0][1]; i <= last_timestamp; i++)
	{
		//Insert new transactions in the corresponding queues
		for(j = 0; j < total_no_transactions; j++)
		{
			if((int)streaming_data[j][1] == i && q[(int)streaming_data[j][0]][rear[(int)streaming_data[j][0]]%max_queue_size][1] != streaming_data[j][1]) //if the transaction took place in this processed timestamp then add the new transaction into the corresponding queue
			{
				enqueue((int)streaming_data[j][0], streaming_data[j][2], streaming_data[j][1]);
			}

		}

		if(i - WINDOW_SIZE >= 0) //This takes place only when the complete processing window is inside the "time"
		{
			for(j = 0; j < NO_STOCKS; j++) //We check all the stocks for finding transactions that took place outside the processing window
			{
				if(front[j] != -1 && rear[j] != -1) //if the queue is not empty
				{
					if(front[j] != rear[j]) // Process only if we have a time interval(at least two timestamps-transactions)
					{
						int counter = 0;
						for(k=front[j];k<=rear[j];k++) //Scan all the transactions of the j Stock market
						{
							if(q[j][k%max_queue_size][1] <= i - WINDOW_SIZE)  //if the element is smaller or equal to the i-WINDOW_SIZE,
							{										//then this timestamp is considered to be outside the window
								counter++;
							}
						}


						if(counter == 2) //If we have two elements outside the window, we just omit the first one.
						{
							dequeue(j);
						}
						else if(counter > 2) //At each timestamp, we cannot omit two timestamps in row!
						{
							printf("ERROR!!");
							exit(-1);
						}
					}
				}
			}
		}

		hayashi_software(i, i - WINDOW_SIZE, correlation); //Calculate the HY correlation

//////////////////////////////////////////////////////////////////////////////////////////////////Printing correlation results at each timestamp

		//printf("\nTIMESTAMP: %d ####################################\n",i);

		//if ( cnt==REPORTING_TIMES ) {
			//cnt = 0;
			printf("%d \n", i);
			//printf("\nTIMESTAMP: %d ####################################\n", i);
			for(j = 0; j < last_stock_id; j++)
			{
				for(k = j+1; k < last_stock_id; k++)
				{
					if(correlation[j][k] != (float)0)
					{
						//if ( correlation[j][k]>=CORRELATION_THRESHOLD ) {
							//printf("%d %s %s %s %s\n", i, "$*^&#", stocks[j], "$*^&#", stocks[k]);
							fprintf(fp1,"%d %s %s %s %s %s %f\n", i, " ::-$%$-|| ", stocks[j], " ::-$%$-|| ", stocks[k], " ::-$%$-|| ", correlation[j][k]);
						//} else {
						//	;
						//}
					}
				}
			}

		//} else {
			//printf("\nskiping TIMESTAMP: %d ####################################\n", i);
		//	cnt = cnt + 1;
		//}


/////////////////////////////////////////////////////////////////////////////
	}

	printf("%s \n", "DONE");
	fclose(fp1);
	//mysql_close(con);
	return 0;
}

void hayashi_software(int starting_window_point, int ending_window_point, float **correlation)
{
	int i, j;
	int k, m;
	float cov_A = 0;
	float cov_B = 0;

	//Initialize the correlation matrix with zeros
	for(i = 0; i < NO_STOCKS; i++)
	{
		for(j = 0; j < NO_STOCKS; j++)
		{
			correlation[i][j] = 0;
		}
	}
	float max, min;

	for(i = 0; i < NO_STOCKS; i++) //Compute the HY correlation for all the combinations of the input stock markets
	{
		for(j = i+1; j < NO_STOCKS; j++)
		{
			cov_A = 0;
			cov_B = 0;

			if(front[i] != -1 && front[j] != -1) // if both the queues have at least a single value
			{
				for(k=front[i];k<=rear[i];k++) //Use all the timestamps for the 1st stock market
				{
					for(m =front[j];m<=rear[j];m++) //Use all the timestamps for the 2nd stock market
					{
						if((k+1) <= rear[i] && (m+1) <= rear[j]) //if there are time intervals for both the stock markets
						{
							//Find the maximum value between stock i and j for the timestamp k and m
							if(q[i][k%max_queue_size][1] >= q[j][m%max_queue_size][1])
								max = q[i][k%max_queue_size][1];
							else
								max = q[j][m%max_queue_size][1];

							//Find the minimum value between stock i and j for the timestamp k+1 and m+1
							if(q[i][(k+1)%max_queue_size][1] >= q[j][(m+1)%max_queue_size][1])
								min = q[j][(m+1)%max_queue_size][1];
							else
								min = q[i][(k+1)%max_queue_size][1];

							if(max < min)
							{
								correlation[i][j] = correlation[i][j] + (q[i][(k+1)%max_queue_size][0] - q[i][k%max_queue_size][0])*(q[j][(m+1)%max_queue_size][0] - q[j][m%max_queue_size][0]);
							}
						}
					}
				}

				for(k =front[i];k<=rear[i];k++) //Find all the time intervals that belong to the processing for the 1st stock and calculate the covariance of stock A
				{
					if((k+1) <= rear[i])
					{
						cov_A = cov_A + (q[i][(k+1)%max_queue_size][0] - q[i][k%max_queue_size][0])*(q[i][(k+1)%max_queue_size][0] - q[i][k%max_queue_size][0]);
					}
				}

				for(k =front[j];k<=rear[j];k++) //Find all the time intervals that belong to the processing for the 2nd stock and calculate the covariance of stock B
				{
					if((k+1) <= rear[j])
					{
						cov_B = cov_B + (q[j][(k+1)%max_queue_size][0] - q[j][k%max_queue_size][0])*(q[j][(k+1)%max_queue_size][0] - q[j][k%max_queue_size][0]);
					}
				}

				//Calculate the correlation value, only if the denominator is not zero
				if(cov_A != 0 && cov_B != 0)
					correlation[i][j] = correlation[i][j] / (sqrt(cov_A)*sqrt(cov_B));
				else
					correlation[i][j] = 0;

				//Bound the correlation values
				if(correlation[i][j] > 1)
					correlation[i][j] = 1;
				else if(correlation[i][j] < -1)
					correlation[i][j] = -1;
			}
		}
	}
}

//Add a new element to the Queue with id: stock_id
void enqueue(int stock_id, float new_value, float timestamp)
{
	if((rear[stock_id] + 1) % max_queue_size == front[stock_id] % max_queue_size)
	{
		printf("q overflow\n");
		exit(-1);
	}

	if(front[stock_id]==-1)
	{
	  front[stock_id]=rear[stock_id]=0;
	}
	else
	{
		rear[stock_id]++;
	}

	q[stock_id][rear[stock_id]%max_queue_size][0]=new_value;
	q[stock_id][rear[stock_id]%max_queue_size][1]=timestamp;
	return;
}

//Omit the first element from the Queue with id: stock_id
void dequeue(int stock_id)
{
     if(front[stock_id] > rear[stock_id])
     {
          printf("q underflow\n");
          exit(-1);
     }
     if(front[stock_id]%max_queue_size == rear[stock_id]%max_queue_size)
     {
    	 front[stock_id] = -1;
    	 rear[stock_id] = -1;
     }
     else
     {
    	 front[stock_id]++;
     }

     return;
}

//Print the elements of the stack with id stock_id
void qdisplay(int stock_id)
{
     int i;
     if(front[stock_id] != -1 )
     {
		 for(i=front[stock_id];i<=rear[stock_id];i++)
		 {
			  printf("%d\t%f\t%f\n",stock_id, q[stock_id][i%max_queue_size][0],q[stock_id][i%max_queue_size][1]);
		 }
     }
     return;
}



