package gr.tuc.softnet.ap0n.kat.data;

import gr.tuc.softnet.ap0n.graph.Edge;
import gr.tuc.softnet.ap0n.graph.Vertex;
import gr.tuc.softnet.ap0n.kat.utilities.GlobalProperties;

public class Modification {

  public SingleMod type;
  public Vertex vertex_A, vertex_B;
  public Edge edge;

  public Vertex addVertex(String author, long time, String[] attributes) throws Exception {
    Vertex v = new Vertex(author);
    v.setTimestamp(time);
    v.setAttributes(0, "name=" + author);
    for (int i = 0; i < attributes.length; i++) {
      v.setAttributes(i + 1, attributes[i]);
    }
    type = SingleMod.APPEARING_NODE;
    vertex_A = v;
//    System.out.println("add vertex for '" + author + "'");
    return v;
  }

  public void delVertex(Vertex v) throws Exception {
    type = SingleMod.DISAPPEARING_NODE;
    vertex_A = v;
//    System.out.println("delete vertex for '" + v.getId() + "'");
  }

  public void addEdge(Vertex va, Vertex vb) throws Exception {
    type = SingleMod.APPEARING_EDGE;
    vertex_A = va;
    vertex_B = vb;
//    System.out.println("add edge for '" + va.getId() + "+" + vb.getId() + "'");
  }

  public void delEdge(Vertex va, Vertex vb) throws Exception {
    try {
      type = SingleMod.DISAPPEARING_EDGE;
      vertex_A = va;
      vertex_B = vb;
//      System.out.println("delete edge between '" + va.getId() + "' and '" + vb.getId() + "'");
    } catch (Exception e) {
      e.printStackTrace();
      System.err.println("");
    }
  }

  public void modVertexValue(String author, long time, String[] attributes) throws Exception {
    Vertex v = new Vertex(author);
    v.setTimestamp(time);
    v.setAttributes(0, "name=" + author);
    for (int i = 0; i < attributes.length; i++) {
      v.setAttributes(i + 1, attributes[i]);
    }
    type = SingleMod.CHANGE_OF_NODE_VALUE;
    vertex_A = v;
//    System.out.println("updated values of vertex for '" + v.getId() + "'");
  }

  public void loadString(String line) throws Exception {
    String[] attribites = line.split(GlobalProperties.DELIMITER_Attributes);
    long timestamp = Integer.parseInt(attribites[0]);
  }

  public String toString(int timestamp) {
    String ans = "";

    if (type == SingleMod.APPEARING_EDGE) {
      ans +=
          timestamp + GlobalProperties.DELIMITER_Attributes + SingleMod.APPEARING_EDGE.name
          + GlobalProperties.DELIMITER_Attributes +
          vertex_A.getId() + GlobalProperties.DELIMITER_Attributes + vertex_B.getId() + "\n";
    } else if (type == SingleMod.APPEARING_NODE) {
      ans +=
          timestamp + GlobalProperties.DELIMITER_Attributes + SingleMod.APPEARING_NODE.name
          + GlobalProperties.DELIMITER_Attributes +
          vertex_A.getId();
      for (String attr : vertex_A.getAttributes()) {
        if (attr != null) {
          ans += GlobalProperties.DELIMITER_Attributes + attr;
        }
      }
      ans += "\n";
    } else if (type == SingleMod.DISAPPEARING_NODE) {
      ans +=
          timestamp + GlobalProperties.DELIMITER_Attributes + SingleMod.DISAPPEARING_NODE.name
          + GlobalProperties.DELIMITER_Attributes +
          vertex_A.getId() + "\n";
    } else if (type == SingleMod.DISAPPEARING_EDGE) {
      ans +=
          timestamp + GlobalProperties.DELIMITER_Attributes + SingleMod.DISAPPEARING_EDGE.name
          + GlobalProperties.DELIMITER_Attributes +
          vertex_A.getId() + GlobalProperties.DELIMITER_Attributes + vertex_B.getId() + "\n";
    } else if (type == SingleMod.CHANGE_OF_NODE_VALUE) {
      ans +=
          timestamp + GlobalProperties.DELIMITER_Attributes + SingleMod.CHANGE_OF_NODE_VALUE.name
          + GlobalProperties.DELIMITER_Attributes +
          vertex_A.getId();
      for (String attr : vertex_A.getAttributes()) {
        if (attr != null) {
          ans += GlobalProperties.DELIMITER_Attributes + attr;
        }
      }
      ans += "\n";
    } else if (type == SingleMod.CHANGE_OF_EDGE_VALUE) {
      ans +=
          timestamp + GlobalProperties.DELIMITER_Attributes + SingleMod.CHANGE_OF_EDGE_VALUE
          + GlobalProperties.DELIMITER_Attributes + "\n";
    }

    return ans;
  }

  public enum SingleMod {
    APPEARING_NODE("APPEARING_NODE"),
    APPEARING_EDGE("APPEARING_EDGE"),
    DISAPPEARING_NODE("DISAPPEARING_NODE"),
    DISAPPEARING_EDGE("DISAPPEARING_EDGE"),
    CHANGE_OF_NODE_VALUE("CHANGE_OF_NODE_VALUE"),
    CHANGE_OF_EDGE_VALUE("CHANGE_OF_EDGE_VALUE");

    private String name;

    private SingleMod(String s) {
      name = s;
    }
  }
}
