package gr.tuc.softnet.ap0n.kat.data;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

import gr.tuc.softnet.ap0n.graph.Vertex;
import gr.tuc.softnet.ap0n.kat.data.Modification.SingleMod;
import gr.tuc.softnet.ap0n.kat.utilities.GlobalProperties;

public class ModificationLists {

  protected GlobalProperties.VG_Dataset dataset;
  private ArrayList<Long> ListOfTimes;
  private ArrayList<ArrayList<Modification>> ListOfModifications;

  public ModificationLists(GlobalProperties.VG_Dataset ds) throws Exception {
    dataset = ds;
    ListOfTimes = new ArrayList<Long>();
    ListOfModifications = new ArrayList<ArrayList<Modification>>();
  }

  public void addModificationsForTime(long time, ArrayList<Modification> modifications)
      throws Exception {
    int pos = ListOfTimes.indexOf(time);
    if (pos == -1) {
      ListOfTimes.add(time);
    }
    ListOfModifications.add(modifications);
  }

  public ArrayList<Long> getListOfTimes() {
    return ListOfTimes;
  }

  public void addModificationForTime(long time, Modification modifications) throws Exception {
    int pos = ListOfTimes.indexOf(time);
    if (pos == -1) {
      ListOfTimes.add(time);
    }
    ArrayList<Modification> tmp = ListOfModifications.get(pos);
    tmp.add(modifications);
    ListOfModifications.set(pos, tmp);
  }

  public ArrayList<Modification> getModificationList(long time) throws Exception {
    int pos = ListOfTimes.indexOf(time);
    return ListOfModifications.get(pos);
  }

  public String toString() {
    String ans = "number of snapshots = " + ListOfTimes.size() + "\n";

    for (int i = 0; i < ListOfTimes.size(); i++) {
      ans += "snapshot '" + ListOfTimes.get(i) + "': ";
      int cnt_new_edges = 0, cnt_new_nodes = 0, cnt_del_nodes = 0, cnt_del_edges = 0,
          cnt_changes_nodes =
              0, cnt_change_edges = 0;
      ArrayList<Modification> list = ListOfModifications.get(i);
      for (int j = 0; j < list.size(); j++) {
        if (list.get(j).type == SingleMod.APPEARING_EDGE) {
          cnt_new_edges++;
        } else if (list.get(j).type == SingleMod.APPEARING_NODE) {
          cnt_new_nodes++;
        } else if (list.get(j).type == SingleMod.DISAPPEARING_NODE) {
          cnt_del_nodes++;
        } else if (list.get(j).type == SingleMod.DISAPPEARING_EDGE) {
          cnt_del_edges++;
        } else if (list.get(j).type == SingleMod.CHANGE_OF_NODE_VALUE) {
          cnt_changes_nodes++;
        } else if (list.get(j).type == SingleMod.CHANGE_OF_EDGE_VALUE) {
          cnt_change_edges++;
        }
      }
      ans += "new nodes=" + cnt_new_nodes + "; ";
      ans += "new edges=" + cnt_new_edges + "; ";
      ans += "del nodes=" + cnt_del_nodes + "; ";
      ans += "del edges=" + cnt_del_edges + "; ";
      ans += "node changes=" + cnt_changes_nodes + "; ";
      ans += "edge changes=" + cnt_change_edges + "; \n";
    }
    return ans;
  }

  public void loadFileVG() throws Exception {
    String filepath = GlobalProperties.DIR_ProjectDataset + "/" + dataset.name() + ".vg";
    BufferedReader br = new BufferedReader(new FileReader(filepath));
    String line = br.readLine();
    ArrayList<Modification> modifications = new ArrayList<Modification>();
    long current_timestamp = -1;
    while (line != null) {

      ArrayList<String> attributes = separate(line, GlobalProperties.DELIMITER_Attributes);
      long found_timestamp = Long.parseLong(attributes.get(0));
      Modification mod = new Modification();
      if (current_timestamp == -1) {
        current_timestamp = found_timestamp;
      }
      if (current_timestamp != found_timestamp) {
        ListOfTimes.add(found_timestamp);
        ListOfModifications.add(modifications);
        modifications = new ArrayList<Modification>();
        current_timestamp = Long.parseLong(attributes.get(0));
      }
      if (attributes.get(1).equals(Modification.SingleMod.APPEARING_NODE.name())) {
        String[] tmp = new String[attributes.size() - 3];
        for (int kk = 0; kk < attributes.size() - 3; kk++) {
          tmp[kk] = attributes.get(kk + 3);
        }
        mod.addVertex(attributes.get(2), found_timestamp, tmp);
      } else if (attributes.get(1).equals(Modification.SingleMod.DISAPPEARING_NODE.name())) {
        Vertex v = new Vertex(attributes.get(2));
        v.setTimestamp(current_timestamp);
        mod.delVertex(v);
      } else if (attributes.get(1).equals(Modification.SingleMod.APPEARING_EDGE.name())) {
        Vertex va = new Vertex(attributes.get(2));
        Vertex vb = new Vertex(attributes.get(3));
        mod.addEdge(va, vb);
      } else if (attributes.get(1).equals(Modification.SingleMod.DISAPPEARING_EDGE.name())) {
        Vertex va = new Vertex(attributes.get(2));
        Vertex vb = new Vertex(attributes.get(3));
        mod.delEdge(va, vb);
      } else if (attributes.get(1).equals(Modification.SingleMod.CHANGE_OF_NODE_VALUE.name())) {
        String[] tmp = new String[attributes.size() - 3];
        for (int kk = 0; kk < attributes.size() - 3; kk++) {
          tmp[kk] = attributes.get(kk + 3);
        }
        mod.modVertexValue(attributes.get(2), found_timestamp, tmp);
      }
      modifications.add(mod);
      line = br.readLine();
    }
    br.close();
  }

	/*
        public String toString() {
		String ans = "";

		for (int i=0; i<ListOfTimes.size(); i++) {

			ArrayList<Modification> list = ListOfModifications.contains(i);
			for (int j=0; j<list.size(); j++) {
				Modification mod = list.contains(j);
				if (mod.type==SingleMod.APPEARING_EDGE) {
					ans += i + GlobalProperties.DELIMITER_Attributes + "APPEARING_EDGE" + GlobalProperties.DELIMITER_Attributes +
							mod.vertex_A.getId() + GlobalProperties.DELIMITER_Attributes + mod.vertex_B.getId() + "\n";
				}
				else if (mod.type==SingleMod.APPEARING_NODE)  {
					ans += i + GlobalProperties.DELIMITER_Attributes + "APPEARING_NODE" + GlobalProperties.DELIMITER_Attributes +
							mod.vertex_A.getId() + GlobalProperties.DELIMITER_Attributes + mod.vertex_A.getAttribute(0) + "\n";
				}
				else if (mod.type==SingleMod.DISAPPEARING_NODE)  {
					ans += i + GlobalProperties.DELIMITER_Attributes + "DISAPPEARING_NODE" + GlobalProperties.DELIMITER_Attributes +
							mod.vertex_A.getId() + "\n";
				}
				else if (mod.type==SingleMod.DISAPPEARING_EDGE)  {
					ans += i + GlobalProperties.DELIMITER_Attributes + "DISAPPEARING_EDGE" + GlobalProperties.DELIMITER_Attributes +
							mod.vertex_A.getId() + GlobalProperties.DELIMITER_Attributes + mod.vertex_B.getId() + "\n";
				}
				else if (mod.type==SingleMod.CHANGE_OF_NODE_VALUE)  {
					ans += i + GlobalProperties.DELIMITER_Attributes + "CHANGE_OF_NODE_VALUE" + GlobalProperties.DELIMITER_Attributes +
							mod.vertex_A.getId() + GlobalProperties.DELIMITER_Attributes + mod.vertex_A.getAttribute(0) + "\n";
				}
				else if (mod.type==SingleMod.CHANGE_OF_EDGE_VALUE)  {
					ans += i + GlobalProperties.DELIMITER_Attributes + "CHANGE_OF_EDGE_VALUE" + GlobalProperties.DELIMITER_Attributes +  "\n";
				}
			}

		}
		return ans;
	}
	*/

  public ArrayList<String> separate(String text, String delimeter) throws Exception {
    ArrayList<String> result = new ArrayList<String>();
    int last_location = 0;
    int new_location = text.indexOf(delimeter);
    while (new_location != -1) {
      result.add(text.substring(last_location, new_location));
      text =
          text.substring(
              last_location + GlobalProperties.DELIMITER_Attributes.length() + new_location);
      last_location = 0;
      new_location = text.indexOf(delimeter);
    }
    result.add(text);
    return result;
  }

}

