package gr.tuc.softnet.ap0n.kat.utilities;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ApplProperties {

  private static String properties_file = null;
  public Properties properties;
  public Hashtable<String, DB> dbs;
  public ApplProperties() {
    try {
      properties_file =
          new String(System.getProperty("user.home") + System.getProperty("file.separator") +
                     "AppData" + System.getProperty("file.separator") + "eclipse" + System
                         .getProperty("file.separator") +
                     System.getProperty("user.dir").substring(1 + System.getProperty("user.dir")
                         .lastIndexOf((System.getProperty("file.separator"))))
                     + ".properties");
      System.out.println("Loading propetries from " + properties_file);
      //setLogger();
      FileInputStream propsFile;
      Properties tempProp = new Properties();
      propsFile = new FileInputStream(properties_file);
      tempProp.load(propsFile);
      set(tempProp);
      propsFile.close();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public String getValue(String attribute) throws Exception {
    return properties.getProperty(attribute);
  }

  public DB getDbInfo(String name) throws Exception {
    return dbs.get(name);
  }

  public DB loadDBInfo(Properties properties, String db_name) {
    DB db = new DB();
    db.server = properties.getProperty(db_name + ".server");
    db.dbms = properties.getProperty(db_name + ".dbms");
    db.driver = properties.getProperty(db_name + ".driver");
    db.dbname = properties.getProperty(db_name + ".dbname");
    db.username = properties.getProperty(db_name + ".username");
    db.port = properties.getProperty(db_name + ".port");
    db.password = properties.getProperty(db_name + ".password");
    db.tables = new ArrayList<String>();
    // int cnt_tables = Integer.parseInt(properties.getProperty(db_name
    // + ".tables"));
    // for (int i = 1; i <= cnt_tables; i++) {
    // db.tables.add(properties.getProperty(db_name + ".table." + i));
    // }

    return db;
  }

  public String readDatabase() {
    String value = "cora";
    try {
      BufferedReader br = new BufferedReader(new InputStreamReader(
          new DataInputStream(new FileInputStream(
              "C:\\Users\\ioannou\\AppData\\Ioannou\\EAQP.txt"))));
      String strLine = br.readLine();
      if (strLine != null) {
        value = strLine;
      }
      br.close();
      System.out.println(value);
      // if (value.equals("cora")) {
      // value = "prdata";
      // }
    } catch (Exception e) {
      e.printStackTrace();
      return value;
    }
    return value;
  }

  private void set(Properties properties) throws Exception {
    this.properties = properties;
    dbs = new Hashtable<String, DB>();
    Enumeration<Object> em = properties.keys();
    while (em.hasMoreElements()) {
      String str = (String) em.nextElement();
      if (str.contains(".db")) {
        dbs.put(properties.getProperty(str), loadDBInfo(properties, properties.getProperty(str)));
      }
    }

    //dbs.put(properties.getProperty("local.db"),
    //		loadDBInfo(properties, "local"));
    // dbs.put(properties.getProperty("localDB.db"),
    // loadDBInfo(properties, "localDB"));
    //dbs.put(properties.getProperty("imdb.db"),
    //		loadDBInfo(properties, "imdb"));
  }

  public class DB {

    public String server;
    public String dbms;
    public String driver;
    public String dbname;
    public String username;
    public String password;
    public String port;
    public ArrayList<String> tables;
  }

	/*private void setLogger() throws Exception {
                logger = Logger.getLogger("Entities ");
		SimpleLayout layout = new SimpleLayout();
		FileAppender appender = new FileAppender(layout, "logger.txt", false);
		logger.addAppender(appender);
		logger.setLevel(Level.ALL);
	}*/

}
