//package gr.tuc.softnet.ap0n.persistence.imp;
//
//import com.sleepycat.je.DatabaseException;
//import com.sleepycat.je.Environment;
//import com.sleepycat.je.EnvironmentConfig;
//import com.sleepycat.persist.EntityCursor;
//import com.sleepycat.persist.EntityStore;
//import com.sleepycat.persist.PrimaryIndex;
//import com.sleepycat.persist.SecondaryIndex;
//import com.sleepycat.persist.StoreConfig;
//
//import java.io.File;
//import java.util.ArrayList;
//import java.util.Iterator;
//import java.util.List;
//
//import gr.tuc.softnet.ap0n.index.VolatileIndexKey;
//import gr.tuc.softnet.ap0n.persistence.inf.DataAccessor;
//
///**
// * Created by Apostolos Nydriotis on 2014/11/20.
// */
//public class BerkeleyDBDataAccessor implements DataAccessor {
//
//  private File environmentHome;
//  private Environment environment;
//  private EntityStore store;
//  private PrimaryIndex<String, VolatileIndexKey> idIndex;
//  private SecondaryIndex<Long, String, VolatileIndexKey> timestampIndex;
//
//  public BerkeleyDBDataAccessor(String datastorePath) {
//    environmentHome = new File(datastorePath);
//  }
//
//  public void initialize() throws DatabaseException {
//    EnvironmentConfig environmentConfig = new EnvironmentConfig();
//    StoreConfig storeConfig = new StoreConfig();
//
//    environmentConfig.setAllowCreate(true);
//    storeConfig.setAllowCreate(true);
//
//    environment = new Environment(environmentHome, environmentConfig);
//    store = new EntityStore(environment, "entityStore", storeConfig);
//
//    idIndex = store.getPrimaryIndex(String.class, VolatileIndexKey.class);
//    timestampIndex = store.getSecondaryIndex(idIndex, Long.class, "timestamp");
//  }
//
//  public void shutdown() throws DatabaseException {
//    store.close();
//    environment.close();
//  }
//
//  public VolatileIndexKey fetchIndexKey(String id) throws DatabaseException {
//    return idIndex.get(id);
//  }
//
//  public void storeIndexKey(VolatileIndexKey key) throws DatabaseException {
//    idIndex.put(key);
//  }
//
//  public List<VolatileIndexKey> fetchIndex() throws DatabaseException {
//    List<VolatileIndexKey> r = new ArrayList<VolatileIndexKey>();
//    EntityCursor<VolatileIndexKey> cursor = timestampIndex.entities();
//    for (VolatileIndexKey i : cursor) {
//      r.add(i);
//    }
//    cursor.close();
//    return r;
//  }
//
//  public void clear() throws DatabaseException {
//    Iterator<String> iterator = idIndex.keys().iterator();
//    while (iterator.hasNext()) {
//      String key = iterator.next();
//      idIndex.delete(key);
//    }
//  }
//}
