package gr.tuc.softnet.ap0n.persistence.imp;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import gr.tuc.softnet.ap0n.index.VolatileIndexKey;
import gr.tuc.softnet.ap0n.persistence.inf.DataAccessor;

/**
 * Implements a DataAccessor that doesn't write data to disk
 *
 * Created by ap0n on 18/5/2016.
 */
public class MemmoryDataAccessor implements DataAccessor {

  private Map<String, VolatileIndexKey> index;

  public MemmoryDataAccessor() {
    this.index = new HashMap<>();
  }

  public void initialize() {}

  public void shutdown() throws Exception {}

  public VolatileIndexKey fetchIndexKey(String id) throws Exception {
    return index.get(id);
  }

  public void storeIndexKey(VolatileIndexKey key) throws Exception {
    index.put(key.getId(), key);
  }

  public List<VolatileIndexKey> fetchIndex() {
    List<VolatileIndexKey> res = new LinkedList<VolatileIndexKey>();
    res.addAll(index.values());
    return res;
  }

  public void clear() throws Exception {
    index.clear();
  }
}
