package gr.tuc.softnet.ap0n.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

/**
 * Created by ap0n on 1/6/2016.
 */
public class D {
  private TreeSet<DEntry> entries;
  private Map<String, DEntry> index;

  public D() {
    entries = new TreeSet<DEntry>();
    index = new HashMap<String, DEntry>();
  }

  public void addDEntry(DEntry e) {
    entries.add(e);
    index.put(e.getVertex(), e);
  }

  public DEntry getFirstNotVisited() {
    for (DEntry e : entries) {
      if (!e.isVisited()) {
        return e;
      }
    }
    return null;
  }

  public boolean contains(String id) {
    return index.containsKey(id);
  }

  /**
   * @param timestamp
   * @throws RuntimeException if type != EARLIEST
   * @return
   */
  public DEntry getEarlierThan(long timestamp, boolean visited) {
    return getEarlierThan(timestamp, visited, null);
  }

  /**
   * @param timestamp
   * @throws RuntimeException if type != EARLIEST
   * @return
   */
  public DEntry getEarlierThan(long timestamp, boolean visited, String id) {
    for (DEntry e : entries) {
      if (e.getPathQueryType() != PathQueryType.EARLIEST) {
        throw new RuntimeException("To be used only with EARLIEST paths");
      }

      if (e.isVisited() != visited) continue;  // not correct state (visited or not)
      if (id != null && !e.getVertex().equals(id)) continue;  // not correct id
      if (e.getInterval().getStart() == null || e.getInterval().getStart() <= timestamp) return e;
    }
    return null;
  }

  public void remove(String id) {
    entries.remove(index.remove(id));
  }
}
