package gr.tuc.softnet.ap0n.utils;

import java.util.LinkedList;
import java.util.List;

import gr.tuc.softnet.ap0n.graph.Vertex;

/**
 * Created by ap0n on 1/6/2016.
 */
public class DEntry implements Comparable<DEntry> {

  private String vertex;
  private List<String> path;
  private Interval interval;  // Could be a list
  private boolean visited;
  private PathQueryType pathQueryType;  // Used by the comparator

  public DEntry() {
    this.vertex = null;
    this.path = null;
    this.interval = null;
    this.pathQueryType = null;
  }

  public DEntry(String vertex, Interval interval, boolean visited, PathQueryType pathQueryType) {
    this.vertex = vertex;
    this.path = new LinkedList<String>();
    this.interval = interval;
    this.visited = visited;
    this.pathQueryType = pathQueryType;
  }

  public DEntry(String vertex, List<String> path, Interval interval, boolean visited,
                PathQueryType pathQueryType) {
    this(vertex, interval, visited, pathQueryType);
    this.path = path;
  }

  public String getVertex() {
    return vertex;
  }

  public void setVertex(String vertex) {
    this.vertex = vertex;
  }

  public Interval getInterval() {
    return interval;
  }

  public void setInterval(Interval interval) {
    this.interval = interval;
  }

  public boolean isVisited() {
    return visited;
  }

  public void setVisited(boolean visited) {
    this.visited = visited;
  }

  public List<String> getPath() {
    return path;
  }

  public void setPath(List<String> path) {
    this.path = path;
  }

  public PathQueryType getPathQueryType() {
    return pathQueryType;
  }

  public int compareTo(DEntry o) {
    if (pathQueryType != o.pathQueryType) {
      throw new RuntimeException("Trying to compare apples and oranges (different query types)");
    }

    if (pathQueryType == PathQueryType.EARLIEST) {
      if (interval.getStart() == null) {
        return -1;
      } else if (o.interval.getStart() == null) {
        return 1;
      } else if (interval.getStart() < o.interval.getStart()) {
        return -1;
      } else if (interval.getStart() == o.interval.getStart()) {
        if (interval.toString().compareTo(o.interval.toString()) == 0) {
          return vertex.compareTo(o.vertex);
        } else {
          return interval.toString().compareTo(o.interval.toString());
        }
      }
      return 1;

    } else if (pathQueryType == PathQueryType.SHORTEST) {
      if (path.size() < o.path.size()) {
        return -1;
      } else if (path.size() == o.path.size()) {
        int intervalComparison = interval.toString().compareTo(o.interval.toString());
        if (intervalComparison == 0) {
          return vertex.toString().compareTo(o.vertex.toString());
        } else {
          return intervalComparison;
        }
      }
      return 1;
    }
    // TODO: What about equals?
    return 1;  // For other type, we don't care about the ordering
  }

  @Override
  public String toString() {
    StringBuilder s = new StringBuilder();
    if (vertex == null) {
      s.append("NULL");
    } else {
      s.append(vertex);
    }
    s.append(" <");
    boolean isFirst = true;
    for (String n : path) {
      if (!isFirst) s.append(" ");
      isFirst = false;
      s.append(n);
    }
    s.append("> ").append(interval.toString()).append(" ");
    if (visited) {
      s.append("VISITED ");
    } else {
      s.append("NOT_VISITED ");
    }
    s.append(pathQueryType.toString());

    return s.toString();
  }
}
