/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.standalone.cmd;

import de.uni_hildesheim.sse.easy.loader.ManifestLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.logger.LoggingLevel;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.tracing.ConsoleTracerFactory;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.EASyPersistencer;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.datatypes.IProjectCreationResult;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.standalone.cmd.InstantiationCommands;
import net.ssehub.easy.standalone.cmd.LowlevelCommands;
import net.ssehub.easy.standalone.cmd.ModelLoadDefinition;
import net.ssehub.easy.standalone.cmd.ProjectCreationFlavour;
import net.ssehub.easy.standalone.cmd.ProjectNameMapper;
import net.ssehub.easy.standalone.cmd.ReasoningCommands;

public class CommandLineExecuter {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(CommandLineExecuter.class, "EASyCommandLine");
    private static final List<String> OPTIONS = new ArrayList<String>();
    private static final String OPT_RESULTFILE = "--resultFile";
    private static final boolean DEBUG = "DEBUG".equals(System.getProperty("de.uni_hildesheim.sse.easy.logging.level"));

    private static void printHelp() {
        System.out.println("Help (more infos in readme and programmers guide):");
        System.out.println(" - instantiate (source -> target):");
        System.out.println("   instantiate <src_folder> <trg_folder>");
        System.out.println("   instantiate <src_folder> <trg_folder> <absolute path to ivml_file>");
        System.out.println("     <absolute path to vil_file>");
        System.out.println("   instantiate <src_folder> <trg_folder> <ivml name> <ivml version>");
        System.out.println("     <vil name> <vil version>");
        System.out.println(" - self-instantiation (folder -> folder):");
        System.out.println("   instantiateSelf <project_folder>");
        System.out.println("   instantiateSelf <project_folder> <absolute path to ivml_file>");
        System.out.println("   instantiateSelf <project_folder> <absolute path to ivml_file>");
        System.out.println("     <absolute path to vil_file>");
        System.out.println(" - checking validity / reasoning:");
        System.out.println("   checkValidity <project_folder>");
        System.out.println("   checkValidity <project_folder> <absolute path to ivml_file>");
        System.out.println("   checkValidity <project_folder> <ivml project name> <ivml project version>");
        System.out.println(" - PLP operations:");
        System.out.println("   createPLP <project_folder> (flavour)*");
        System.out.println("   showFlavours");
        System.out.println("   setPredecessors <project_folder> <project_folder>*");
        System.out.println("   pullConfig <project_folder>");
    }

    public static void main(String[] args) {
        System.out.println("EASy-Producer CLI");
        if (args.length == 0) {
            CommandLineExecuter.printHelp();
        }
        int result = 0;
        try {
            ManifestLoader loader = new ManifestLoader(DEBUG);
            loader.startup();
            if (DEBUG) {
                EASyLoggerFactory.INSTANCE.setLoggingLevel(LoggingLevel.DEBUG);
                TracerFactory.setDefaultInstance((TracerFactory)ConsoleTracerFactory.INSTANCE);
            }
            if (null != args && args.length > 1) {
                HashMap<String, String> options = new HashMap<String, String>();
                args = CommandLineExecuter.pruneArguments(args, options);
                switch (args[0]) {
                    case "instantiateSelf": {
                        result = CommandLineExecuter.instantiateSelf(args, options);
                        break;
                    }
                    case "instantiate": {
                        result = CommandLineExecuter.instantiate(args, options);
                        break;
                    }
                    case "checkValidity": {
                        result = CommandLineExecuter.checkValidity(args, options);
                        break;
                    }
                    case "setPredecessors": {
                        result = CommandLineExecuter.setPredecessors(args, options, true);
                        break;
                    }
                    case "pullConfig": {
                        result = CommandLineExecuter.pullConfig(args, options, true);
                        break;
                    }
                    case "createPLP": {
                        result = CommandLineExecuter.createPLP(args, options, true);
                        break;
                    }
                }
            } else if (null != args && args.length == 1) {
                switch (args[0]) {
                    case "showFlavours": {
                        System.out.println("Available flavours:");
                        ProjectCreationFlavour.forEach(f -> System.out.println(" - " + f.getName() + ": " + f.getDescription()));
                        break;
                    }
                }
            }
            loader.shutdown();
        }
        catch (IOException e) {
            LOGGER.exception((Exception)e);
            result = 1;
        }
        System.exit(result);
    }

    private static int instantiateSelf(String[] args, Map<String, String> options) {
        int result = 0;
        try {
            File project = new File(args[1]);
            switch (args.length) {
                case 2: {
                    InstantiationCommands.instantiateSelf(project);
                    break;
                }
                case 3: {
                    File ivmlFile1 = new File(args[2]);
                    InstantiationCommands.instantiateSelf(project, ivmlFile1);
                    break;
                }
                case 4: {
                    File ivmlFile2 = new File(args[2]);
                    File vilFile = new File(args[3]);
                    InstantiationCommands.instantiateSelf(project, ivmlFile2, vilFile);
                    break;
                }
                default: {
                    LOGGER.warn("Unspecified combination of arguments passed. # Arguments = " + args.length);
                    break;
                }
            }
        }
        catch (ModelManagementException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 2;
        }
        catch (VilException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 4;
        }
        catch (PersistenceException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 3;
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.exception((Exception)e);
            result = 8;
        }
        return result;
    }

    private static int instantiate(String[] args, Map<String, String> options) {
        int result = 0;
        try {
            File projectSRC = new File(args[1]);
            File projectTRG = new File(args[2]);
            switch (args.length) {
                case 3: {
                    InstantiationCommands.instantiate(projectSRC, projectTRG);
                    break;
                }
                case 5: {
                    File ivmlFile = new File(args[3]);
                    File vilFile = new File(args[4]);
                    InstantiationCommands.instantiate(projectSRC, projectTRG, ivmlFile, vilFile);
                    break;
                }
                case 7: {
                    ModelLoadDefinition ivmlDef = new ModelLoadDefinition(args[3], args[4]);
                    ModelLoadDefinition vilDef = new ModelLoadDefinition(args[5], args[6]);
                    InstantiationCommands.instantiate(projectSRC, projectTRG, ivmlDef, vilDef);
                    break;
                }
                default: {
                    LOGGER.warn("Unspecified combination of arguments passed. # Arguments = " + args.length);
                    break;
                }
            }
        }
        catch (VilException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 4;
        }
        catch (PersistenceException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 3;
        }
        catch (ModelManagementException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 2;
        }
        catch (SecurityException e) {
            LOGGER.exception((Exception)e);
            result = 7;
        }
        catch (IOException e) {
            LOGGER.exception((Exception)e);
            result = 1;
        }
        catch (NullPointerException e) {
            LOGGER.exception((Exception)e);
            result = 6;
        }
        catch (VersionFormatException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 5;
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.exception((Exception)e);
            result = 8;
        }
        return result;
    }

    private static boolean checkForOption(String arg, Map<String, String> options) {
        String optName = null;
        String optValue = null;
        for (int o = 0; null == optName && o < OPTIONS.size(); ++o) {
            String argName = OPTIONS.get(o);
            if (arg.equals(argName)) {
                optName = argName;
            } else if (arg.startsWith(argName + "=") && arg.length() > argName.length() + 1) {
                optName = argName;
                optValue = arg.substring(argName.length() + 1);
            }
            if (null == options || null == optName) continue;
            options.put(optName, optValue);
        }
        return null != optName;
    }

    private static String[] pruneArguments(String[] args, Map<String, String> options) {
        ArrayList<String> tmpArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (CommandLineExecuter.checkForOption(arg, options)) continue;
            tmpArgs.add(arg);
        }
        args = new String[tmpArgs.size()];
        return tmpArgs.toArray(args);
    }

    private static int pullConfig(String[] args, Map<String, String> options, boolean add) {
        int cmdResult = 0;
        File project = new File(args[1]);
        try {
            LowlevelCommands.loadProject(project);
            String projectName = ProjectNameMapper.getInstance().getName(project);
            PLPInfo plp = LowlevelCommands.getProject(projectName);
            plp.pullConfigFromPredecessors();
        }
        catch (PersistenceException e) {
            LOGGER.error("Predecessors command execution failed: " + e.getMessage());
            cmdResult = 3;
        }
        return cmdResult;
    }

    private static int createPLP(String[] args, Map<String, String> options, boolean add) {
        int cmdResult = 0;
        File project = new File(args[1]);
        try {
            if (project.exists()) {
                if (project.listFiles() != null) {
                    LOGGER.error("Project folder may exist but must be empty.");
                    cmdResult = 1;
                }
            } else {
                project.mkdirs();
            }
            List<ProjectCreationFlavour> flavours = ProjectCreationFlavour.getFlavours(Arrays.copyOfRange(args, 1, args.length));
            EASyPersistencer persistencer = new EASyPersistencer(project);
            ProjectCreationFlavour.forEach(flavours, f -> f.configure(persistencer));
            IProjectCreationResult result = persistencer.createProject(project.getName(), project.getParentFile(), null, true);
            persistencer.populateEasyProject(result);
            ProjectCreationFlavour.forEach(flavours, f -> f.apply(project));
        }
        catch (PersistenceException e) {
            LOGGER.error("Creating PLP failed: " + e.getMessage());
            cmdResult = 3;
        }
        return cmdResult;
    }

    private static int setPredecessors(String[] args, Map<String, String> options, boolean add) {
        int cmdResult = 0;
        if (args.length < 2) {
            LOGGER.error("Predecessors command requires at least two arguments.");
            cmdResult = 8;
        } else {
            try {
                File project = new File(args[1]);
                LowlevelCommands.loadProject(project);
                String projectName = ProjectNameMapper.getInstance().getName(project);
                PLPInfo plp = LowlevelCommands.getProject(projectName);
                ArrayList<PLPInfo> preds = new ArrayList<PLPInfo>();
                boolean ok = true;
                for (int p = 2; ok && p < args.length; ++p) {
                    File pred = new File(args[p]);
                    if (pred.exists()) {
                        LowlevelCommands.loadProject(pred);
                        String predName = ProjectNameMapper.getInstance().getName(pred);
                        PLPInfo plpInfo = LowlevelCommands.getProject(predName);
                        SPLsManager.INSTANCE.addPLP(plpInfo);
                        preds.add(plpInfo);
                        continue;
                    }
                    LOGGER.error("Specified project " + args[p] + " is not a valid predecessor of " + projectName + ". Canceling operation.");
                    ok = false;
                }
                List input = plp.getMemberController().getPossiblePredecessors();
                ArrayList<String> newPredecessors = new ArrayList<String>();
                for (int p = 0; ok && p < preds.size(); ++p) {
                    PLPInfo pred = (PLPInfo)preds.get(p);
                    if (null == input || input.contains(pred.getProjectID())) {
                        newPredecessors.add(pred.getProjectID());
                        continue;
                    }
                    LOGGER.error("Specified project " + pred.getProjectName() + " is not a valid predecessor of " + projectName + ". Canceling operation.");
                    ok = false;
                }
                if (ok) {
                    boolean changed = plp.setPredecessors(newPredecessors);
                    if (changed) {
                        plp.save();
                    }
                    System.out.println("Setting predecessors " + String.valueOf(newPredecessors) + " on " + projectName + " (changed: " + changed + ")");
                } else {
                    cmdResult = 12;
                }
            }
            catch (PersistenceException e) {
                LOGGER.error("Predecessors command execution failed: " + e.getMessage());
                cmdResult = 3;
            }
        }
        return cmdResult;
    }

    private static int checkValidity(String[] args, Map<String, String> options) {
        int cmdResult = 0;
        ReasoningResult result = null;
        try {
            File project = new File(args[1]);
            switch (args.length) {
                case 2: {
                    result = ReasoningCommands.checkValidity(project);
                    break;
                }
                case 3: {
                    File ivmlFile = new File(args[2]);
                    result = ReasoningCommands.checkValidity(project, ivmlFile);
                    break;
                }
                case 4: {
                    ModelLoadDefinition ivmlDef = new ModelLoadDefinition(args[2], args[3]);
                    result = ReasoningCommands.checkValidity(project, ivmlDef);
                    break;
                }
                default: {
                    LOGGER.warn("Unspecified combination of arguments passed. # Arguments = " + args.length);
                }
            }
            if (null != result) {
                File file;
                String path = options.get(OPT_RESULTFILE);
                if (null == path) {
                    file = new File(project, ".result");
                } else {
                    file = new File(path);
                    if (file.isDirectory()) {
                        file = new File(file, ".result");
                    }
                }
                PrintStream out = new PrintStream(new FileOutputStream(file));
                out.println(result.hasConflict());
                out.flush();
                out.close();
                String optionalNot = result.hasConflict() ? "not " : "";
                System.out.println("Reasoning result: The model is " + optionalNot + "valid");
                for (int m = 0; m < result.getMessageCount(); ++m) {
                    Message msg = result.getMessage(m);
                    out.println(msg.getDescription());
                    out.println(" " + String.valueOf(msg.getConflictComments()));
                    out.println(" " + String.valueOf(msg.getConflictSuggestions()));
                }
                if (result.hasConflict()) {
                    cmdResult = 10;
                }
            } else {
                cmdResult = 11;
            }
        }
        catch (VersionFormatException e) {
            LOGGER.exception((Exception)((Object)e));
            cmdResult = 5;
        }
        catch (ModelManagementException e) {
            LOGGER.exception((Exception)((Object)e));
            cmdResult = 2;
        }
        catch (IOException e) {
            LOGGER.exception((Exception)e);
            cmdResult = 1;
        }
        catch (PersistenceException e) {
            LOGGER.exception((Exception)((Object)e));
            cmdResult = 3;
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.exception((Exception)e);
            cmdResult = 8;
        }
        return cmdResult;
    }

    static {
        OPTIONS.add(OPT_RESULTFILE);
    }
}

