/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.standalone.cmd;

import java.io.File;
import java.io.IOException;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.standalone.cmd.LowlevelCommands;
import net.ssehub.easy.standalone.cmd.ModelLoadDefinition;
import net.ssehub.easy.standalone.cmd.ProjectNameMapper;
import net.ssehub.easy.standalone.cmd.Utils;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public class ReasoningCommands {
    public static ReasoningResult checkValidity(File project) throws PersistenceException {
        LowlevelCommands.loadProject(project);
        String projectName = ProjectNameMapper.getInstance().getName(project);
        PLPInfo plp = LowlevelCommands.getProject(projectName);
        return ReasoningCommands.checkValidity(plp.getProject());
    }

    public static ReasoningResult checkValidity(File project, File ivmlFile) throws ModelManagementException {
        net.ssehub.easy.producer.core.persistence.Configuration config = PersistenceUtils.getConfiguration((File)project);
        PersistenceUtils.processLocation((net.ssehub.easy.producer.core.persistence.Configuration)config, (boolean)true, (boolean)false, (ProgressObserver)ProgressObserver.NO_OBSERVER);
        Project ivmlProject = (Project)PersistenceUtils.loadModel((ModelManagement)VarModel.INSTANCE, (File)ivmlFile);
        return ReasoningCommands.checkValidity(ivmlProject);
    }

    public static ReasoningResult checkValidity(File project, ModelLoadDefinition ivmlDefinition) throws ModelManagementException {
        VarModel.INSTANCE.locations().addLocation(project, ProgressObserver.NO_OBSERVER);
        Project ivmlProject = (Project)Utils.loadPreferredModel(VarModel.INSTANCE, ivmlDefinition, new File[]{project});
        return ReasoningCommands.checkValidity(ivmlProject);
    }

    public static ReasoningResult checkValidity(Project project) {
        Configuration config = new Configuration(project);
        ReasonerConfiguration rConfig = new ReasonerConfiguration();
        return ReasonerFrontend.getInstance().check(config, rConfig, ProgressObserver.NO_OBSERVER);
    }

    public static void main(String[] args) throws IOException, VersionFormatException, ModelManagementException {
        LowlevelCommands.startEASy();
        ModelLoadDefinition mld = new ModelLoadDefinition("PL_SimElevator_frozen", "0");
        File project = new File("../EASyCommandLineTest/testdata/elevator/PL_SimElevator_frozen");
        System.out.println("has conflict: " + String.valueOf(ReasoningCommands.checkValidity(project, mld)));
    }
}

