/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.standalone.ant;

import de.uni_hildesheim.sse.easy.loader.ListLoader;
import java.io.File;
import java.io.IOException;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.tracing.ConsoleTracerFactory;
import net.ssehub.easy.producer.core.mgmt.EasyExecutor;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.standalone.ant.AbstractEASyTask;
import org.apache.tools.ant.BuildException;

public class EASyPlain
extends AbstractEASyTask {
    private File startupList;
    private boolean verbose = false;

    public void setStartupList(File file) {
        this.startupList = file;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void execute() throws BuildException {
        if (null != this.getProjectName() && null != this.getSource() && null != this.getTarget()) {
            try {
                ListLoader loader = new ListLoader(this.startupList);
                loader.setVerbose(true);
                this.log("EASy starting");
                loader.startup();
                this.log("EASy started");
                EasyExecutor exec = new EasyExecutor(new File("."), new File("EASy"), this.getProjectName()).setVilSource(this.getSource()).setVilTarget(this.getTarget()).setLogger(new EasyExecutor.Logger(){

                    public void warn(String text) {
                        EASyPlain.this.log(text, 1);
                    }

                    public void error(String text) {
                        EASyPlain.this.log(text, 0);
                    }

                    public void info(String text) {
                        if (EASyPlain.this.verbose) {
                            EASyPlain.this.log(text);
                        }
                    }
                });
                exec.setTracerFactory(this.verbose ? ConsoleTracerFactory.INSTANCE : TracerFactory.DEFAULT);
                exec.setupLocations();
                exec.loadIvmlModel();
                this.log("EASy locations added");
                exec.loadIvmlModel();
                ReasoningResult rResult = exec.propagateOnIvmlModel();
                this.log("Reasoning is ok: " + !rResult.hasConflict());
                exec.executeVil();
                exec.discardLocations();
                this.log("EASy stopping", 2);
                loader.shutdown();
                this.log("EASy stopped", 2);
            }
            catch (ModelManagementException e) {
                this.log(e.getMessage());
            }
            catch (VilException e) {
                this.log(e.getMessage());
            }
            catch (IOException e) {
                this.log(e.getMessage());
            }
            catch (IllegalStateException e) {
                this.log(e.getMessage());
            }
        } else {
            this.log("Source, target and project name must be set.");
        }
    }
}

