/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.standalone.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.EASyPersistencer;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;

public abstract class ProjectCreationFlavour {
    private static Map<String, ProjectCreationFlavour> flavours = new HashMap<String, ProjectCreationFlavour>();

    public static void registerFlavour(ProjectCreationFlavour flavour) {
        if (null != flavour) {
            flavours.put(flavour.getName(), flavour);
        }
    }

    public static void forEach(Consumer<ProjectCreationFlavour> consumer) {
        ArrayList<ProjectCreationFlavour> fl = new ArrayList<ProjectCreationFlavour>(flavours.values());
        Collections.sort(fl, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        fl.stream().forEach(consumer);
    }

    public static ProjectCreationFlavour getFlavour(String name) {
        return flavours.get(name);
    }

    public static List<ProjectCreationFlavour> getFlavours(String ... names) {
        ArrayList<ProjectCreationFlavour> flavours = new ArrayList<ProjectCreationFlavour>();
        for (int a = 1; a < names.length; ++a) {
            ProjectCreationFlavour fl = ProjectCreationFlavour.getFlavour(names[a]);
            if (null == fl) continue;
            flavours.add(fl);
        }
        return flavours;
    }

    public static void forEach(List<ProjectCreationFlavour> flavours, Consumer<ProjectCreationFlavour> consumer) {
        flavours.stream().forEach(consumer);
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract void apply(File var1);

    public void configure(EASyPersistencer persistencer) {
    }

    static {
        ProjectCreationFlavour.registerFlavour(new ProjectCreationFlavour(){

            @Override
            public String getName() {
                return "java";
            }

            @Override
            public String getDescription() {
                return "Classical src/bin setup";
            }

            @Override
            public void apply(File projectFolder) {
                new File(projectFolder, "src").mkdirs();
                new File(projectFolder, "bin").mkdirs();
            }
        });
        ProjectCreationFlavour.registerFlavour(new ProjectCreationFlavour(){
            private static final String MAIN = "src/main/EASy";
            private static final String TEST = "src/test/EASy";

            @Override
            public String getName() {
                return "mvn";
            }

            @Override
            public String getDescription() {
                return "Classical Java/Maven setup";
            }

            @Override
            public void apply(File projectFolder) {
                new File(projectFolder, MAIN).mkdirs();
                new File(projectFolder, "src/main/java").mkdirs();
                new File(projectFolder, TEST).mkdirs();
                new File(projectFolder, "src/test/java").mkdirs();
                new File(projectFolder, "target").mkdirs();
            }

            @Override
            public void configure(EASyPersistencer persistencer) {
                Configuration cfg = PersistenceUtils.getConfiguration((File)persistencer.getProjectFolder());
                String path = "src/main/EASy/" + File.pathSeparator + "src/test/EASy/";
                cfg.setPathDirect(Configuration.PathKind.IVML, path);
                cfg.setPathDirect(Configuration.PathKind.VIL, path);
                cfg.setPathDirect(Configuration.PathKind.VTL, path);
                cfg.store();
                persistencer.refreshConfiguration();
            }
        });
    }
}

