/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.vil.expressions.translation;

import de.uni_hildesheim.sse.vil.expressions.expressionDsl.AdditiveExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.AdditiveExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ArgumentList;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Call;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Constant;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ConstructorExecution;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ContainerInitializer;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Declaration;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.DeclarationUnit;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Declarator;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.EqualityExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.EqualityExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionOrQualifiedExecution;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionStatement;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.LogicalExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.LogicalExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.MultiplicativeExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.MultiplicativeExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.NamedArgument;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.PostfixExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.PrimaryExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.RelationalExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.RelationalExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.SubCall;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.SuperExecution;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Type;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.TypeParameters;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.UnaryExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.UnqualifiedExecution;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VariableDeclaration;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionSpec;
import de.uni_hildesheim.sse.vil.expressions.translation.DeferredResolvableOperationExpression;
import de.uni_hildesheim.sse.vil.expressions.translation.IvmlMessageAdapter;
import de.uni_hildesheim.sse.vil.expressions.translation.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.AbstractException;
import net.ssehub.easy.basics.messages.IIdentifiable;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.dslCore.translation.IMessageReceiver;
import net.ssehub.easy.dslCore.translation.StringUtils;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstructorCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionVersionRestriction;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionWriter;
import net.ssehub.easy.instantiation.core.model.expressions.FieldAccessExpression;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.expressions.ImplicitContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.MultiAndExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ParenthesisExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolutionListener;
import net.ssehub.easy.instantiation.core.model.expressions.Resolver;
import net.ssehub.easy.instantiation.core.model.expressions.StringExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringResolver;
import net.ssehub.easy.instantiation.core.model.expressions.ValueAssignmentExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VilTypeExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class ExpressionTranslator<I extends net.ssehub.easy.instantiation.core.model.common.VariableDeclaration, R extends Resolver<I>, E extends net.ssehub.easy.instantiation.core.model.common.ExpressionStatement>
extends net.ssehub.easy.dslCore.translation.ExpressionTranslator
implements ResolutionListener,
StringResolver.IExpressionTranslator<I, R> {
    private VarModelIdentifierExpression lastVarModelIdentifierEx;
    private IvmlMessageAdapter ivmlMessageAdapter = new IvmlMessageAdapter();

    public IvmlMessageAdapter setIvmlMessageAdapter(IvmlMessageAdapter adapter) {
        IvmlMessageAdapter old = this.ivmlMessageAdapter;
        this.ivmlMessageAdapter = adapter;
        return old;
    }

    public IvmlMessageAdapter getIvmlMessageAdapter() {
        return this.ivmlMessageAdapter;
    }

    public Expression processExpression(de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression ex, R resolver) throws TranslatorException {
        Object result = ex != null ? (ex.getExpr() != null ? this.processLogicalExpression(ex.getExpr(), resolver) : this.processContainerInitializer(ex.getInit(), resolver)) : null;
        return result;
    }

    public void enactIvmlWarnings() {
        this.ivmlMessageAdapter.processAndClear(e -> this.ivmlWarning(((VarModelIdentifierExpression)e.getKey()).getIdentifier(), (EObject)e.getValue(), (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE));
    }

    private void ivmlWarning(String name, EObject cause, EStructuralFeature causingFeature) {
        this.warning(VariableExpression.composeUnkownVariableWarning((String)name), cause, causingFeature, -1);
    }

    public E processExpressionStatement(ExpressionStatement expr, R resolver) throws TranslatorException {
        Expression result = this.processExpression(expr.getExpr(), resolver);
        if (result != null) {
            try {
                result.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__EXPR);
            }
        }
        if (expr.getVar() != null) {
            net.ssehub.easy.instantiation.core.model.common.VariableDeclaration decl = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)resolver.resolve(expr.getVar(), false, (EObject)expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__VAR, (IMessageReceiver)this);
            if (decl == null) {
                throw new TranslatorException("cannot resolve variable '" + expr.getVar() + "'", (EObject)expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__VAR, 20207);
            }
            if (expr.getField() != null) {
                FieldDescriptor fdesc = decl.getType().getField(expr.getField());
                if (fdesc == null) {
                    throw new TranslatorException("cannot resolve field '" + expr.getField() + "'", (EObject)expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__FIELD, 20207);
                }
                result = new ValueAssignmentExpression(decl, fdesc, result);
                if (fdesc != null && fdesc.isReadOnly()) {
                    throw new TranslatorException("Cannot assign value to readonly field '" + fdesc.getName() + "'." + this.cannotAssignHint(), (EObject)expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__FIELD, 30016);
                }
            } else {
                try {
                    result = new ValueAssignmentExpression(decl, result);
                    result.inferType();
                }
                catch (VilException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__VAR);
                }
            }
        }
        return this.createExpressionStatement(result, resolver);
    }

    protected abstract String cannotAssignHint();

    protected abstract E createExpressionStatement(Expression var1, R var2);

    public Expression processLogicalExpression(LogicalExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processEqualityExpression(ex.getLeft(), resolver);
        if (ex.getRight() != null) {
            try {
                for (LogicalExpressionPart part : ex.getRight()) {
                    result = new CallExpression(null, part.getOp(), new Expression[]{result, this.processEqualityExpression(part.getEx(), resolver)});
                    result.inferType();
                }
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)ex, (EStructuralFeature)ExpressionDslPackage.Literals.LOGICAL_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processEqualityExpression(EqualityExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processRelationalExpression(ex.getLeft(), resolver);
        if (ex.getRight() != null) {
            try {
                EqualityExpressionPart part = ex.getRight();
                result = new CallExpression(null, part.getOp(), new Expression[]{result, this.processRelationalExpression(part.getEx(), resolver)});
                result.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)ex, (EStructuralFeature)ExpressionDslPackage.Literals.EQUALITY_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processRelationalExpression(RelationalExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processAdditiveExpression(ex.getLeft(), resolver);
        if (ex.getRight() != null) {
            try {
                RelationalExpressionPart part = ex.getRight();
                Expression rightEx = this.processAdditiveExpression(part.getEx(), resolver);
                CallExpression call1 = new CallExpression(null, part.getOp(), new Expression[]{result, rightEx});
                result = call1;
                result.inferType();
                if (ex.getRight2() != null) {
                    part = ex.getRight2();
                    CallExpression call2 = new CallExpression(null, part.getOp(), new Expression[]{rightEx, this.processAdditiveExpression(part.getEx(), resolver)});
                    call2.inferType();
                    result = new MultiAndExpression(new AbstractCallExpression[]{call1, call2});
                    result.inferType();
                    if (ExpressionWriter.considerOclCompliance()) {
                        this.warning("OCL compliance: chain of relational operations shall be written by a combination of binary comparisons and Boolean and operatoins", ex, (EStructuralFeature)ExpressionDslPackage.Literals.RELATIONAL_EXPRESSION__RIGHT2, -1);
                    }
                }
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)ex, (EStructuralFeature)ExpressionDslPackage.Literals.RELATIONAL_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processAdditiveExpression(AdditiveExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processMultiplicativeExpression(ex.getLeft(), resolver);
        if (ex.getRight() != null) {
            try {
                for (AdditiveExpressionPart part : ex.getRight()) {
                    result = new CallExpression(null, part.getOp(), new Expression[]{result, this.processMultiplicativeExpression(part.getEx(), resolver)});
                    result.inferType();
                }
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)ex, (EStructuralFeature)ExpressionDslPackage.Literals.ADDITIVE_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processMultiplicativeExpression(MultiplicativeExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processUnaryExpression(ex.getLeft(), resolver);
        if (ex.getRight() != null) {
            try {
                MultiplicativeExpressionPart part = ex.getRight();
                result = new CallExpression(null, part.getOp(), new Expression[]{result, this.processUnaryExpression(part.getExpr(), resolver)});
                result.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)ex, (EStructuralFeature)ExpressionDslPackage.Literals.MULTIPLICATIVE_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processUnaryExpression(UnaryExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processPostfixExpression(ex.getExpr(), resolver);
        if (ex.getOp() != null) {
            try {
                result = new CallExpression(null, ex.getOp(), new Expression[]{result});
                result.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)ex, (EStructuralFeature)ExpressionDslPackage.Literals.UNARY_EXPRESSION__EXPR);
            }
        }
        return result;
    }

    protected Expression processPostfixExpression(PostfixExpression ex, R resolver) throws TranslatorException {
        return this.processPrimaryExpression(ex.getLeft(), resolver);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<I> resolveIteratorDeclarations(Call call, CallType type, List<CallArgument> arguments, R resolver) throws TranslatorException {
        void var5_8;
        Declarator decl;
        ArrayList arrayList = new ArrayList();
        if (call == null || (decl = call.getDecl()) == null || decl.getDecl() == null || arguments.size() <= 0) return var5_8;
        TypeDescriptor arg0Type = null;
        try {
            arg0Type = arguments.get(0).inferType();
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__PARAM);
        }
        if (arg0Type != null) {
            if (arg0Type.isCollection()) {
                if (arg0Type.getGenericParameterCount() <= 0) throw new TranslatorException("cannot apply iterator as collection does not declare generic types", (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__DECL, 20211);
                ArrayList<I> arrayList2 = this.processDeclarators(call, arg0Type.getGenericParameterType(0), arguments, resolver);
            } else {
                ArrayList<I> arrayList3 = this.processDeclarators(call, null, arguments, resolver);
            }
        }
        if (var5_8 == null) {
            throw new TranslatorException("at least one declarator / iterator must be given", (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__DECL, 20211);
        }
        int freeCount = 0;
        int i = 0;
        while (i < var5_8.size()) {
            net.ssehub.easy.instantiation.core.model.common.VariableDeclaration declarator = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)var5_8.get(i);
            if (declarator.getExpression() == null) {
                ++freeCount;
            }
            ++i;
        }
        if (freeCount == true) return var5_8;
        throw new TranslatorException("currently an iterator call accepts exactly one unbound / auto-bound iterator variable", (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__DECL, 20211);
    }

    private ArrayList<I> processDeclarators(Call call, TypeDescriptor<?> implicitType, List<CallArgument> arguments, R resolver) throws TranslatorException {
        ArrayList<I> result = new ArrayList<I>();
        Declarator decl = call.getDecl();
        boolean firstDecl = true;
        String callName = Utils.getQualifiedNameString(call.getName());
        boolean isAggregator = "iterate".equals(callName) || "apply".equals(callName);
        for (Declaration d : decl.getDecl()) {
            TypeDescriptor t;
            if (d.getType() != null) {
                t = this.processType(d.getType(), resolver);
                if (!(firstDecl && isAggregator || implicitType == null || t.isAssignableFrom(implicitType))) {
                    throw new TranslatorException("type '" + t.getVilName() + "' of iterator does not match type '" + implicitType.getVilName() + "' of the expression", (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__PARAM, 20211);
                }
            } else {
                if (implicitType == null) {
                    if (!arguments.isEmpty()) {
                        try {
                            TypeDescriptor opType = arguments.get(0).inferType();
                            ImplicitContainerInitializerExpression cInitEx = new ImplicitContainerInitializerExpression(arguments.get(0));
                            cInitEx.inferType();
                            arguments.set(0, new CallArgument((Expression)cInitEx.toSet()));
                            implicitType = opType;
                        }
                        catch (VilException opType) {
                            // empty catch block
                        }
                    }
                    if (implicitType == null) {
                        throw new TranslatorException("on non-collection iterators the declarator must given with type", (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__PARAM, 20211);
                    }
                }
                t = implicitType;
            }
            boolean firstUnit = true;
            for (DeclarationUnit unit : d.getUnits()) {
                Expression deflt = null;
                if (unit.getDeflt() != null) {
                    deflt = this.processExpression(unit.getDeflt(), resolver);
                }
                I var = this.createVariableDeclaration(unit.getId(), t, false, deflt, resolver);
                var.setHasExplicitType(firstUnit && d.getType() != null);
                result.add(var);
                firstUnit = false;
            }
            firstDecl = false;
        }
        return result;
    }

    protected String resolveCallArguments(Call call, List<I> iterators, List<CallArgument> arguments, de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression arrayEx, R resolver) throws TranslatorException {
        String name;
        if (call != null) {
            if (call.getParam() != null) {
                if (!iterators.isEmpty()) {
                    resolver.pushLevel();
                    resolver.add(iterators);
                }
                int count = 0;
                for (NamedArgument param : call.getParam().getParam()) {
                    Expression ex;
                    String paramName = param.getName();
                    try {
                        ex = this.resolveCallArgumentExpression(param, count, iterators, arguments, resolver);
                        if (count == 0 && !iterators.isEmpty()) {
                            if (paramName != null) {
                                net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)resolver.resolve(paramName, false, (EObject)param, (EStructuralFeature)ExpressionDslPackage.Literals.PARAMETER__NAME, (IMessageReceiver)this);
                                if (var == null) {
                                    throw new TranslatorException("cannot resolve '" + paramName + "'", (EObject)param, (EStructuralFeature)ExpressionDslPackage.Literals.PARAMETER__NAME, 20211);
                                }
                                ex = new ValueAssignmentExpression(var, ex);
                                paramName = null;
                            }
                            net.ssehub.easy.instantiation.core.model.common.VariableDeclaration iterator = null;
                            int i = 0;
                            while (iterator == null && i < iterators.size()) {
                                net.ssehub.easy.instantiation.core.model.common.VariableDeclaration iter = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)iterators.get(i);
                                if (iter.getExpression() == null) {
                                    iterator = iter;
                                }
                                ++i;
                            }
                            ex = new ExpressionEvaluator(ex, iterator, iterators);
                        }
                    }
                    catch (TranslatorException e) {
                        if (20211 == e.getId()) {
                            ex = this.tryIteratorExpression(arguments, param, resolver);
                        }
                        throw new TranslatorException((IIdentifiable)e, (EObject)param, (EStructuralFeature)ExpressionDslPackage.Literals.NAMED_ARGUMENT__EX);
                    }
                    arguments.add(new CallArgument(paramName, ex));
                    ++count;
                }
                if (!iterators.isEmpty()) {
                    resolver.popLevel();
                }
            }
            name = Utils.getQualifiedNameString(call.getName());
        } else {
            arguments.add(new CallArgument(this.processExpression(arrayEx, resolver)));
            name = "[]";
        }
        return name;
    }

    private Expression resolveCallArgumentExpression(NamedArgument param, int paramIndex, List<I> iterators, List<CallArgument> arguments, R resolver) throws TranslatorException {
        Expression ex;
        block6: {
            ex = null;
            this.lastVarModelIdentifierEx = null;
            try {
                ex = this.processExpression(param.getEx(), resolver);
            }
            catch (TranslatorException e) {
                boolean consider = iterators.isEmpty() && paramIndex == 0 && param.getName() == null;
                if (consider &= this.lastVarModelIdentifierEx != null && arguments.size() > 0) {
                    TypeDescriptor arg0Type;
                    try {
                        arg0Type = arguments.get(0).inferType();
                    }
                    catch (VilException e1) {
                        arg0Type = null;
                    }
                    if (arg0Type != null && arg0Type.isCollection() && arg0Type.getGenericParameterCount() > 0) {
                        I var = this.createImplicitVariableDeclaration(this.lastVarModelIdentifierEx.getIdentifier(), arg0Type.getGenericParameterType(0), false, null, resolver);
                        iterators.add(var);
                        resolver.pushLevel();
                        resolver.add(iterators);
                        ex = this.processExpression(param.getEx(), resolver);
                    }
                }
                if (ex != null) break block6;
                throw e;
            }
        }
        return ex;
    }

    private ExpressionEvaluator tryIteratorExpression(List<CallArgument> arguments, NamedArgument param, R resolver) throws TranslatorException {
        ExpressionEvaluator ex = null;
        if (arguments.size() > 0) {
            try {
                TypeDescriptor arg0Type = arguments.get(0).inferType();
                if (arg0Type.isCollection() && arg0Type.getGenericParameterCount() > 0) {
                    resolver.pushLevel();
                    I iterVar = this.createImplicitVariableDeclaration("ITER", arg0Type.getGenericParameterType(0), false, null, resolver);
                    resolver.add(iterVar);
                    ex = new ExpressionEvaluator(this.processExpression(param.getEx(), resolver), iterVar, null);
                    resolver.popLevel();
                }
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)param, (EStructuralFeature)ExpressionDslPackage.Literals.NAMED_ARGUMENT__EX);
            }
        }
        return ex;
    }

    protected abstract I createVariableDeclaration(String var1, TypeDescriptor<?> var2, boolean var3, Expression var4, R var5);

    protected abstract I createImplicitVariableDeclaration(String var1, TypeDescriptor<?> var2, boolean var3, Expression var4, R var5);

    protected abstract Expression processCall(Expression var1, Call var2, CallType var3, de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression var4, R var5) throws TranslatorException;

    protected AbstractCallExpression checkCallExpression(AbstractCallExpression callEx, CallType type, Call call) throws TranslatorException {
        if (callEx == null) {
            throw new TranslatorException("cannot resolve " + String.valueOf(call.getName()), (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, 20207);
        }
        if (callEx.isPlaceholder()) {
            this.warning("The operation '" + callEx.getVilSignature() + "' is unknown, shall be a VIL type - may lead to a runtime error", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, 20200);
        }
        if (ExpressionWriter.considerOclCompliance()) {
            if (!callEx.isOclCompliant()) {
                this.warning("OCL compliance: The operation '" + callEx.getVilSignature() + "' is not OCL compliant. Please use the respective alias method instead.", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, -1);
            }
            if (callEx.isIteratingCollectionOperation() && type != CallType.ITERATOR) {
                this.warning("OCL compliance: The iterator operation '" + callEx.getVilSignature() + "' shall be called through '->' rather than '.'.", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, -1);
            }
        }
        return callEx;
    }

    protected VilException checkSemantics(Expression expr) {
        VilException semantic = null;
        if (expr != null) {
            try {
                expr.inferType();
            }
            catch (VilException e) {
                semantic = e;
            }
        }
        return semantic;
    }

    protected Expression processSubCalls(Expression firstParam, EList<SubCall> followups, R resolver) throws TranslatorException {
        Expression result = firstParam;
        if (followups != null) {
            for (SubCall call : followups) {
                Declarator decl;
                Call c;
                CallType callType = CallType.OTHER;
                if ("->".equals(call.getType())) {
                    callType = CallType.ITERATOR;
                }
                if ((c = call.getCall()) != null && (decl = c.getDecl()) != null && callType != CallType.ITERATOR) {
                    throw new TranslatorException("iterator variables given but this is no iterator call", (EObject)c, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__DECL, 20211);
                }
                result = this.processSubCall(result, call, callType, resolver);
            }
        }
        return result;
    }

    protected Expression processSubCall(Expression result, SubCall call, CallType callType, R resolver) throws TranslatorException {
        return this.processCall(result, call.getCall(), callType, call.getArrayEx(), resolver);
    }

    public Expression processPrimaryExpression(PrimaryExpression ex, R resolver) throws TranslatorException {
        Expression result = null;
        if (ex != null) {
            ConstructorExecution cEx;
            SuperExecution superEx;
            UnqualifiedExecution unqEx;
            ExpressionOrQualifiedExecution otherEx = ex.getOtherEx();
            if (otherEx != null) {
                if (otherEx.getVal() != null) {
                    result = this.processConstant(otherEx.getVal(), resolver);
                } else if (otherEx.getParenthesis() != null) {
                    result = new ParenthesisExpression(this.processExpression(otherEx.getParenthesis(), resolver));
                }
                if (otherEx.getCalls() != null) {
                    result = this.processSubCalls(result, otherEx.getCalls(), resolver);
                }
            }
            if ((unqEx = ex.getUnqEx()) != null) {
                result = this.processCall(null, unqEx.getCall(), CallType.OTHER, null, resolver);
                result = this.processSubCalls(result, unqEx.getCalls(), resolver);
            }
            if ((superEx = ex.getSuperEx()) != null) {
                result = this.processCall(null, superEx.getCall(), CallType.SUPER, null, resolver);
                result = this.processSubCalls(result, superEx.getCalls(), resolver);
            }
            if ((cEx = ex.getNewEx()) != null) {
                try {
                    CallArgument[] args = this.processArguments(cEx.getParam(), resolver);
                    result = new ConstructorCallExpression(this.processType(cEx.getType(), resolver), args);
                    result = this.processSubCalls(result, cEx.getCalls(), resolver);
                    result.inferType();
                }
                catch (VilException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)cEx, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTRUCTOR_EXECUTION__TYPE);
                }
            }
        }
        return result;
    }

    public CallArgument[] processArguments(ArgumentList arguments, R resolver) throws TranslatorException {
        CallArgument[] result;
        if (arguments == null || arguments.getParam() == null) {
            result = new CallArgument[]{};
        } else {
            EList<NamedArgument> args = arguments.getParam();
            result = new CallArgument[args.size()];
            int a = 0;
            while (a < args.size()) {
                NamedArgument arg = (NamedArgument)args.get(a);
                result[a] = new CallArgument(arg.getName(), this.processExpression(arg.getEx(), resolver));
                ++a;
            }
        }
        return result;
    }

    public abstract Expression parseExpression(String var1, R var2, StringBuilder var3) throws VilException;

    protected Expression processConstant(Constant arg, R resolver) throws TranslatorException {
        Expression result = null;
        if (arg.getNValue() != null) {
            String tmp = arg.getNValue().getVal();
            TypeDescriptor type = tmp.indexOf(46) > 0 ? TypeRegistry.realType() : TypeRegistry.integerType();
            result = ExpressionTranslator.createConstant(type, tmp, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__NVALUE, resolver.getTypeRegistry());
        } else if (arg.getSValue() != null) {
            String s = StringUtils.convertString((String)arg.getSValue());
            try {
                StringBuilder warnings = new StringBuilder();
                Expression ex = this.normalizeStringExpression(StringResolver.substitute((String)s, resolver, (StringResolver.IExpressionTranslator)this, (StringBuilder)warnings, null), s);
                if (warnings.length() > 0) {
                    this.warning(warnings.toString(), arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__SVALUE, 0);
                }
                result = ex;
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__SVALUE);
            }
        } else if (arg.getQValue() != null) {
            String name = Utils.getQualifiedNameString(arg.getQValue());
            result = Version.isVersion((String)name) ? this.convertToVersion(name, arg, resolver) : this.processQualifiedValue(name, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, resolver);
        } else if (arg.getBValue() != null) {
            result = ExpressionTranslator.createConstant(TypeRegistry.booleanType(), arg.getBValue(), arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__BVALUE, resolver.getTypeRegistry());
        } else if (arg.getNull() != null) {
            result = ExpressionTranslator.createConstant(TypeRegistry.anyType(), TypeRegistry.NULL, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__NULL, resolver.getTypeRegistry());
        } else if (arg.getVersion() != null) {
            result = this.convertToVersion(arg.getVersion(), arg, resolver);
        }
        return result;
    }

    private Expression normalizeStringExpression(Expression ex, String st) throws VilException {
        Expression ex1;
        CompositeExpression cEx;
        if (ex instanceof CompositeExpression && 1 == (cEx = (CompositeExpression)ex).getExpressionsCount() && !((ex1 = cEx.getExpression(0)) instanceof ConstantExpression)) {
            cEx.setExpression(0, (Expression)new StringExpression(ex1, st.startsWith("${")));
        }
        return ex;
    }

    private Expression convertToVersion(String text, Constant arg, R resolver) throws TranslatorException {
        Expression result;
        if (text.startsWith("v")) {
            text = text.substring(1);
        }
        try {
            result = ExpressionTranslator.createConstant(TypeRegistry.versionType(), new Version(text), arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__VERSION, resolver.getTypeRegistry());
        }
        catch (VersionFormatException e) {
            throw new TranslatorException(e.getMessage(), (EObject)arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__VERSION, e.getId());
        }
        return result;
    }

    private FieldAccessExpression process(net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var, FieldAccessExpression last, String name, Constant elt) throws TranslatorException {
        FieldAccessExpression result;
        if (last == null) {
            FieldDescriptor fd = var.getType().getField(name);
            if (fd != null) {
                try {
                    result = new FieldAccessExpression(var, fd);
                }
                catch (VilException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)elt, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
                }
            }
            throw new TranslatorException("cannot resolve field '" + name + "'", (EObject)elt, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, 20207);
        }
        try {
            FieldDescriptor fd = last.inferType().getField(name);
            if (fd == null) {
                throw new TranslatorException("cannot resolve field '" + name + "'", (EObject)elt, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, 20207);
            }
            result = new FieldAccessExpression(last, fd);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)elt, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
        }
        return result;
    }

    protected Expression processQualifiedValue(String name, Constant arg, EStructuralFeature feature, R resolver) throws TranslatorException {
        TypeDescriptor desc;
        VariableExpression result = null;
        int pos = name.indexOf(46);
        IResolvable res = null;
        if (pos > 0 && pos < name.length()) {
            String head = name.substring(0, pos);
            String tail = name.substring(pos + 1);
            res = resolver.resolve(head, false, (EObject)arg, feature, (IMessageReceiver)this);
            if (res instanceof net.ssehub.easy.instantiation.core.model.common.VariableDeclaration) {
                net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)res;
                FieldAccessExpression fae = null;
                do {
                    if ((pos = tail.indexOf(46)) >= 0) {
                        fae = this.process(var, fae, tail.substring(0, pos), arg);
                        tail = tail.substring(pos + 1);
                        continue;
                    }
                    fae = this.process(var, fae, tail, arg);
                } while (pos >= 0);
                result = fae;
                res = null;
            } else {
                FieldDescriptor field;
                TypeDescriptor type = resolver.getTypeRegistry().getType(head);
                if (type != null && (field = type.getField(tail)) != null && field.isStatic()) {
                    try {
                        result = new FieldAccessExpression(field);
                    }
                    catch (VilException e) {
                        throw new TranslatorException((IIdentifiable)e, (EObject)arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
                    }
                }
            }
        }
        if (res == null && result == null && (res = resolver.resolve(name, false, (EObject)arg, feature, (IMessageReceiver)this)) == null && (desc = resolver.getTypeRegistry().getType(name, false)) != null) {
            result = new VilTypeExpression(name, desc);
        }
        if (res == null && result == null) {
            if ("ITER".equals(name)) {
                throw new TranslatorException("iterator variable ITER cannot be resolved", (EObject)arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, 20211);
            }
            TypeRegistry registry = resolver.getTypeRegistry();
            TypeDescriptor type = registry.getType(name, false);
            if (type == null) {
                net.ssehub.easy.varModel.model.values.EnumValue eValue;
                Object ivmlElement = resolver.getIvmlElement(name);
                if (ivmlElement instanceof net.ssehub.easy.varModel.model.values.EnumValue && (type = registry.getType((eValue = (net.ssehub.easy.varModel.model.values.EnumValue)ivmlElement).getType())) != null) {
                    try {
                        result = new ConstantExpression(type, (Object)new EnumValue(eValue), registry);
                        this.checkOclEnumCompliance(name, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
                    }
                    catch (VilException e) {
                        throw new TranslatorException((IIdentifiable)e, (EObject)arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
                    }
                }
                if (result == null) {
                    VarModelIdentifierExpression vmie;
                    if (ivmlElement instanceof DecisionVariableDeclaration) {
                        type = registry.getType(((DecisionVariableDeclaration)ivmlElement).getType());
                    } else if (ivmlElement instanceof IvmlElement) {
                        type = ((IvmlElement)ivmlElement).getType();
                    }
                    this.lastVarModelIdentifierEx = vmie = new VarModelIdentifierExpression(name, type, resolver.getCurrentModel());
                    result = vmie;
                    if (ivmlElement == null) {
                        this.ivmlMessageAdapter.notify(vmie, arg);
                    }
                }
            } else {
                result = new VilTypeExpression(name, type);
                this.ivmlWarning(name, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
            }
        } else if (res instanceof net.ssehub.easy.instantiation.core.model.common.VariableDeclaration) {
            result = new VariableExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)res, name);
        } else if (res instanceof IvmlElement) {
            result = new VarModelIdentifierExpression(name, ((IvmlElement)res).getType(), resolver.getCurrentModel());
        } else if (result == null) {
            throw new TranslatorException(name + " is no variable", (EObject)arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, 20203);
        }
        return result;
    }

    private void checkOclEnumCompliance(String name, EObject cause, EStructuralFeature causeFeature) {
        int pos;
        if (ExpressionWriter.considerOclCompliance() && (pos = name.indexOf(46)) > 0) {
            this.warning("OCL compliance: literal access by '.' is discouraged, use '::' instead", cause, causeFeature, -1);
        }
    }

    protected static final Expression createConstant(TypeDescriptor<?> type, Object value, EObject cause, EStructuralFeature causingFeature, TypeRegistry registry) throws TranslatorException {
        try {
            return new ConstantExpression(type, value, registry);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, cause, causingFeature);
        }
    }

    public TypeDescriptor<?> processType(Type type, R resolver) throws TranslatorException {
        String typeName;
        TypeDescriptor result;
        if (type == null) {
            throw new TranslatorException("no type given", (EObject)type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__NAME, 30003);
        }
        if (type.getSeq() != null) {
            param = this.processTypeParameter(type.getParam(), type, resolver);
            try {
                result = TypeRegistry.getSequenceType(param);
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__SEQ);
            }
        } else if (type.getSet() != null) {
            param = this.processTypeParameter(type.getParam(), type, resolver);
            try {
                result = TypeRegistry.getSetType(param);
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__SET);
            }
        } else if (type.getMap() != null) {
            param = this.processTypeParameter(type.getParam(), type, resolver);
            try {
                result = TypeRegistry.getMapType(param);
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__SET);
            }
        } else if (type.getCall() != null) {
            param = this.processTypeParameter(type.getParam(), type, resolver);
            TypeDescriptor[] tmp = new TypeDescriptor[param.length + 1];
            System.arraycopy(param, 0, tmp, 0, param.length);
            TypeDescriptor<?> ret = type.getReturn() == null ? ReflectionTypeDescriptor.VOID : this.processType(type.getReturn(), resolver);
            tmp[tmp.length - 1] = ret;
            try {
                result = TypeRegistry.getRuleType((TypeDescriptor[])tmp);
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__CALL);
            }
        } else {
            typeName = Utils.getQualifiedNameString(type.getName());
            TypeRegistry reg = resolver.getTypeRegistry();
            result = reg.getType(typeName, false);
            if (result == null) {
                result = this.resolveModelType(type, typeName, resolver);
            }
            if (result == null) {
                result = reg.getType(typeName);
            }
            if (result == null) {
                throw new TranslatorException("type '" + typeName + "' unknown", (EObject)type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__NAME, 20200);
            }
        }
        if (result.isPlaceholder()) {
            typeName = Utils.getQualifiedNameString(type.getName());
            this.ivmlWarning(typeName, type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__NAME);
        }
        return result;
    }

    private TypeDescriptor<?> resolveModelType(Type type, String typeName, R resolver) throws TranslatorException {
        TypeDescriptor result = resolver.resolveType(typeName);
        if (result != null) {
            TypeRegistry registry = resolver.getTypeRegistry();
            try {
                TypeDescriptor tmp;
                if (registry.addTypeAlias(typeName, result) && (tmp = registry.getType(typeName)) != null) {
                    result = tmp;
                }
            }
            catch (VilException e) {
                throw new TranslatorException("type '" + typeName + "' unknown: " + e.getMessage(), (EObject)type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__NAME, 20200);
            }
        }
        return result;
    }

    private ContainerInitializerExpression processContainerInitializer(ContainerInitializer initializer, R resolver) throws TranslatorException {
        ContainerInitializerExpression result;
        if (initializer.getExprs() != null) {
            int dimensions = -1;
            ArrayList<TypeDescriptor> partDims = new ArrayList<TypeDescriptor>();
            ArrayList<Expression> inits = new ArrayList<Expression>();
            for (de.uni_hildesheim.sse.vil.expressions.expressionDsl.ContainerInitializerExpression initEx : initializer.getExprs()) {
                Expression part = null;
                partDims.clear();
                try {
                    if (initEx.getLogical() != null) {
                        part = this.processLogicalExpression(initEx.getLogical(), resolver);
                        if (part != null) {
                            partDims.add(part.inferType());
                        }
                    } else if (initEx.getContainer() != null) {
                        part = this.processContainerInitializer(initEx.getContainer(), resolver);
                        TypeDescriptor partType = part.inferType();
                        int d = 0;
                        while (d < partType.getGenericParameterCount()) {
                            partDims.add(partType.getGenericParameterType(d));
                            ++d;
                        }
                    }
                }
                catch (VilException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)initEx, (EStructuralFeature)ExpressionDslPackage.Literals.CONTAINER_INITIALIZER_EXPRESSION__CONTAINER);
                }
                if (partDims.isEmpty()) {
                    throw new TranslatorException("unknown dimension of container initializer", (EObject)initEx, (EStructuralFeature)ExpressionDslPackage.Literals.CONTAINER_INITIALIZER_EXPRESSION__CONTAINER, 20212);
                }
                if (dimensions < 0) {
                    dimensions = partDims.size();
                } else if (dimensions != partDims.size()) {
                    throw new TranslatorException("unmatching dimension of container initializer part", (EObject)initEx, (EStructuralFeature)ExpressionDslPackage.Literals.CONTAINER_INITIALIZER_EXPRESSION__CONTAINER, 20212);
                }
                inits.add(part);
            }
            Expression[] exprs = new Expression[inits.size()];
            inits.toArray(exprs);
            result = new ContainerInitializerExpression(exprs);
        } else {
            result = new ContainerInitializerExpression();
        }
        return result;
    }

    protected TypeDescriptor<?>[] processTypeParameter(TypeParameters param, Type type, R resolver) throws TranslatorException {
        EList<Type> params = param.getParam();
        TypeDescriptor[] result = TypeDescriptor.createArray((int)params.size());
        int i = 0;
        while (i < params.size()) {
            result[i] = this.processType((Type)params.get(i), resolver);
            ++i;
        }
        return result;
    }

    public Expression processAssignment(EObject cause, TypeDescriptor<?> type, de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression ex, R resolver) throws TranslatorException {
        Expression init = null;
        if (ex != null) {
            init = this.processExpression(ex, resolver);
            try {
                ContainerInitializerExpression tmp;
                TypeDescriptor tmpType;
                ContainerInitializerExpression cie;
                TypeDescriptor exType = init.inferType();
                boolean ok = type.isAssignableFrom(exType);
                TypeDescriptor checkType = type;
                if (!ok && type.getBaseType() instanceof TypeDescriptor && exType.getBaseType() == null) {
                    checkType = (TypeDescriptor)type.getBaseType();
                }
                if (!ok && checkType.isSequence() && exType.isSequence() && exType.getGenericParameterCount() == 0 && init instanceof ContainerInitializerExpression) {
                    cie = (ContainerInitializerExpression)init;
                    boolean bl = ok = cie.getInitExpressionsCount() == 0;
                }
                if (!ok && checkType.isSet() && exType.isSequence() && exType.getGenericParameterCount() == 0 && init instanceof ContainerInitializerExpression && (cie = (ContainerInitializerExpression)init).getInitExpressionsCount() == 0) {
                    init = cie.toSet();
                    exType = cie.inferType();
                    ok = true;
                }
                if (!ok && checkType.isSet() && exType.isSequence() && init instanceof ContainerInitializerExpression && checkType.isAssignableFrom(tmpType = (tmp = (cie = (ContainerInitializerExpression)init).toSet()).inferType())) {
                    init = tmp;
                    exType = tmpType;
                    ok = true;
                }
                if (!ok && TypeRegistry.resolvableOperationType().isAssignableFrom(checkType) && IvmlTypes.ivmlElement().isAssignableFrom(exType)) {
                    init = new DeferredResolvableOperationExpression(cause, type, init);
                    ok = true;
                }
                if (!ok) {
                    OperationDescriptor conv2;
                    OperationDescriptor conversion = TypeDescriptor.findConversionOnBoth((TypeDescriptor)exType, (TypeDescriptor)checkType);
                    if (conversion != null && !type.isAssignableFrom(conversion.getReturnType()) && !exType.isCollection() && (conv2 = type.findConversion(exType, type)) != null) {
                        conversion = conv2;
                    }
                    if (conversion == null) {
                        this.throwVariableCannotBeInitialized(cause, ExpressionTranslator.getName(cause), type, exType);
                    } else {
                        init = new CallExpression(conversion, new CallArgument(init));
                    }
                }
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, cause, (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__TYPE);
            }
        }
        return init;
    }

    public I processVariableDeclaration(VariableDeclaration decl, R resolver) throws TranslatorException {
        String name = decl.getName();
        if (resolver.resolve(name, true) != null) {
            throw new TranslatorException("variable '" + name + "' was already declared", (EObject)decl, (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__NAME, 20205);
        }
        TypeDescriptor<?> type = this.processType(decl.getType(), resolver);
        boolean isConstant = decl.getConst() != null;
        Expression init = this.processAssignment(decl, type, decl.getExpression(), resolver);
        I result = this.createVariableDeclaration(name, type, isConstant, init, resolver);
        resolver.add(result);
        return result;
    }

    public void reProcessVariableDeclaration(I decl, R resolver) throws TranslatorException {
        Expression init = decl.getExpression();
        if (init instanceof DeferredResolvableOperationExpression) {
            DeferredResolvableOperationExpression defEx = (DeferredResolvableOperationExpression)init;
            try {
                IMetaOperation op;
                boolean done = false;
                IModel model = resolver.getCurrentModel();
                Expression defExInit = defEx.getInit();
                TypeDescriptor<?> varType = defEx.getVarType();
                TypeDescriptor defExInitType = defExInit.inferType();
                if (model instanceof IMetaType && (op = AbstractCallExpression.resolveResolvableOperation((IMetaType)((IMetaType)model), varType, (IMetaType)defExInitType, (Expression)defExInit, (ResolutionListener)this)) != null) {
                    decl.resolveOperation(defEx.getVarType(), op);
                    done = true;
                }
                if (!done) {
                    this.throwVariableCannotBeInitialized(defEx.getCause(), null, varType, defExInitType);
                }
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, defEx.getCause(), (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__TYPE);
            }
        }
    }

    private void throwVariableCannotBeInitialized(EObject cause, String name, TypeDescriptor<?> declType, TypeDescriptor<?> initType) throws TranslatorException {
        if (name == null) {
            name = ExpressionTranslator.getName(cause);
        }
        throw new TranslatorException("'" + name + "' of type '" + declType.getVilName() + "' cannot be initialized with an expression of type '" + initType.getVilName() + "'", cause, (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__NAME, 20203);
    }

    private static String getName(EObject cause) {
        String name = "?";
        if (cause != null) {
            try {
                Method m = cause.getClass().getDeclaredMethod("getName", new Class[0]);
                Object o = m.invoke((Object)cause, new Object[0]);
                if (o != null) {
                    name = o.toString();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return name;
    }

    protected boolean continueResolution(VilException semanticException) {
        return semanticException != null && (semanticException.getId() == 70002 || semanticException.getId() == 70001);
    }

    public void error(AbstractException exception, EObject cause, EStructuralFeature causeFeature) {
        this.error(exception.getMessage(), cause, causeFeature, exception.getId());
    }

    public void warning(AbstractException exception, EObject cause, EStructuralFeature causeFeature) {
        this.error(exception.getMessage(), cause, causeFeature, exception.getId());
    }

    public void warnVersionRestrictions(VersionSpec spec) {
    }

    public IVersionRestriction processRestriction(String name, VersionSpec spec, R resolver) throws TranslatorException {
        ExpressionVersionRestriction result = null;
        if (spec != null && spec.getRestriction() != null) {
            resolver.pushLevel();
            I versionVariable = this.createVariableDeclaration("version", TypeRegistry.versionType(), false, null, resolver);
            resolver.add(versionVariable);
            try {
                result = this.createExpressionVersionRestriction(this.processExpression(spec.getRestriction(), resolver), (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)versionVariable, spec.getRestriction(), (EStructuralFeature)ExpressionDslPackage.Literals.VERSION_SPEC__RESTRICTION);
                resolver.popLevel();
            }
            catch (RestrictionEvaluationException e) {
                throw new TranslatorException(e.getMessage(), (EObject)spec, (EStructuralFeature)ExpressionDslPackage.Literals.VERSION_SPEC__RESTRICTION, e.getId());
            }
        }
        return result;
    }

    protected abstract ExpressionVersionRestriction createExpressionVersionRestriction(Expression var1, net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var2, EObject var3, EStructuralFeature var4) throws RestrictionEvaluationException;

    public void resolved(VarModelIdentifierExpression ex) {
        this.ivmlMessageAdapter.resolve(ex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression assertBooleanExpression(Expression expression, EObject cause, EStructuralFeature causingFeature) throws TranslatorException {
        if (expression == null) return expression;
        try {
            TypeDescriptor type = expression.inferType();
            boolean ok = false;
            if (IvmlTypes.decisionVariableType().isAssignableFrom(type)) {
                ok = true;
                IMetaOperation convOp = TypeHelper.findConversion((IMetaType)type, (IMetaType)TypeRegistry.booleanType());
                if (!(convOp instanceof OperationDescriptor)) throw new TranslatorException("No conversion from decisionVariable to Boolean defined", cause, causingFeature, 20203);
                expression = new CallExpression((OperationDescriptor)convOp, new CallArgument(expression));
            } else {
                ok = TypeRegistry.booleanType().isAssignableFrom(type);
            }
            if (ok) return expression;
            throw new TranslatorException("condition must be a Boolean expression rather than " + type.getVilName(), cause, causingFeature, 20203);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, cause, causingFeature);
        }
    }

    protected static enum CallType {
        SUPER,
        SYSTEM,
        OTHER,
        ITERATOR;

    }
}

