/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation;

import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Call;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.translation.ExpressionTranslator;
import de.uni_hildesheim.sse.vil.templatelang.TemplateLangModelUtility;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Stmt;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.SubCall;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.IIdentifiable;
import net.ssehub.easy.basics.messages.IMessageHandler;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.dslCore.translation.MessageHandler;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.ModelCallExpression;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionVersionRestriction;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionVersionRestrictionValidator;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.BuilderBlockExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ImplicitVariableDeclaration;
import net.ssehub.easy.instantiation.core.model.templateModel.Resolver;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ExpressionTranslator
extends de.uni_hildesheim.sse.vil.expressions.translation.ExpressionTranslator<VariableDeclaration, Resolver, ExpressionStatement> {
    private IStatementTranslator sTranslator;

    public void setStatementTranslator(IStatementTranslator sTranslator) {
        this.sTranslator = sTranslator;
    }

    protected Expression processCall(Expression firstParam, Call call, ExpressionTranslator.CallType type, de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression arrayEx, Resolver resolver) throws TranslatorException {
        VariableDeclaration opVar;
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>();
        if (firstParam != null) {
            arguments.add(new CallArgument(firstParam));
        }
        List varDecls = this.resolveIteratorDeclarations(call, type, arguments, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        String name = this.resolveCallArguments(call, varDecls, arguments, arrayEx, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        CallArgument[] arg = new CallArgument[arguments.size()];
        arguments.toArray(arg);
        if (ExpressionTranslator.CallType.SYSTEM == type) {
            throw new TranslatorException("system calls are not supported", (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, 20100);
        }
        ModelCallExpression result = null;
        VilException semanticException = null;
        try {
            result = resolver.createCallExpression(ExpressionTranslator.CallType.SUPER == type, name, arg);
        }
        catch (VilException e) {
            semanticException = e;
        }
        if (result == null || this.continueResolution(semanticException)) {
            try {
                result = new CallExpression(null, name, arg);
                semanticException = this.checkSemantics((Expression)result);
            }
            catch (VilException e) {
                // empty catch block
            }
        }
        if (result == null || this.continueResolution(semanticException)) {
            try {
                result = resolver.createExtensionCallExpression(name, arg);
                semanticException = this.checkSemantics((Expression)result);
            }
            catch (VilException e) {
                // empty catch block
            }
        }
        if ((result == null || this.continueResolution(semanticException)) && (opVar = (VariableDeclaration)resolver.resolve(name, false)) != null) {
            try {
                result = new ResolvableOperationCallExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)opVar, arg);
                semanticException = this.checkSemantics((Expression)result);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        if (semanticException != null) {
            throw new TranslatorException((IIdentifiable)semanticException, (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME);
        }
        return this.checkCallExpression((AbstractCallExpression)result, type, call);
    }

    protected VariableDeclaration createVariableDeclaration(String name, TypeDescriptor<?> type, boolean isConstant, Expression expression, Resolver resolver) {
        return new VariableDeclaration(name, type, isConstant, expression);
    }

    protected VariableDeclaration createImplicitVariableDeclaration(String name, TypeDescriptor<?> type, boolean isConstant, Expression expression, Resolver resolver) {
        return new ImplicitVariableDeclaration(name, type, isConstant, expression);
    }

    protected ExpressionVersionRestriction createExpressionVersionRestriction(Expression expr, net.ssehub.easy.instantiation.core.model.common.VariableDeclaration decl, EObject cause, EStructuralFeature feature) throws RestrictionEvaluationException {
        try {
            ExpressionVersionRestrictionValidator validator = new ExpressionVersionRestrictionValidator((IMessageHandler)new MessageHandler((MessageReceiver)this, cause, feature));
            expr.accept((IExpressionVisitor)validator);
            return new net.ssehub.easy.instantiation.core.model.templateModel.ExpressionVersionRestriction(expr, decl);
        }
        catch (VilException e) {
            throw new RestrictionEvaluationException(e.getMessage(), e.getId());
        }
    }

    public Expression parseExpression(String expression, Resolver resolver, StringBuilder warnings) throws VilException {
        return TemplateLangModelUtility.INSTANCE.createExpression(expression, resolver, warnings, this.getIvmlMessageAdapter());
    }

    protected ExpressionStatement createExpressionStatement(Expression expression, Resolver resolver) {
        return new ExpressionStatement(expression, (ILanguageElement)resolver.getCurrentModel());
    }

    protected String cannotAssignHint() {
        return "VTL cannot assign values to configurable elements.";
    }

    protected Expression processSubCall(Expression result, de.uni_hildesheim.sse.vil.expressions.expressionDsl.SubCall call, ExpressionTranslator.CallType callType, Resolver resolver) throws TranslatorException {
        SubCall sc;
        Expression subCallResult = null;
        if (call instanceof SubCall && (sc = (SubCall)call).getType() == null && sc.getArrayEx() == null) {
            resolver.pushLevel();
            try {
                BuilderBlockExpression.Mode mode = BuilderBlockExpression.Mode.NONE;
                TypeDescriptor varType = result.inferType();
                String varName = "o";
                if (sc.getId() != null) {
                    mode = BuilderBlockExpression.Mode.NAME;
                    if (sc.getVarType() != null) {
                        varType = this.processType(sc.getVarType(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
                        mode = BuilderBlockExpression.Mode.TYPE_NAME;
                    }
                    varName = sc.getId();
                }
                VariableDeclaration varDecl = new VariableDeclaration(varName, varType, false, result);
                resolver.add((IResolvable)varDecl);
                ArrayList<ITemplateElement> blockElements = new ArrayList<ITemplateElement>();
                if (this.sTranslator != null) {
                    for (Stmt stmt : sc.getNested()) {
                        blockElements.add(this.sTranslator.processStatement(stmt));
                    }
                } else {
                    throw new TranslatorException("No statement translator given", (EObject)sc, (EStructuralFeature)ExpressionDslPackage.Literals.SUB_CALL__TYPE, 20100);
                }
                subCallResult = new BuilderBlockExpression(varDecl, mode, new TemplateBlock(blockElements.toArray(new ITemplateElement[0])));
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)sc, (EStructuralFeature)ExpressionDslPackage.Literals.SUB_CALL__TYPE);
            }
            resolver.popLevel();
        }
        if (subCallResult == null) {
            subCallResult = super.processSubCall(result, call, callType, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        }
        return subCallResult;
    }

    public static interface IStatementTranslator {
        public ITemplateElement processStatement(Stmt var1) throws TranslatorException;
    }
}

