/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.vil.templatelang;

import com.google.inject.Guice;
import com.google.inject.Module;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Import;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionStmt;
import de.uni_hildesheim.sse.vil.expressions.translation.IvmlMessageAdapter;
import de.uni_hildesheim.sse.vil.templatelang.TemplateLangRuntimeModule;
import de.uni_hildesheim.sse.vil.templatelang.TemplateLangStandaloneSetup;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.HintedExpression;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.LanguageUnit;
import de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation.ExpressionTranslator;
import de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation.ModelTranslator;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.dslCore.ModelUtility;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.Resolver;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateLangWriter;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;

public class TemplateLangModelUtility
extends ModelUtility<LanguageUnit, Template>
implements IModelLoader<Template> {
    public static final TemplateLangModelUtility INSTANCE = new TemplateLangModelUtility();

    private TemplateLangModelUtility() {
    }

    protected void initializeAfterResourceInitializer() {
        if (TemplateLangModelUtility.getResourceInitializer().forEclipse()) {
            this.setInjector(Guice.createInjector((Module[])new Module[]{new TemplateLangRuntimeModule()}));
        } else {
            this.setInjector(new TemplateLangStandaloneSetup().createInjectorAndDoEMFRegistration());
        }
    }

    public TranslationResult<Template> createModel(LanguageUnit root, java.net.URI uri, boolean registerSuccessful) {
        ModelTranslator translator = new ModelTranslator();
        ArrayList<Template> result = new ArrayList<Template>();
        result.add(translator.createModel(root, uri, registerSuccessful, null));
        return new TranslationResult(result, (MessageReceiver)translator);
    }

    public TranslationResult<Template> parse(URI uri, ImportResolver<Template> resolver) throws IOException {
        ModelTranslator translator = new ModelTranslator();
        LanguageUnit root = (LanguageUnit)this.parse(uri, false, (MessageReceiver)translator, LanguageUnit.class);
        ArrayList<Template> result = null;
        if (root != null) {
            try {
                result = new ArrayList<Template>();
                Template tpl = translator.createModel(root, TemplateLangModelUtility.toNetUri((URI)uri), true, resolver);
                if (tpl != null) {
                    result.add(tpl);
                }
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return new TranslationResult(result, (MessageReceiver)translator);
    }

    public void print(TranslationResult<Template> result, Writer out, boolean emitComments, boolean emitImports) {
        try {
            TemplateLangWriter writer = new TemplateLangWriter(out);
            int p = 0;
            while (p < result.getResultCount()) {
                try {
                    ((Template)result.getResult(p)).accept((IVisitor)writer);
                }
                catch (VilException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(TemplateLangModelUtility.class, "de.uni_hildesheim.sse.vil.templatelang");
                }
                ++p;
            }
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getLanguageName() {
        return "de.uni_hildesheim.sse.vil.templatelang.TemplateLang";
    }

    protected ClassLoader getLanguageClassLoader() {
        return TemplateLangModelUtility.class.getClassLoader();
    }

    public Expression createExpression(String text, Resolver resolver, StringBuilder warnings) throws VilException {
        return this.createExpression(text, resolver, warnings, null);
    }

    public Expression createExpression(String text, Resolver resolver, StringBuilder warnings, IvmlMessageAdapter adapter) throws VilException {
        Expression result;
        block13: {
            result = null;
            IParseResult parseResult = this.parseFragment("HintedExpression", text);
            if (parseResult != null) {
                StringBuilder errors = new StringBuilder();
                for (INode error : parseResult.getSyntaxErrors()) {
                    TemplateLangModelUtility.appendWithNewLine((StringBuilder)errors, (String)error.getText());
                }
                if (errors.length() == 0 && parseResult.getRootASTElement() == null) {
                    TemplateLangModelUtility.appendWithNewLine((StringBuilder)errors, (String)"empty expression");
                }
                if (errors.length() == 0) {
                    ExpressionTranslator translator = new ExpressionTranslator();
                    if (adapter != null) {
                        translator.setIvmlMessageAdapter(adapter);
                    }
                    HintedExpression expr = (HintedExpression)parseResult.getRootASTElement();
                    try {
                        result = translator.processExpression(expr.getEx(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
                        if (expr.getHint() != null) {
                            result = new net.ssehub.easy.instantiation.core.model.templateModel.HintedExpression(result, expr.getHint());
                        }
                        int i = 0;
                        while (i < translator.getMessageCount()) {
                            Message msg = translator.getMessage(i);
                            if (Status.ERROR == msg.getStatus()) {
                                TemplateLangModelUtility.appendWithNewLine((StringBuilder)errors, (String)msg.getDescription());
                            } else if (warnings != null) {
                                TemplateLangModelUtility.appendWithNewLine((StringBuilder)warnings, (String)msg.getDescription());
                            }
                            ++i;
                        }
                        if (translator.getErrorCount() > 0) {
                            throw new VilException(errors.toString(), 70000);
                        }
                        break block13;
                    }
                    catch (TranslatorException e) {
                        throw new VilException((Throwable)e, e.getId());
                    }
                }
                throw new VilException(errors.toString() + " in expression '" + text + "'", 30003);
            }
        }
        return result;
    }

    public Expression createExpression(String text, IRuntimeEnvironment environment) throws VilException {
        return this.createExpression(text, new Resolver(environment), null);
    }

    public String getExtension() {
        return "vtl";
    }

    public List<ModelInfo<Template>> obtainInfo(URI uri) throws IOException {
        LanguageUnit template = (LanguageUnit)this.parse(uri, true, null, LanguageUnit.class);
        ArrayList<ModelInfo<Template>> result = new ArrayList<ModelInfo<Template>>();
        if (template != null) {
            Version version = ModelTranslator.convert((VersionStmt)template.getVersion());
            ArrayList<ModelImport> imports = new ArrayList<ModelImport>();
            for (Import imp : template.getImports()) {
                String name = imp.getName();
                imports.add(new ModelImport(name, false, null));
            }
            try {
                result.add((ModelInfo<Template>)new ModelInfo(template.getName(), version, (IModelLoader)this, TemplateLangModelUtility.toNetUri((URI)uri), imports));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    public ModelInfo<Template> getInfo(java.net.URI uri) {
        return TemplateModel.INSTANCE.availableModels().getInfo(uri);
    }
}

