/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation;

import de.uni_hildesheim.sse.vil.expressions.ResourceRegistry;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.PrimaryExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionStmt;
import de.uni_hildesheim.sse.vil.expressions.translation.IvmlMessageAdapter;
import de.uni_hildesheim.sse.vil.templatelang.TemplateLangModelUtility;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Alternative;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Content;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Extension;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.FormattingHint;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.FormattingHintPart;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.IndentationHint;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.IndentationHintPart;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.JavaQualifiedName;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.LanguageUnit;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Loop;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Stmt;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.StmtBlock;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Switch;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.SwitchPart;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.TemplateLangPackage;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.VilDef;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.While;
import de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation.DefInfo;
import de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation.ExpressionTranslator;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.messages.AbstractException;
import net.ssehub.easy.basics.messages.IIdentifiable;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.dslCore.translation.StringUtils;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.common.ICompoundReceiver;
import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.IResolvableOperation;
import net.ssehub.easy.instantiation.core.model.common.ITypedefReceiver;
import net.ssehub.easy.instantiation.core.model.common.IVariableDeclarationReceiver;
import net.ssehub.easy.instantiation.core.model.common.Imports;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.expressions.IStringParserFactory;
import net.ssehub.easy.instantiation.core.model.expressions.StringResolver;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.AlternativeStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Compound;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.FlushStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.JavaExtension;
import net.ssehub.easy.instantiation.core.model.templateModel.LoopStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Resolver;
import net.ssehub.easy.instantiation.core.model.templateModel.StringResolverFactory;
import net.ssehub.easy.instantiation.core.model.templateModel.SwitchStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateDescriptor;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateLangExecution;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.templateModel.TypeDef;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.templateModel.WhileStatement;
import net.ssehub.easy.instantiation.core.model.vilTypes.CompoundTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelTranslator
extends de.uni_hildesheim.sse.vil.expressions.translation.ModelTranslator<Template, VariableDeclaration, Resolver, ExpressionStatement, ExpressionTranslator>
implements ExpressionTranslator.IStatementTranslator {
    private ExpressionTranslator expressionTranslator = (ExpressionTranslator)this.getExpressionTranslator();
    private Resolver resolver;

    public ModelTranslator() {
        super((de.uni_hildesheim.sse.vil.expressions.translation.ExpressionTranslator)new ExpressionTranslator(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)new Resolver(new TypeRegistry(TypeRegistry.DEFAULT)));
        this.expressionTranslator.setStatementTranslator(this);
        this.resolver = (Resolver)this.getResolver();
    }

    public Template createModel(LanguageUnit tpl, URI uri, boolean registerSuccessful, ImportResolver<Template> impResolver) {
        Template result;
        block13: {
            result = null;
            boolean pushed = false;
            int errorCount = this.getErrorCount();
            ResourceRegistry.register((Resource)tpl.eResource(), (TypeRegistry)this.resolver.getTypeRegistry());
            try {
                TemplateDescriptor desc = new TemplateDescriptor();
                Imports imports = this.processImports(tpl.getImports());
                desc.setImports(imports);
                desc.setAdvices(this.processAdvices(tpl.getAdvices(), uri));
                this.processJavaExtensions(tpl, desc);
                ModelImport extension = this.getExtensionImport(tpl.getExt(), imports, (EObject)tpl, (EStructuralFeature)TemplateLangPackage.Literals.LANGUAGE_UNIT__EXT);
                if (tpl.getIndent() != null) {
                    desc.setIndentationConfiguration(this.processIndentHint(tpl.getIndent()));
                }
                if (tpl.getFormatting() != null) {
                    desc.setFormattingConfiguration(this.processFormattingHint(tpl.getFormatting()));
                }
                result = new Template(tpl.getName(), extension, desc, this.resolver.getTypeRegistry());
                result.setVersion(ModelTranslator.convert((VersionStmt)tpl.getVersion()));
                this.resolveImports(tpl, (EStructuralFeature)ExpressionDslPackage.Literals.LANGUAGE_UNIT__IMPORTS, (IModel)result, uri, new ArrayList(), impResolver);
                this.resolver.pushModel(result);
                desc.setParameter((VariableDeclaration[])this.resolveParameters(tpl.getParam(), (EObject)tpl, (EStructuralFeature)TemplateLangPackage.Literals.LANGUAGE_UNIT__PARAM, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver), this.resolver);
                result.setParams(desc);
                pushed = true;
                this.resolver.enumerateImports((IResolvableModel)result);
                List elts = ModelTranslator.copy(tpl.getElements());
                if (elts != null) {
                    this.processCompoundContents(elts, (ICompoundReceiver)result);
                    this.processTypedefContents(elts, (ITypedefReceiver)result);
                    this.processGlobalVariableDeclarations(elts, result);
                    this.processDefs(elts, result);
                    this.reProcessGlobalVariableDeclarations(result);
                }
                if (registerSuccessful && errorCount == this.getErrorCount()) {
                    TemplateModel.INSTANCE.updateModel((IModel)result, uri, (IModelLoader)TemplateLangModelUtility.INSTANCE);
                }
            }
            catch (VilException e) {
                this.error(e, (EObject)tpl, (EStructuralFeature)ExpressionDslPackage.Literals.LANGUAGE_UNIT__NAME);
                if (pushed) {
                    this.resolver.popModel();
                }
                break block13;
            }
            catch (TranslatorException e) {
                try {
                    this.error(e);
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (pushed) {
                        this.resolver.popModel();
                    }
                }
            }
            if (!pushed) break block13;
            this.resolver.popModel();
        }
        ((ExpressionTranslator)this.getExpressionTranslator()).enactIvmlWarnings();
        return result;
    }

    protected void processGlobalVariableDeclarations(List<EObject> elts, Template result) {
        List decls = ModelTranslator.select(elts, de.uni_hildesheim.sse.vil.expressions.expressionDsl.VariableDeclaration.class);
        this.processVariableDeclarations(decls, (IVariableDeclarationReceiver)result);
    }

    private IndentationConfiguration processIndentHint(IndentationHint hint) {
        IndentationConfiguration result = null;
        if (hint != null) {
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            HashSet<String> assigned = new HashSet<String>();
            values.put("indentation", -1);
            values.put("tabEmulation", -1);
            values.put("additional", 1);
            for (IndentationHintPart part : hint.getParts()) {
                String name = part.getName();
                if (!values.containsKey(name)) {
                    this.warning("indentation entry '" + name + "' is unknown - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.INDENTATION_HINT_PART__NAME, 20207);
                    continue;
                }
                if (assigned.contains(name)) {
                    this.warning("indentation entry '" + name + "' is already specified - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.INDENTATION_HINT_PART__NAME, 20207);
                    continue;
                }
                try {
                    int value = Integer.parseInt(part.getValue());
                    if (value < 0) {
                        this.warning("indentation value is negative - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.INDENTATION_HINT_PART__NAME, 20207);
                    }
                    values.put(name, value);
                    assigned.add(name);
                }
                catch (NumberFormatException e) {
                    this.warning("indentation value is not an integer - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.INDENTATION_HINT_PART__NAME, 20207);
                }
            }
            result = new IndentationConfiguration(((Integer)values.get("indentation")).intValue(), ((Integer)values.get("tabEmulation")).intValue(), ((Integer)values.get("additional")).intValue());
        }
        return result;
    }

    private FormattingConfiguration processFormattingHint(FormattingHint hint) {
        FormattingConfiguration result = null;
        if (hint != null) {
            result = new FormattingConfiguration();
            for (FormattingHintPart part : hint.getParts()) {
                String name = part.getName();
                if ("lineEnd".equals(name)) {
                    result.setLineEnding(StringUtils.convertString((String)part.getValue()));
                    continue;
                }
                if ("lineLength".equals(name)) {
                    try {
                        result.setLineLength(Integer.parseInt(this.getFormattingHintPartNumStringValue(part)));
                    }
                    catch (NumberFormatException e) {
                        this.warning("lineLength value is not an integer - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.FORMATTING_HINT_PART__NAME, 20207);
                    }
                    continue;
                }
                if ("indentSteps".equals(name)) {
                    try {
                        result.setIndentSteps(Integer.parseInt(this.getFormattingHintPartNumStringValue(part)));
                    }
                    catch (NumberFormatException e) {
                        this.warning("indentSteps value is not an integer - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.FORMATTING_HINT_PART__NAME, 20207);
                    }
                    continue;
                }
                if ("charset".equals(name)) {
                    try {
                        result.setCharset(Charset.forName(this.getFormattingHintPartNumStringValue(part)));
                    }
                    catch (IllegalCharsetNameException e) {
                        this.warning("charset value does not denote a valid charset - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.FORMATTING_HINT_PART__NAME, 20207);
                    }
                    continue;
                }
                if ("useTabs".equals(name)) {
                    result.setUseTabs(Boolean.valueOf(this.getFormattingHintPartNumStringValue(part)).booleanValue());
                    continue;
                }
                if ("profile".equals(name)) {
                    result.setProfile(StringUtils.convertString((String)part.getValue()));
                    continue;
                }
                if (!name.startsWith("profileArg_")) continue;
                String argName = name.substring("profileArg_".length());
                result.setProfileArgument(argName, this.getFormattingHintPartNumStringValue(part));
            }
        }
        return result;
    }

    private String getFormattingHintPartNumStringValue(FormattingHintPart part) {
        String val = part.getNumValue() != null ? part.getNumValue() : part.getValue();
        if (val != null) {
            val = StringUtils.convertString((String)val);
        }
        return val;
    }

    protected void reProcessGlobalVariableDeclarations(Template model) {
        int v = 0;
        while (v < model.getVariableDeclarationCount()) {
            try {
                ((ExpressionTranslator)this.getExpressionTranslator()).reProcessVariableDeclaration((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)model.getVariableDeclaration(v), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
            }
            catch (TranslatorException e) {
                this.error(e);
            }
            ++v;
        }
    }

    private void processJavaExtensions(LanguageUnit tpl, TemplateDescriptor desc) throws TranslatorException {
        int extCount = TemplateLangExecution.getDefaultExtensionCount();
        EList<Extension> exts = tpl.getJavaExts();
        if (extCount > 0 || exts != null) {
            HashSet<String> knownTypes = new HashSet<String>();
            HashSet<String> knownSignatures = new HashSet<String>();
            Iterator iter = this.resolver.getTypeRegistry().allTypes().iterator();
            while (iter.hasNext()) {
                knownTypes.add(((TypeDescriptor)iter.next()).getName());
            }
            int e = 0;
            while (e < extCount) {
                desc.addJavaExtension(this.processJavaExtension(TemplateLangExecution.getDefaultExtension((int)e), knownTypes, knownSignatures, (EObject)tpl, (EStructuralFeature)TemplateLangPackage.Literals.LANGUAGE_UNIT__JAVA_EXTS));
                ++e;
            }
            if (exts != null) {
                for (Extension ext : exts) {
                    desc.addJavaExtension(this.processJavaExtension(ext, knownTypes, knownSignatures));
                }
            }
        }
    }

    private JavaExtension processJavaExtension(Extension ext, Set<String> knownTypes, Set<String> knownSignatures) throws TranslatorException {
        JavaExtension javaExt;
        try {
            javaExt = new JavaExtension(ModelTranslator.getJavaQualifiedNameString(ext.getName()), this.resolver.getTypeRegistry());
            this.processJavaExtension(javaExt, knownTypes, knownSignatures, ext, (EStructuralFeature)TemplateLangPackage.Literals.EXTENSION__NAME);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)ext, (EStructuralFeature)TemplateLangPackage.Literals.EXTENSION__NAME);
        }
        return javaExt;
    }

    private JavaExtension processJavaExtension(JavaExtension javaExt, Set<String> knownTypes, Set<String> knownSignatures, EObject cause, EStructuralFeature causingFeature) throws TranslatorException {
        IMetaType resolved = javaExt.getResolved();
        if (resolved != null) {
            String typeName = resolved.getName();
            if (!knownTypes.contains(typeName)) {
                knownTypes.add(typeName);
                int o = 0;
                while (o < resolved.getOperationsCount()) {
                    String sig = resolved.getOperation(o).getJavaSignature();
                    if (knownSignatures.contains(sig)) {
                        throw new TranslatorException("signature " + sig + " in type " + typeName + " is already known", cause, causingFeature, 20205);
                    }
                    knownSignatures.add(sig);
                    ++o;
                }
            } else {
                throw new TranslatorException("type " + typeName + " is already known", cause, causingFeature, 20205);
            }
        }
        return javaExt;
    }

    public static String getJavaQualifiedNameString(JavaQualifiedName name) {
        StringBuilder result = new StringBuilder();
        for (String s : name.getQname()) {
            result.append(s);
        }
        return result.toString();
    }

    protected ModelManagement<Template> getManagementInstance() {
        return TemplateModel.INSTANCE;
    }

    protected void processDefs(List<EObject> elts, Template template) {
        HashMap<CallSite, DefInfo> signatures = new HashMap<CallSite, DefInfo>();
        List defs = ModelTranslator.select(elts, VilDef.class);
        int d = 0;
        while (d < defs.size()) {
            try {
                VilDef vilDef = (VilDef)defs.get(d);
                Def def = this.processDef((VilDef)defs.get(d), template);
                String fSig = def.getSignature() + "[" + template.getName() + "]";
                if (signatures.containsKey(fSig)) {
                    this.error("duplicated template definition", vilDef, (EStructuralFeature)TemplateLangPackage.Literals.VIL_DEF__ID, 20205);
                } else {
                    DefInfo info = new DefInfo(vilDef, def);
                    signatures.put((CallSite)((Object)fSig), info);
                    template.addDef(def);
                }
            }
            catch (TranslatorException e) {
                this.error(e);
            }
            ++d;
        }
        for (DefInfo info : signatures.values()) {
            try {
                this.processDefBody(info);
            }
            catch (TranslatorException e) {
                this.error(e);
            }
        }
    }

    private Def processDef(VilDef def, Template template) throws TranslatorException {
        VariableDeclaration[] param = (VariableDeclaration[])this.resolveParameters(def.getParam(), def, (EStructuralFeature)TemplateLangPackage.Literals.VIL_DEF__PARAM, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
        TypeDescriptor specifiedType = null;
        if (def.getType() != null) {
            specifiedType = ((ExpressionTranslator)this.getExpressionTranslator()).processType(def.getType(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
        }
        Def result = new Def(def.getId(), param, null, specifiedType, template);
        if (def.getAnnotations() != null) {
            result.setAnnotations((List)def.getAnnotations().getId());
            this.checkOperationAnnotations((IResolvableOperation)result, def, (EStructuralFeature)TemplateLangPackage.Literals.VIL_DEF__ANNOTATIONS);
        }
        if (def.getProtected() != null) {
            result.setProtected(true);
        }
        return result;
    }

    private void processDefBody(DefInfo info) throws TranslatorException {
        Def def = info.getDef();
        VilDef vilDef = info.getVilDef();
        this.resolver.pushLevel();
        int p = 0;
        while (p < def.getParameterCount()) {
            this.resolver.add((IResolvable)def.getParameter(p));
            ++p;
        }
        def.setBody(this.processBlock(vilDef.getStmts()));
        try {
            try {
                def.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)vilDef, (EStructuralFeature)TemplateLangPackage.Literals.VIL_DEF__STMTS);
            }
        }
        finally {
            this.resolver.popLevel();
        }
    }

    private ITemplateElement[] processBlock(StmtBlock block) {
        ITemplateElement[] result = null;
        if (block != null && block.getStmts() != null && !block.getStmts().isEmpty()) {
            ArrayList<ITemplateElement> tmp = new ArrayList<ITemplateElement>();
            for (Stmt stmt : block.getStmts()) {
                try {
                    tmp.add(this.processStatement(stmt));
                }
                catch (TranslatorException e) {
                    this.error(e);
                }
            }
            if (!tmp.isEmpty()) {
                result = new ITemplateElement[tmp.size()];
                tmp.toArray(result);
            }
        }
        return result;
    }

    @Override
    public ITemplateElement processStatement(Stmt stmt) throws TranslatorException {
        AlternativeStatement result = null;
        if (stmt != null) {
            if (stmt.getAlt() != null) {
                result = this.processAlternative(stmt.getAlt());
            } else if (stmt.getCtn() != null) {
                result = this.processContent(stmt.getCtn(), this.resolver);
            } else if (stmt.getExprStmt() != null) {
                result = (ITemplateElement)this.expressionTranslator.processExpressionStatement(stmt.getExprStmt(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
            } else if (stmt.getLoop() != null) {
                result = this.processLoop(stmt.getLoop());
            } else if (stmt.getWhile() != null) {
                result = this.processWhile(stmt.getWhile());
            } else if (stmt.getFlush() != null) {
                result = this.processFlush();
            } else if (stmt.getMulti() != null) {
                this.warning("multi selection is currently not supported", stmt.getMulti(), (EStructuralFeature)TemplateLangPackage.Literals.STMT__MULTI, 0);
            } else if (stmt.getSwitch() != null) {
                result = this.processSwitch(stmt.getSwitch());
            } else if (stmt.getVar() != null) {
                result = (ITemplateElement)((ExpressionTranslator)this.getExpressionTranslator()).processVariableDeclaration(stmt.getVar(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
            }
        }
        return result;
    }

    private ITemplateElement processStatementOrStmtBlock(Stmt stmt, StmtBlock block) throws TranslatorException {
        ITemplateElement result = null;
        if (stmt != null) {
            result = this.processStatement(stmt);
        } else if (block != null) {
            this.resolver.pushLevel();
            result = new TemplateBlock(this.processBlock(block));
            this.resolver.popLevel();
        }
        return result;
    }

    private AlternativeStatement processAlternative(Alternative alt) throws TranslatorException {
        ITemplateElement elseElt;
        Expression condition = this.expressionTranslator.processExpression(alt.getExpr(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
        condition = this.expressionTranslator.assertBooleanExpression(condition, alt, (EStructuralFeature)TemplateLangPackage.Literals.ALTERNATIVE__EXPR);
        this.resolver.pushLevel();
        ITemplateElement ifElt = this.processStatementOrStmtBlock(alt.getIf(), alt.getIfBlock());
        this.resolver.popLevel();
        if (alt.getElse() != null || alt.getElseBlock() != null) {
            this.resolver.pushLevel();
            elseElt = this.processStatementOrStmtBlock(alt.getElse(), alt.getElseBlock());
            this.resolver.popLevel();
        } else {
            elseElt = null;
        }
        try {
            return new AlternativeStatement(condition, ifElt, elseElt);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)alt, (EStructuralFeature)TemplateLangPackage.Literals.ALTERNATIVE__EXPR);
        }
    }

    private Expression processSeparatorExpression(PrimaryExpression ex) throws TranslatorException {
        Expression result = ex != null ? this.expressionTranslator.processPrimaryExpression(ex, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver) : null;
        return result;
    }

    private WhileStatement processWhile(While loop) throws TranslatorException {
        Expression loopExpression = this.expressionTranslator.processExpression(loop.getExpr(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
        loopExpression = this.expressionTranslator.assertBooleanExpression(loopExpression, loop, (EStructuralFeature)TemplateLangPackage.Literals.WHILE__EXPR);
        this.resolver.pushLevel();
        ITemplateElement stmt = null;
        try {
            stmt = this.processStatementOrStmtBlock(loop.getStmt(), loop.getBlock());
        }
        finally {
            this.resolver.popLevel();
        }
        try {
            return new WhileStatement(loopExpression, stmt);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)loop, (EStructuralFeature)TemplateLangPackage.Literals.WHILE__EXPR);
        }
    }

    private FlushStatement processFlush() throws TranslatorException {
        return new FlushStatement();
    }

    private LoopStatement processLoop(Loop loop) throws TranslatorException {
        TypeDescriptor p0Type;
        Expression loopExpression = this.expressionTranslator.processExpression(loop.getExpr(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
        TypeDescriptor exprType = null;
        try {
            exprType = loopExpression.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__EXPR);
        }
        if (!exprType.isCollection() && !exprType.isIterator()) {
            OperationDescriptor conversion = exprType.getConversionToSequence();
            if (conversion == null) {
                throw new TranslatorException("loop expression must be of type collection rather than " + exprType.getVilName(), (EObject)loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__EXPR, 20203);
            }
            exprType = conversion.getReturnType();
        }
        if (exprType.getGenericParameterCount() == 0) {
            throw new TranslatorException("loop expression is not generic", (EObject)loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__EXPR, 20203);
        }
        TypeDescriptor type = this.expressionTranslator.processType(loop.getType(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
        if (!type.isAssignableFrom(p0Type = exprType.getGenericParameterType(0)) && p0Type.findConversion(p0Type, type) == null) {
            throw new TranslatorException("loop variable type " + type.getVilName() + " must match the element type of the collection " + exprType.getVilName(), (EObject)loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__EXPR, 20203);
        }
        Expression separatorEx = this.processSeparatorExpression(loop.getSeparator());
        Expression finalSeparatorEx = this.processSeparatorExpression(loop.getFinalSeparator());
        VariableDeclaration iteratorVar = new VariableDeclaration(loop.getId(), type);
        ITemplateElement stmt = null;
        this.resolver.pushLevel();
        this.resolver.add((IResolvable)iteratorVar);
        try {
            stmt = this.processStatementOrStmtBlock(loop.getStmt(), loop.getBlock());
        }
        finally {
            this.resolver.popLevel();
        }
        try {
            return new LoopStatement(iteratorVar, loopExpression, stmt, separatorEx, finalSeparatorEx);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__ID);
        }
    }

    private SwitchStatement processSwitch(Switch swtch) throws TranslatorException {
        VariableDeclaration switchVar;
        TypeDescriptor switchExpressionType;
        Expression switchExpression = this.expressionTranslator.processExpression(swtch.getExpr(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
        try {
            switchExpressionType = switchExpression.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__EXPR);
        }
        this.resolver.pushLevel();
        ArrayList<SwitchStatement.Alternative> alternatives = new ArrayList<SwitchStatement.Alternative>();
        int loop = 1;
        do {
            switchVar = new VariableDeclaration("VALUE", switchExpressionType);
            this.resolver.add((IResolvable)switchVar);
            TypeDescriptor commonConditionType = null;
            for (SwitchPart part : swtch.getParts()) {
                TypeDescriptor conditionType;
                Expression condition = this.expressionTranslator.processExpression(part.getLeft(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
                try {
                    conditionType = condition.inferType();
                }
                catch (VilException e) {
                    this.resolver.popLevel();
                    throw new TranslatorException((IIdentifiable)e, (EObject)part, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH_PART__LEFT);
                }
                Expression value = this.expressionTranslator.processExpression(part.getRight(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
                try {
                    condition.inferType();
                }
                catch (VilException e) {
                    this.resolver.popLevel();
                    throw new TranslatorException((IIdentifiable)e, (EObject)part, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH_PART__RIGHT);
                }
                alternatives.add(new SwitchStatement.Alternative(condition, value));
                if (commonConditionType != null && !conditionType.isAssignableFrom(commonConditionType)) continue;
                commonConditionType = conditionType;
            }
            if (swtch.getDflt() != null) {
                Expression expr = this.expressionTranslator.processExpression(swtch.getDflt(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)this.resolver);
                try {
                    expr.inferType();
                }
                catch (VilException e) {
                    this.resolver.popLevel();
                    throw new TranslatorException((IIdentifiable)e, (EObject)swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__DFLT);
                }
                alternatives.add(new SwitchStatement.Alternative(expr));
            }
            if (switchExpressionType.isAssignableFrom(commonConditionType) || IvmlTypes.decisionVariableType().isAssignableFrom(switchExpressionType)) break;
            OperationDescriptor convOp = switchExpressionType.findConversion(switchExpressionType, commonConditionType);
            if (convOp == null) {
                throw new TranslatorException("Cannot convert from switch expression of type " + switchExpressionType.getVilName() + " to the (common) case expression type " + commonConditionType.getVilName(), (EObject)swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__EXPR, 30006);
            }
            try {
                switchExpression = new CallExpression(convOp, new CallArgument(switchExpression));
                switchExpressionType = switchExpression.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__EXPR);
            }
            this.resolver.remove((IResolvable)switchVar);
            alternatives.clear();
        } while (++loop < 3);
        try {
            Iterator iterator = new SwitchStatement(switchExpression, switchVar, alternatives);
            return iterator;
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__EXPR);
        }
        finally {
            this.resolver.popLevel();
        }
    }

    private ContentStatement processContent(Content content, Resolver resolver) throws TranslatorException {
        Expression indentExpr = content.getIndent() != null ? ((ExpressionTranslator)this.getExpressionTranslator()).processExpression(content.getIndent(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver) : null;
        try {
            String text = content.getCtn();
            String terminal = text.substring(0, 1);
            text = StringUtils.convertString((String)text);
            StringBuilder warnings = new StringBuilder();
            IvmlMessageAdapter localRcv = new IvmlMessageAdapter();
            IvmlMessageAdapter oldRcv = this.expressionTranslator.setIvmlMessageAdapter(localRcv);
            CompositeExpression tmp = (CompositeExpression)StringResolver.substitute((String)text, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver, (StringResolver.IExpressionTranslator)this.expressionTranslator, (StringBuilder)warnings, (IStringParserFactory)StringResolverFactory.INSTANCE);
            this.expressionTranslator.setIvmlMessageAdapter(oldRcv);
            localRcv.processAndClear(e -> StringResolver.appendWarning((StringBuilder)warnings, (String)VariableExpression.composeUnkownVariableWarning((String)((VarModelIdentifierExpression)e.getKey()).getIdentifier())));
            if (warnings.length() > 0) {
                this.warning(warnings.toString(), content, (EStructuralFeature)TemplateLangPackage.Literals.CONTENT__CTN, 0);
            }
            ContentStatement.LineEndType leType = content.getCR() == null ? ContentStatement.LineEndType.DEFAULT : (content.getNoCR() == null ? ContentStatement.LineEndType.LINE_END : ContentStatement.LineEndType.NO_LINE_END);
            return new ContentStatement(tmp, terminal, indentExpr, leType, (ILanguageElement)resolver.getCurrentModel());
        }
        catch (VilException e2) {
            throw new TranslatorException((IIdentifiable)e2, (EObject)content, (EStructuralFeature)TemplateLangPackage.Literals.CONTENT__INDENT);
        }
    }

    void error(VilException exception, EObject cause, EStructuralFeature causeFeature) {
        this.expressionTranslator.error((AbstractException)exception, cause, causeFeature);
    }

    void warning(VilException exception, EObject cause, EStructuralFeature causeFeature) {
        this.expressionTranslator.warning((AbstractException)exception, cause, causeFeature);
    }

    protected VariableDeclaration[] createArray(int len) {
        return new VariableDeclaration[len];
    }

    protected void addVisibleDeclarationsToResolver(Template model, Resolver resolver) {
        int v = 0;
        while (v < model.getVariableDeclarationCount()) {
            VariableDeclaration decl = model.getVariableDeclaration(v);
            if (!resolver.contains((IResolvable)decl)) {
                resolver.add((IResolvable)decl);
            }
            ++v;
        }
    }

    protected Typedef createTypedef(String name, TypeDescriptor<?> type) throws VilException {
        return new TypeDef(name, type, (Template)((Resolver)this.getResolver()).getCurrentModel());
    }

    protected Compound createCompound(CompoundTypeDescriptor type) throws VilException {
        return new Compound(type, (Template)((Resolver)this.getResolver()).getCurrentModel());
    }
}

