/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.service.component.ComponentContext;

public class DefaultLib {
    public static final String DEFAULT_LIB_FOLDER_NAME = "defaultLib";
    public static final int DEFAULT_MAX_NESTING = 3;
    private static List<URL> urls = new ArrayList<URL>();

    public static void appendURL(URL url) throws IOException {
        if ((url = DefaultLib.prepare(url)) != null && !urls.contains(url)) {
            urls.add(url);
        }
    }

    public static void appendURLQuietly(URL url) {
        try {
            DefaultLib.appendURL(url);
        }
        catch (IOException e) {
            DefaultLib.getLogger().exception((Exception)e);
        }
    }

    public static void prependURL(URL url) throws IOException {
        if ((url = DefaultLib.prepare(url)) != null && !urls.contains(url)) {
            urls.add(0, url);
        }
    }

    public static void prependURLQuietly(URL url) {
        try {
            DefaultLib.prependURL(url);
        }
        catch (IOException e) {
            DefaultLib.getLogger().exception((Exception)e);
        }
    }

    public static void removeURL(URL url) throws IOException {
        if ((url = DefaultLib.prepare(url)) != null) {
            urls.remove(url);
        }
    }

    public static void removeURLQuietly(URL url) {
        try {
            DefaultLib.removeURL(url);
        }
        catch (IOException e) {
            DefaultLib.getLogger().exception((Exception)e);
        }
    }

    public static Iterable<URL> urls() {
        return urls;
    }

    public static void appendAll(List<URL> target) {
        target.addAll(urls);
    }

    public static void append(List<URL> target, URL url) throws IOException {
        if ((url = DefaultLib.prepare(url)) != null) {
            target.add(url);
            DefaultLib.getLogger().info("Added default library URL: " + String.valueOf(url));
        }
    }

    public static void appendQuietly(List<URL> target, URL url) {
        try {
            DefaultLib.append(target, url);
        }
        catch (IOException e) {
            DefaultLib.getLogger().exception((Exception)e);
        }
    }

    private static URL prepare(URL url) throws IOException {
        URL result = url;
        if (result != null) {
            try {
                result = FileLocator.resolve((URL)result);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            url = new URL(url.toString().replaceAll(" ", "%20"));
        }
        return result;
    }

    public static URL appendDefaultLibURLQuietly(ClassLoader loader, String bundleId, ComponentContext context, String ... parentFolderName) {
        URL result = null;
        try {
            result = DefaultLib.findDefaultLibURL(loader, bundleId, context, parentFolderName);
            DefaultLib.appendURL(result);
        }
        catch (IOException e) {
            DefaultLib.getLogger().exception((Exception)e);
        }
        return result;
    }

    public static URL appendDefaultLibURLQuietly(ClassLoader loader, ComponentContext context, String ... parentFolderName) {
        URL result = null;
        try {
            result = DefaultLib.findDefaultLibURL(loader, context, parentFolderName);
            DefaultLib.appendURL(result);
        }
        catch (IOException e) {
            DefaultLib.getLogger().exception((Exception)e);
        }
        return result;
    }

    public static URL findDefaultLibURL(ClassLoader loader, ComponentContext context, String ... parentFolderName) throws IOException {
        return DefaultLib.findDefaultLibURL(loader, context != null ? context.getUsingBundle().getSymbolicName() : null, context, parentFolderName);
    }

    public static URL findDefaultLibURL(ClassLoader loader, String bundleId, ComponentContext context, String ... parentFolderName) throws IOException {
        String bundleName = null;
        if (context != null && context.getUsingBundle() != null) {
            int pos;
            String location = context.getUsingBundle().getLocation();
            if (location.startsWith("reference:file:") && (pos = location.indexOf("/")) > 0 && pos < location.length() && (bundleName = location.substring(pos + 1)).endsWith("/")) {
                bundleName = bundleName.substring(0, bundleName.length() - 1);
            }
            if (bundleName == null && bundleId != null) {
                bundleName = DefaultLib.composePluginPattern(bundleId);
            }
        }
        String[] pfn = parentFolderName;
        if (bundleName != null) {
            String[] tmp = new String[pfn.length + 1];
            tmp[0] = bundleName;
            System.arraycopy(pfn, 0, tmp, 1, pfn.length);
            pfn = tmp;
        }
        return DefaultLib.findDefaultLibURL(loader, pfn);
    }

    public static URL findDefaultLibURL(ClassLoader loader, String ... parentFolderName) throws IOException {
        return DefaultLib.findDefaultLibURL(loader, 3, DEFAULT_LIB_FOLDER_NAME, parentFolderName);
    }

    public static URL findDefaultLibURL(ClassLoader loader, int maxNesting, String defaultLibFolderName, String ... parentFolderName) throws IOException {
        File f;
        URL dfltUrl = loader.getResource(defaultLibFolderName);
        if (dfltUrl == null && (f = DefaultLib.findFallbackLibFolder(maxNesting, defaultLibFolderName, parentFolderName)) != null) {
            dfltUrl = f.getAbsoluteFile().toURI().toURL();
        }
        return dfltUrl;
    }

    public static File findFallbackLibFolder(int maxNesting, String defaultLibFolderName, String ... parentFolderName) {
        File result = new File(defaultLibFolderName).getAbsoluteFile();
        if (!result.exists()) {
            result = null;
            File startFolder = new File(".").getAbsoluteFile();
            if (startFolder != null) {
                int startParentCount = 0;
                do {
                    startFolder = startFolder.getParentFile();
                    int i = 0;
                    while (startFolder != null && result == null && i < parentFolderName.length) {
                        String par = parentFolderName[i];
                        File f = startFolder;
                        boolean prefix = false;
                        int sepPos = par.lastIndexOf(47);
                        if (sepPos > 0) {
                            f = new File(startFolder, par.substring(0, sepPos));
                            if (!f.exists()) {
                                f = null;
                            }
                            String string = par = sepPos + 1 < par.length() ? par.substring(sepPos + 1) : null;
                        }
                        if (par != null && par.endsWith("*")) {
                            prefix = true;
                            par = par.substring(0, par.length() - 1);
                        }
                        if (f != null && par != null) {
                            result = DefaultLib.findFallbackLibFolder(f, maxNesting, par, prefix, defaultLibFolderName);
                        }
                        ++i;
                    }
                } while (startFolder != null && result == null && (maxNesting < 0 || ++startParentCount < maxNesting));
            }
        }
        return result;
    }

    private static File findFallbackLibFolder(File file, int maxNesting, String folderName, boolean prefix, String defaultLibFolderName) {
        File[] files;
        File result = null;
        File[] fileArray = files = file == null ? null : file.listFiles();
        if (files != null) {
            int i = 0;
            while (result == null && i < files.length) {
                if (files[i].isDirectory()) {
                    String fName = files[i].getName();
                    if (folderName == null) {
                        if (defaultLibFolderName.equals(fName)) {
                            result = files[i];
                        }
                    } else if (maxNesting != 0) {
                        boolean matches = prefix ? files[i].getName().startsWith(folderName) : folderName.equals(files[i].getName());
                        result = matches ? DefaultLib.findFallbackLibFolder(files[i], maxNesting - 1, null, prefix, defaultLibFolderName) : DefaultLib.findFallbackLibFolder(files[i], maxNesting - 1, folderName, prefix, defaultLibFolderName);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static String composePluginPattern(String pluginId) {
        return "plugins/" + pluginId + "*";
    }

    private static EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(DefaultLib.class, "net.ssehub.easy.dslCore");
    }
}

