/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore.translation;

import java.lang.reflect.Field;
import java.util.List;
import net.ssehub.easy.basics.messages.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.LineAndColumn;

public class Message
extends net.ssehub.easy.basics.messages.Message {
    public static final int CODE_IGNORE = 0;
    private EObject cause;
    private EStructuralFeature causingFeature;
    private int code;

    public Message(String message, Status status, EObject cause, EStructuralFeature causingFeature, int code) {
        super(message, status);
        this.cause = cause;
        this.code = code;
        this.causingFeature = causingFeature;
    }

    public EObject getCause() {
        return this.cause;
    }

    public EStructuralFeature getCausingFeature() {
        return this.causingFeature;
    }

    public int getCode() {
        return this.code;
    }

    public boolean ignore() {
        return this.code == 0;
    }

    public String getDetailedDescription() {
        IssueLocation iLoc;
        Object result = super.getDetailedDescription();
        if (this.cause != null && this.causingFeature != null && (iLoc = this.getLocationData(this.cause, this.causingFeature, 0)) != null) {
            result = (String)result + String.valueOf(iLoc);
        }
        return result;
    }

    protected IssueLocation getLocationForNode(INode node) {
        ITextRegionWithLineInformation nodeRegion = node.getTextRegionWithLineInformation();
        int offset = nodeRegion.getOffset();
        int length = nodeRegion.getLength();
        return this.getLocationForNode(node, offset, length);
    }

    protected IssueLocation getLocationForNode(INode node, int offset, int length) {
        URI uri;
        IssueLocation result = new IssueLocation();
        result.offset = offset;
        result.length = length;
        LineAndColumn lineAndColumnStart = NodeModelUtils.getLineAndColumn((INode)node, (int)offset);
        result.lineNumber = lineAndColumnStart.getLine();
        result.column = lineAndColumnStart.getColumn();
        LineAndColumn lineAndColumnEnd = NodeModelUtils.getLineAndColumn((INode)node, (int)(offset + length));
        result.lineNumberEnd = lineAndColumnEnd.getLine();
        result.columnEnd = lineAndColumnEnd.getColumn();
        EObject eObject = node.getSemanticElement();
        if (eObject != null && eObject.eResource() != null && (uri = EcoreUtil.getURI((EObject)eObject)) != null) {
            result.location = uri.toString();
        }
        return result;
    }

    protected IssueLocation getLocationData(EObject obj, EStructuralFeature structuralFeature, int index) {
        IssueLocation result = null;
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)obj);
        if (parserNode != null) {
            if (structuralFeature != null) {
                List nodes = NodeModelUtils.findNodesForFeature((EObject)obj, (EStructuralFeature)structuralFeature);
                if (index < 0) {
                    index = 0;
                }
                if (nodes.size() > index) {
                    parserNode = (INode)nodes.get(index);
                }
            }
            result = this.getLocationForNode((INode)parserNode);
        } else if (obj.eContainer() != null) {
            EStructuralFeature containingFeature;
            EObject container = obj.eContainer();
            result = this.getLocationData(container, containingFeature, (containingFeature = obj.eContainingFeature()).isMany() ? ((EList)container.eGet(containingFeature)).indexOf((Object)obj) : -1);
        } else if (obj.eContents().size() > 0) {
            EObject cont = (EObject)obj.eContents().get(0);
            result = new IssueLocation();
            result.lineNumber = -1;
            result.location = Message.fieldToString(cont, "eStorage");
            result.details = Message.fieldToString(cont, "name");
        }
        return result;
    }

    private static String fieldToString(Object obj, String field) {
        return Message.fieldToString(obj, obj.getClass(), field);
    }

    private static String fieldToString(Object obj, Class<?> cls, String field) {
        String result = null;
        try {
            Field f = cls.getDeclaredField(field);
            f.setAccessible(true);
            Object val = f.get(obj);
            if (val != null) {
                result = val.toString();
            }
        }
        catch (NoSuchFieldException e) {
            if (cls.getSuperclass() != null) {
                result = Message.fieldToString(obj, cls.getSuperclass(), field);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return result;
    }

    protected static class IssueLocation {
        protected int lineNumber;
        protected int column;
        protected int lineNumberEnd;
        protected int columnEnd;
        protected int offset;
        protected int length;
        private String location;
        private String details;

        protected IssueLocation() {
        }

        public String toString() {
            Object result = "";
            if (this.lineNumber >= 0) {
                result = (String)result + " in line " + this.lineNumber + ":" + this.column + " - " + this.lineNumberEnd + ":" + this.columnEnd;
            }
            if (this.location != null) {
                result = ((String)result).length() > 0 ? (String)result + " " : " ";
                result = (String)result + "in " + this.location;
            }
            if (this.details != null) {
                result = ((String)result).length() > 0 ? (String)result + " " : " ";
                result = (String)result + this.details;
            }
            return result;
        }
    }
}

