/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore.validation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.dslCore.ModelUtility;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.Message;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.Arrays;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class ValidationUtils {
    private static boolean performValidationOnSave = true;
    private static List<String> pathPrefixes = new ArrayList<String>();
    private static ValidationMode mode = ValidationMode.EASY_BUILDER;

    public static boolean enableOnSave(boolean enable) {
        boolean old = performValidationOnSave;
        performValidationOnSave = enable;
        return old;
    }

    public static boolean isOnSaveEnabled() {
        return performValidationOnSave && ValidationMode.ON_SAVE == mode;
    }

    public static ValidationMode getValidationMode() {
        return mode;
    }

    public static void processMessages(TranslationResult<?> result, BasicDiagnostic diagnostic) {
        int m = 0;
        while (m < result.getMessageCount()) {
            Message message = result.getMessage(m);
            diagnostic.add(ValidationUtils.processMessage(message));
            ++m;
        }
    }

    public static Diagnostic processMessage(Message message) {
        return ValidationUtils.createDiagnostic(switch (message.getStatus()) {
            case Status.ERROR -> Severity.ERROR;
            case Status.WARNING -> Severity.WARNING;
            default -> Severity.INFO;
        }, message.getDescription(), message.getCause(), message.getCausingFeature(), message.getCode(), null, new String[0]);
    }

    private static Diagnostic createDiagnostic(Severity severity, String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        int diagnosticSeverity = ValidationUtils.toDiagnosticSeverity(severity);
        FeatureBasedDiagnostic result = new FeatureBasedDiagnostic(diagnosticSeverity, message, object, feature, index, CheckType.NORMAL, code, issueData);
        return result;
    }

    private static int toDiagnosticSeverity(Severity severity) {
        int diagnosticSeverity = -1;
        switch (severity) {
            case ERROR: {
                diagnosticSeverity = 4;
                break;
            }
            case WARNING: {
                diagnosticSeverity = 2;
                break;
            }
            case INFO: {
                diagnosticSeverity = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow severity " + String.valueOf(severity));
            }
        }
        return diagnosticSeverity;
    }

    private static final EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(ValidationUtils.class, "net.ssehub.easy.dslCore");
    }

    public static boolean excludeBinTarget(URI uri) {
        boolean result = true;
        if (uri != null) {
            Object topFolderInProject;
            Object[] segments = uri.segments();
            result = "platform".equals(uri.scheme()) && segments.length >= 3 ? "target".equals(topFolderInProject = segments[2]) || "bin".equals(topFolderInProject) : Arrays.contains((Object[])segments, (Object)"target") || Arrays.contains((Object[])segments, (Object)"bin");
        }
        return result;
    }

    private static String toPrefix(File file) {
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        Object result = uri.toString();
        if (file.isDirectory() && !((String)result).endsWith("/")) {
            result = (String)result + "/";
        }
        return result;
    }

    public static void addPath(File file) {
        String prefix = ValidationUtils.toPrefix(file);
        pathPrefixes.add(prefix);
    }

    public static void removePath(File file) {
        String prefix = ValidationUtils.toPrefix(file);
        pathPrefixes.remove(prefix);
    }

    public static boolean isInPath(URI uri) {
        boolean found = false;
        String u = CommonPlugin.asLocalURI((URI)uri).toString();
        int p = 0;
        while (!found && p < pathPrefixes.size()) {
            found = u.startsWith(pathPrefixes.get(p));
            ++p;
        }
        return found;
    }

    private static <R extends EObject, T> void doCheckModel(R unit, IModelValidationCallback<R, T> callback, boolean debug) {
        java.net.URI uri = null;
        URI eURI = null;
        if (unit.eResource() != null && unit.eResource().getURI() != null) {
            try {
                eURI = unit.eResource().getURI();
                uri = ModelUtility.toNetUri(unit.eResource().getURI());
                if (!"file".equals(uri.getScheme())) {
                    uri = null;
                }
            }
            catch (URISyntaxException e) {
                ValidationUtils.getLogger().error("error translating '" + String.valueOf(unit.eResource().getURI()) + "' during validation" + e.getMessage());
            }
        }
        if (uri != null && callback.isValidationEnabled(uri) && !ValidationUtils.excludeBinTarget(eURI) && ValidationUtils.isInPath(eURI)) {
            Object uriText = "";
            if (unit.eResource() != null && unit.eResource().getURI() != null) {
                uriText = " " + unit.eResource().getURI().toString();
            }
            try {
                TranslationResult<T> result = callback.createModel(unit, uri);
                int m = 0;
                while (m < result.getMessageCount()) {
                    Message message = result.getMessage(m);
                    try {
                        switch (message.getStatus()) {
                            case ERROR: 
                            case UNSUPPORTED: {
                                callback.message(MessageType.ERROR, message.getDescription(), message.getCause(), message.getCausingFeature(), message.getCode());
                                break;
                            }
                            case WARNING: {
                                callback.message(MessageType.WARNING, message.getDescription(), message.getCause(), message.getCausingFeature(), message.getCode());
                                break;
                            }
                            default: {
                                callback.message(MessageType.INFO, message.getDescription(), message.getCause(), message.getCausingFeature(), message.getCode());
                                break;
                            }
                        }
                    }
                    catch (Throwable t) {
                        System.out.println("while creating marker (desc: " + message.getDescription() + ", cause: " + String.valueOf(message.getCause()) + ", feature: " + String.valueOf(message.getCausingFeature()) + ", code: " + message.getCode() + "):" + t.getMessage() + (String)uriText);
                    }
                    ++m;
                }
                if (debug && result.getMessageCount() == 0) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PrintWriter pOut = new PrintWriter(out);
                    pOut.println(">TRANSLATED MODEL");
                    callback.print(result, pOut);
                    pOut.println("<TRANSLATED MODEL");
                    ValidationUtils.getLogger().info(out.toString());
                }
            }
            catch (Throwable e) {
                ValidationUtils.getLogger().error("while validating:" + e.getMessage() + (String)uriText);
                e.printStackTrace();
            }
        }
    }

    public static <R extends EObject, T> void checkModel(R unit, IModelValidationCallback<R, T> callback, boolean debug) {
        if (ValidationMode.ON_SAVE == mode && performValidationOnSave) {
            ValidationUtils.doCheckModel(unit, callback, debug);
        }
    }

    public static <R extends EObject, T> void checkModelFromValidation(R unit, IModelValidationCallback<R, T> callback, boolean debug) {
        if (ValidationMode.VALIDATOR == mode) {
            ValidationUtils.doCheckModel(unit, callback, debug);
        }
    }

    public static interface IModelValidationCallback<R, T> {
        public boolean isValidationEnabled(java.net.URI var1);

        public TranslationResult<T> createModel(R var1, java.net.URI var2);

        public void message(MessageType var1, String var2, EObject var3, EStructuralFeature var4, int var5);

        public void print(TranslationResult<T> var1, Writer var2);
    }

    public static enum MessageType {
        ERROR,
        WARNING,
        INFO;

    }

    public static enum ValidationMode {
        ON_SAVE,
        VALIDATOR,
        EASY_BUILDER;

    }
}

