/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.aspectj.instantiators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.ssehub.easy.instantiation.aspectj.Registration;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.AbstractFileInstantiator;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import org.apache.commons.io.IOUtils;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.tools.ajc.Main;
import org.aspectj.weaver.Dump;

@Instantiator(value="aspectJ")
public class AspectJ
extends AbstractFileInstantiator {
    private static final String CLASSPATH_ARG_NAME = "classpath";

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> aspectJ(Path source, Path target, Map<String, Object> other) throws VilException {
        Set<FileArtifact> result = source.getAbsolutePath().isDirectory() ? AspectJ.aspectJ(null, source.getAbsolutePath(), target, other) : AspectJ.aspectJ((Collection<FileArtifact>)source.selectAll(), null, target, other);
        return result;
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> aspectJ(Collection<FileArtifact> source, Path target, Map<String, Object> other) throws VilException {
        return AspectJ.aspectJ(source, null, target, other);
    }

    private static Set<FileArtifact> aspectJ(Collection<FileArtifact> source, File sourceRoot, Path target, Map<String, Object> other) throws VilException {
        String envErr = Registration.checkEnvironment();
        if (envErr != null) {
            throw new VilException("Sorry, but... " + envErr, 50502);
        }
        long timestamp = PathUtils.normalizedTime();
        File targetPath = AspectJ.determineTargetPath((Path)target);
        if (!source.isEmpty()) {
            Main compiler = new Main();
            ArrayList<String> args = new ArrayList<String>();
            if (targetPath != null) {
                args.add("-d");
                args.add(targetPath.getAbsolutePath());
            }
            String classpath = "";
            for (Map.Entry<String, Object> param : other.entrySet()) {
                String argName = param.getKey();
                String val = AspectJ.toString((Object)param.getValue());
                if (argName.equals(CLASSPATH_ARG_NAME)) {
                    classpath = val;
                    continue;
                }
                args.add("-" + param.getKey());
                args.add(val);
            }
            if ((classpath = AspectJ.prepareAspectJClasspath(classpath)).length() > 0) {
                args.add("-classpath");
                args.add(classpath);
            }
            args.add("-source");
            args.add("1.7");
            if (sourceRoot != null) {
                AspectJ.addAll(sourceRoot, args);
            } else {
                for (FileArtifact fa : source) {
                    args.add(fa.getPath().getAbsolutePath().getAbsolutePath());
                }
            }
            if (sourceRoot == null && source.isEmpty()) {
                throw new VilException("no source files to compile", 30008);
            }
            MessageHandler m = new MessageHandler();
            String[] tmpArgs = new String[args.size()];
            args.toArray(tmpArgs);
            compiler.setHolder((IMessageHolder)m);
            CompletionRunner completion = new CompletionRunner();
            compiler.setCompletionRunner((Runnable)completion);
            compiler.runMain(tmpArgs, false);
            completion.waitForCompletion();
            CompilationAndWeavingContext.reset();
            Dump.reset();
            AspectJ.handleMessages(m);
        }
        ArrayList result = new ArrayList();
        FileUtils.ScanResult scanResult = new FileUtils.ScanResult(result);
        FileUtils.scan((File)targetPath.getAbsoluteFile(), (ArtifactModel)target.getArtifactModel(), (long)timestamp, (FileUtils.ScanResult)scanResult, FileArtifact.class);
        scanResult.checkForException();
        return new ListSet(result, FileArtifact.class);
    }

    private static void handleMessages(MessageHandler handler) throws VilException {
        IInstantiatorTracer tracer = TracerFactory.createInstantiatorTracer();
        for (IMessage msg : handler.getUnmodifiableListView()) {
            if (msg.isDebug() || msg.isInfo() || msg.isWarning()) {
                tracer.traceMessage(msg.getMessage());
                continue;
            }
            tracer.traceError(msg.getMessage());
        }
        if (handler.getErrors().length > 0) {
            StringBuilder tmp = new StringBuilder();
            IMessage[] iMessageArray = handler.getMessages(null, true);
            int n = iMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMessage message = iMessageArray[n2];
                tmp.append(message.toString());
                tmp.append("\r\n");
                ++n2;
            }
            throw new VilException(tmp.toString(), 30012);
        }
    }

    private static final void addAll(File file, List<String> args) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                int f = 0;
                while (f < files.length) {
                    AspectJ.addAll(files[f], args);
                    ++f;
                }
            }
        } else {
            String name = file.getName();
            if (name.endsWith(".java") || name.endsWith(".aj")) {
                args.add(file.getAbsolutePath());
            }
        }
    }

    private static String prepareAspectJClasspath(String classpath) throws VilException {
        InputStream aspectJRt = AspectJ.class.getClassLoader().getResourceAsStream("lib/aspectJ/runtime/aspectjrt.jar");
        if (aspectJRt == null) {
            throw new VilException("aspectj.rt not found - cannot execute aspectj", 30013);
        }
        File tmpJar = new File(FileUtils.getTempDirectory(), "aspectjrt.jar");
        tmpJar.deleteOnExit();
        if (!tmpJar.exists()) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(tmpJar);
                IOUtils.copy((InputStream)aspectJRt, (OutputStream)out);
                aspectJRt.close();
                aspectJRt = null;
                out.close();
                out = null;
            }
            catch (IOException e) {
                if (aspectJRt != null) {
                    try {
                        aspectJRt.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        aspectJRt.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new VilException(e.getMessage(), 30013);
            }
        }
        ArrayList<String> entries = new ArrayList<String>();
        String[] tmpEntries = classpath.split(File.pathSeparator);
        int i = 0;
        while (i < tmpEntries.length) {
            entries.add(tmpEntries[i]);
            ++i;
        }
        entries.add(tmpJar.getAbsolutePath());
        StringBuilder tmp = new StringBuilder();
        int e = 0;
        while (e < entries.size()) {
            if (e > 0) {
                tmp.append(File.pathSeparator);
            }
            tmp.append((String)entries.get(e));
            ++e;
        }
        return tmp.toString();
    }

    private static class CompletionRunner
    implements Runnable {
        private boolean completed = false;

        private CompletionRunner() {
        }

        void waitForCompletion() {
            while (!this.completed) {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            this.completed = true;
        }
    }
}

