/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.velocity;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.velocity.VelocityCompoundAccess;
import net.ssehub.easy.instantiation.velocity.VelocityContainerItem;
import net.ssehub.easy.instantiation.velocity.VelocityContextItem;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.VersionType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.VersionValue;

class VelocityContextInitializer
implements IDatatypeVisitor {
    public static final char SLOT_ACCESS = '-';
    private List<VelocityContextItem> values = new ArrayList<VelocityContextItem>();
    private StringBuffer variableName = new StringBuffer();
    private IDecisionVariable variable;

    VelocityContextInitializer(IDecisionVariable variable) {
        this.variable = variable;
        variable.getDeclaration().getType().accept((IDatatypeVisitor)this);
    }

    List<VelocityContextItem> getItems() {
        return this.values;
    }

    public void visitDatatype(IDatatype datatype) {
    }

    public void visitAnyType(AnyType datatype) {
    }

    public void visitMetaType(MetaType datatype) {
    }

    public void visitConstraintType(ConstraintType datatype) {
    }

    public void visitDerivedType(DerivedDatatype datatype) {
        datatype.getBasisType().accept((IDatatypeVisitor)this);
    }

    private void handleContainer() {
        this.variableName.append(this.variable.getDeclaration().getName());
        ContainerValue conValue = (ContainerValue)this.variable.getValue();
        ArrayList<Object> velocityValues = new ArrayList<Object>(conValue.getElementSize());
        int i = 0;
        int end = conValue.getElementSize();
        while (i < end) {
            velocityValues.add(conValue.getElement(i).getValue());
            ++i;
        }
        this.values.add(new VelocityContainerItem(this.variableName.toString(), velocityValues));
    }

    public void visitSet(Set set) {
        this.handleContainer();
    }

    public void visitSequence(Sequence sequence) {
        this.handleContainer();
    }

    public void visitReference(Reference reference) {
        reference.getType().accept((IDatatypeVisitor)this);
    }

    public void visitBooleanType(BooleanType type) {
        this.variableName.append(this.variable.getDeclaration().getName());
        BooleanValue booleanValue = (BooleanValue)this.variable.getValue();
        if (booleanValue != null) {
            this.values.add(new VelocityContextItem(this.variableName.toString(), booleanValue.getValue()));
        }
    }

    public void visitStringType(StringType type) {
        this.variableName.append(this.variable.getDeclaration().getName());
        StringValue stringValue = (StringValue)this.variable.getValue();
        if (stringValue != null) {
            this.values.add(new VelocityContextItem(this.variableName.toString(), stringValue.getValue()));
        }
    }

    public void visitIntegerType(IntegerType type) {
        this.variableName.append(this.variable.getDeclaration().getName());
        IntValue intValue = (IntValue)this.variable.getValue();
        if (intValue != null) {
            this.values.add(new VelocityContextItem(this.variableName.toString(), intValue.getValue()));
        }
    }

    public void visitRealType(RealType type) {
        this.variableName.append(this.variable.getDeclaration().getName());
        RealValue realValue = (RealValue)this.variable.getValue();
        if (realValue != null) {
            this.values.add(new VelocityContextItem(this.variableName.toString(), realValue.getValue()));
        }
    }

    public void visitCompoundType(Compound compound) {
        StringBuffer variableNameBeforeCMP = new StringBuffer(this.variableName);
        this.variableName.append(this.variable.getDeclaration().getName());
        CompoundValue cmpValue = (CompoundValue)this.variable.getValue();
        VelocityCompoundAccess cmpContextItem = new VelocityCompoundAccess(this.variable.getDeclaration().getName(), cmpValue);
        if (cmpValue != null) {
            int i = 0;
            while (i < compound.getElementCount()) {
                StringBuffer elementName = new StringBuffer(compound.getElement(i).getName());
                Value nestedValue = cmpValue.getNestedValue(elementName.toString());
                if (nestedValue != null) {
                    elementName.insert(0, '-');
                    elementName.insert(0, this.variableName);
                    this.values.add(new VelocityContextItem(elementName.toString(), nestedValue.getValue()));
                    cmpContextItem.addValue(compound.getElement(i).getName(), nestedValue.getValue());
                }
                ++i;
            }
            this.values.add(cmpContextItem);
        }
        this.variableName = variableNameBeforeCMP;
    }

    public void visitEnumType(Enum enumType) {
        this.variableName.append(this.variable.getDeclaration().getName());
        EnumValue enumValue = (EnumValue)this.variable.getValue();
        if (enumValue != null) {
            this.values.add(new VelocityContextItem(this.variableName.toString(), enumValue.getValue().getName()));
        }
    }

    public void visitOrderedEnumType(OrderedEnum enumType) {
        this.visitEnumType((Enum)enumType);
    }

    public void visitVersionType(VersionType type) {
        this.variableName.append(this.variable.getDeclaration().getName());
        VersionValue versionValue = (VersionValue)this.variable.getValue();
        if (versionValue != null) {
            this.values.add(new VelocityContextItem(this.variableName.toString(), Version.toString((Version)versionValue.getValue())));
        }
    }
}

