/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.project_creation;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.producer.eclipse.model.ProductLineProject;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.EASyProjectCreatorFactory;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.IEASyProjectConfigurator;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.InvalidProjectnameException;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.ProjectAlreadyExistsException;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.ProjectCreationException;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.ValidProjectNameType;

public class ProjectCreator {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ProjectCreator.class, "net.ssehub.easy.producer.eclipse");
    private String projectname;
    private boolean lazy;

    public ProjectCreator(String projectname) throws ProjectAlreadyExistsException, InvalidProjectnameException {
        this(projectname, false);
    }

    public ProjectCreator(String projectname, boolean lazy) throws ProjectAlreadyExistsException, InvalidProjectnameException {
        ValidProjectNameType valid = EASyProjectCreatorFactory.isValidProjectName(projectname, lazy);
        switch (valid) {
            case VALID: {
                this.projectname = projectname;
                this.lazy = lazy;
                break;
            }
            case ALREADY_EXISTS: {
                throw new ProjectAlreadyExistsException();
            }
            case INVALID_IDENTIFIER: {
                throw new InvalidProjectnameException();
            }
            default: {
                new ProjectCreationException(null);
            }
        }
    }

    public ProductLineProject deriveNewMember(String predecessor, IEASyProjectConfigurator ... configurators) {
        ProductLineProject plpDerive = null;
        try {
            plpDerive = EASyProjectCreatorFactory.createNewProject(this.projectname, predecessor, false, configurators);
        }
        catch (ProjectCreationException e) {
            LOGGER.exception((Exception)e);
        }
        return plpDerive;
    }

    public ProductLineProject newPLP(IEASyProjectConfigurator ... configurators) {
        ProductLineProject plp = null;
        try {
            plp = EASyProjectCreatorFactory.createNewProject(this.projectname, null, this.lazy, configurators);
        }
        catch (ProjectCreationException e) {
            LOGGER.exception((Exception)e);
        }
        return plp;
    }

    public static boolean projectExists(String projectname) {
        ValidProjectNameType validName = EASyProjectCreatorFactory.isValidProjectName(projectname);
        return ValidProjectNameType.VALID == validName;
    }
}

