/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.eclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.UUID;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.IPersistencer;
import net.ssehub.easy.producer.core.persistence.datatypes.IProjectCreationResult;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.standard.Persistencer;
import net.ssehub.easy.producer.eclipse.observer.EclipseProgressObserver;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.EclipseProjectCreationResult;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.IEclipseProjectCreationResult;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.NatureUtils;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.PathEnvironmentFactory;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.persistency.IVMLWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class EclipsePersistencer
implements IPersistencer {
    public static final File WORKSPACE_FOLDER;
    private Persistencer persistencer;
    private IProgressMonitor monitor;
    private IProject project;
    private File projectFolder;

    static {
        File wsFolder = null;
        try {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            wsFolder = ws.getRoot().getLocation().toFile();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        WORKSPACE_FOLDER = wsFolder;
    }

    public EclipsePersistencer(String projectName, EclipseProgressObserver obs, IProject project) {
        this(new File(WORKSPACE_FOLDER, projectName), obs, project);
    }

    public EclipsePersistencer(File projectFolder, EclipseProgressObserver obs, IProject project) {
        this.projectFolder = projectFolder;
        String projectName = projectFolder.getName();
        this.project = project != null ? project : ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        PathEnvironment pathEnv = PathEnvironmentFactory.createPathEnvironment(this.project);
        File projectFolder2 = new File(pathEnv.getBaseFolder(), projectName);
        File storageFile = PersistenceUtils.getLocationFile((File)projectFolder2, (Configuration.PathKind)Configuration.PathKind.IVML);
        EclipseProgressObserver po = obs;
        if (po == null) {
            po = ProgressObserver.NO_OBSERVER;
            this.monitor = new NullProgressMonitor();
        } else {
            this.monitor = obs.getMonitor();
        }
        this.persistencer = new Persistencer(pathEnv, projectFolder2, storageFile.getAbsolutePath(), (ProgressObserver)obs);
    }

    private EclipseProjectCreationResult createEASyEclipseProject(String projectID, boolean lazy, String ... natures) throws PersistenceException, CoreException {
        if (projectID == null) {
            projectID = UUID.randomUUID().toString();
        }
        IPath folder = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (this.project.getLocation() != null) {
            folder = this.project.getLocation().removeLastSegments(1);
        }
        IProjectCreationResult result = this.createProject(this.project.getName(), folder.toFile(), projectID, lazy);
        if (!lazy) {
            this.project.create((IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        }
        this.project.open((IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        if (!NatureUtils.hasNature(this.project, "org.eclipse.xtext.ui.shared.xtextNature")) {
            NatureUtils.addNature(this.project, "org.eclipse.xtext.ui.shared.xtextNature", this.monitor);
        }
        if (!NatureUtils.hasNature(this.project, "de.uni_hildesheim.sse.EASy-Producer")) {
            NatureUtils.addNature(this.project, "de.uni_hildesheim.sse.EASy-Producer", this.monitor);
        }
        NatureUtils.ensureBuilder(this.project, "de.uni_hildesheim.sse.EASy-Producer.Builder", "org.eclipse.xtext.ui.shared.xtextBuilder", this.monitor);
        return new EclipseProjectCreationResult(result, this.project);
    }

    public IEclipseProjectCreationResult createEASyProject(String projectID, boolean lazy, String ... natures) throws PersistenceException, CoreException {
        EclipseProjectCreationResult result = this.createEASyEclipseProject(projectID, lazy, natures);
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, this.monitor);
        return result;
    }

    public IEclipseProjectCreationResult createEASyProject(String projectID, Project varModel, String ... natures) throws PersistenceException, CoreException {
        EclipseProjectCreationResult result = this.createEASyEclipseProject(projectID, false, natures);
        Project projectModel = result.getVarModel();
        if (projectModel != null && varModel != null) {
            String modelPath = PersistenceUtils.ivmlFileLocation((Project)varModel, (String)result.getConfigFolder().getAbsolutePath());
            File varModelLocation = new File(modelPath);
            if (varModelLocation.exists()) {
                try {
                    varModelLocation.createNewFile();
                }
                catch (IOException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            try {
                FileWriter fWriter = new FileWriter(varModelLocation);
                IVMLWriter ivmlWriter = new IVMLWriter((Writer)fWriter);
                ivmlWriter.setFormatInitializer(true);
                varModel.accept((IModelVisitor)ivmlWriter);
                ivmlWriter.flush();
                fWriter.close();
                VarModel.INSTANCE.updateModel((IModel)varModel, varModelLocation.toURI());
                ProjectImport pi = new ProjectImport(varModel.getName(), null);
                projectModel.addImport(pi);
                fWriter = new FileWriter(result.getVarModelProjectPath());
                ivmlWriter = new IVMLWriter((Writer)fWriter);
                projectModel.accept((IModelVisitor)ivmlWriter);
                ivmlWriter.flush();
                fWriter.close();
                VarModel.INSTANCE.updateModel((IModel)projectModel, result.getVarModelProjectPath().toURI());
                result.setVarModelProjectPath(varModelLocation);
            }
            catch (IOException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, this.monitor);
        return result;
    }

    public PersistentProject load() throws PersistenceException {
        PersistentProject pProject = this.persistencer.load();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectFolder.getName());
        if (project != null) {
            pProject.setName(project.getName());
        }
        return pProject;
    }

    public void save(PLPInfo plp) throws PersistenceException {
        this.persistencer.save(plp);
    }

    public IProjectCreationResult createProject(String projectName, File parentFolder, String projectID, boolean lazy) throws PersistenceException {
        return this.persistencer.createProject(projectName, parentFolder, projectID, lazy);
    }

    public String getProjectID() {
        return this.persistencer.getProjectID();
    }

    public void update() throws PersistenceException {
        this.persistencer.update();
    }

    public PathEnvironment getPathEnvironment() {
        return this.persistencer.getPathEnvironment();
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public File getEasyConfigFile() {
        return this.persistencer.getEasyConfigFile();
    }

    public void setStorageFolder(File folder) {
        this.persistencer.setStorageFolder(folder);
    }
}

