/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.project_creation;

import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.eclipse.EASyUtils;
import net.ssehub.easy.producer.eclipse.model.ProductLineProject;
import net.ssehub.easy.producer.eclipse.persistency.ResourcesMgmt;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.AbstractProjectCreator;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.IEASyProjectConfigurator;
import org.eclipse.core.resources.IProject;

class DerivedProjectCreator
extends AbstractProjectCreator {
    private String predecessorID;
    private ProductLineProject parentPLP;
    private IProject predecessorPoject;

    DerivedProjectCreator(String projectName, String predecessorID, boolean lazy, IEASyProjectConfigurator[] configurators) {
        super(projectName, lazy, configurators);
        this.predecessorID = predecessorID;
        this.parentPLP = (ProductLineProject)SPLsManager.INSTANCE.getPLP(predecessorID);
        this.predecessorPoject = this.parentPLP != null ? ResourcesMgmt.INSTANCE.getProject(this.parentPLP.getProjectName()) : null;
    }

    @Override
    ProductLineProject createEASyProject() {
        super.createProject();
        this.getCreatedProject().getMemberController().addPredecessor(this.predecessorID);
        boolean hasBuildScript = this.parentPLP.getBuildScript() != null;
        EASyUtils.addImport((PLPInfo)this.getCreatedProject(), (PLPInfo)this.parentPLP, hasBuildScript);
        this.parentPLP.save();
        this.parentPLP.getMemberController().addSuccessor(this.getCreatedProject().getProjectID());
        this.getCreatedProject().pullConfigFromPredecessors();
        this.createScriptImports();
        this.getCreatedProject().save();
        super.setPersistenceProperties();
        return this.getCreatedProject();
    }

    protected void createScriptImports() {
        ProductLineProject plp = this.getCreatedProject();
        PLPInfo parentPLP = SPLsManager.INSTANCE.getPLP(this.predecessorID);
        PersistenceUtils.createInstantiatePredecessorScript((PLPInfo)plp, (PLPInfo[])new PLPInfo[]{parentPLP});
    }

    @Override
    protected void configureProject(IProject project, IEASyProjectConfigurator configurator) {
        if (this.predecessorPoject != null) {
            configurator.configure(project, this.predecessorPoject);
        } else {
            configurator.configure(project);
        }
    }
}

