/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AbstractRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.eclipse.contributions.Contributions;
import net.ssehub.easy.producer.eclipse.persistency.EASyPersistencer;
import net.ssehub.easy.producer.eclipse.persistency.ResourcesMgmt;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.PersistenceUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class EASyUtils {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(EASyUtils.class, "net.ssehub.easy.producer.eclipse");

    private EASyUtils() {
    }

    public static IFile findEasyConfig(IProject project) {
        IFile file;
        IFile result = null;
        Configuration cfg = PersistenceUtils.getConfiguration(project);
        int count = cfg.getPathCount(Configuration.PathKind.IVML);
        int i = 0;
        while (result == null && i < count) {
            String folder = cfg.getPath(Configuration.PathKind.IVML, i);
            IFile file2 = project.getFile(folder + ResourcesMgmt.INSTANCE.getSeperator() + ".EASyConfig");
            if (file2.exists()) {
                result = file2;
            }
            ++i;
        }
        if (result == null && (file = project.getFile("EASy" + ResourcesMgmt.INSTANCE.getSeperator() + ".EASyConfig")).exists()) {
            result = file;
        }
        return result;
    }

    public static void loadProject(IProject project) throws PersistenceException {
        IFile cfg;
        String projectID = ResourcesMgmt.INSTANCE.getIDfromResource((IResource)project, project);
        if (projectID == null && (cfg = EASyUtils.findEasyConfig(project)) != null) {
            projectID = ResourcesMgmt.INSTANCE.getIDfromResource((IResource)cfg, project);
        }
        if (projectID != null) {
            PLPInfo openedPLP = SPLsManager.INSTANCE.getPLP(projectID);
            if (openedPLP == null || openedPLP.isPreliminary()) {
                EASyPersistencer persistencer = new EASyPersistencer(project.getLocation().toFile(), null, project);
                persistencer.load();
            }
        } else {
            throw new PersistenceException("EASy configuration not found");
        }
    }

    public static void determineConfigurationPaths(IProject project) {
        Configuration config = PersistenceUtils.getConfiguration(project);
        if (Contributions.determineConfigurationPaths(project, config)) {
            config.store();
            try {
                project.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static void initialize(IProject project, PLPInfo plp) throws IOException {
        ArrayList<PLPInfo> predecessors = new ArrayList<PLPInfo>();
        Contributions.initializePLP(project, plp, predecessors);
        for (PLPInfo predecessor : predecessors) {
            plp.getMemberController().addPredecessor(predecessor);
            PLPInfo predecessorPLP = SPLsManager.INSTANCE.getPLP(predecessor.getProjectID());
            boolean hasBuildScript = false;
            if (predecessorPLP != null) {
                hasBuildScript = predecessorPLP.getBuildScript() != null;
            }
            EASyUtils.addImport(plp, predecessor, hasBuildScript |= predecessor.hasDefaultMainBuildScript());
        }
        Script script = plp.getBuildScript();
        if (script != null) {
            AbstractRule main = script.getMainRule(true);
            try {
                BuildModel.INSTANCE.locations().updateLocation(plp.getConfigLocation(), ProgressObserver.NO_OBSERVER);
                File fakeLocation = new File(plp.getConfigLocation(), "x_0.vil");
                BuildModel.INSTANCE.resolveImports((IModel)script, fakeLocation.toURI(), new ArrayList());
                int i = 0;
                while (i < script.getImportsCount()) {
                    ModelImport imp = script.getImport(i);
                    if (imp.getResolved() != null) {
                        try {
                            AbstractRule target = ((Script)imp.getResolved()).getMainRule(false);
                            main.appendCallTo(target, true);
                        }
                        catch (VilException e) {
                            LOGGER.exception((Exception)((Object)e));
                        }
                    }
                    ++i;
                }
            }
            catch (ModelManagementException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
    }

    public static final void addImport(PLPInfo plp, PLPInfo predecessor, boolean considerVIL) {
        net.ssehub.easy.producer.core.persistence.PersistenceUtils.addImport((PLPInfo)plp, (PLPInfo)predecessor, (boolean)considerVIL);
    }
}

