/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency;

import java.io.File;
import net.ssehub.easy.basics.Environment;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.IPersistencer;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.standard.Persistencer;
import net.ssehub.easy.producer.eclipse.observer.EclipseProgressObserver;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.EclipsePersistencer;
import org.eclipse.core.resources.IProject;

public class PersistencerFactory {
    public static IPersistencer getPersistencer(File projectFolder, EclipseProgressObserver obs, IProject project) {
        EclipsePersistencer persistencer = null;
        if (Environment.runsInEclipse()) {
            persistencer = new EclipsePersistencer(projectFolder, obs, project);
        } else {
            PathEnvironment projectsWorkspace = new PathEnvironment(projectFolder.getParentFile());
            File easyConfigFile = PersistenceUtils.getLocationFile((File)projectFolder, (Configuration.PathKind)Configuration.PathKind.IVML);
            persistencer = new Persistencer(projectsWorkspace, projectFolder, easyConfigFile.getAbsolutePath(), (ProgressObserver)obs);
        }
        return persistencer;
    }
}

