/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.examples.internal;

import java.io.File;
import java.io.IOException;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.producer.examples.AvailableExamples;
import net.ssehub.easy.producer.ui.internal.Activator;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExamplesWizardPage
extends WizardPage {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ExamplesWizardPage.class, "net.ssehub.easy.producer.examples");
    private CheckboxTableViewer examplesList;
    private Browser descriptionArea;

    ExamplesWizardPage() {
        super("Import existing EASy-Producer examples into workspace.");
        this.setTitle("Import existing EASy-Producer examples into workspace.");
        this.setImageDescriptor(Activator.getImageDescriptor((String)"icons/logo_big.gif"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        container.setLayoutData((Object)new GridData(4));
        this.examplesList = CheckboxTableViewer.newCheckList((Composite)container, (int)2822);
        this.examplesList.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.examplesList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        this.examplesList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.examplesList.setInput((Object)AvailableExamples.INSTANCE.getExamples());
        this.descriptionArea = new Browser(container, 2052);
        this.descriptionArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.examplesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    if (!event.getSelection().isEmpty()) {
                        StructuredSelection selection = (StructuredSelection)event.getSelection();
                        ExamplesWizardPage.this.selectionChanged(selection.getFirstElement());
                    } else {
                        ExamplesWizardPage.this.descriptionArea.setText("");
                    }
                }
                catch (ClassCastException cce) {
                    LOGGER.exception((Exception)cce);
                }
            }
        });
        this.examplesList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExamplesWizardPage.this.selectionChanged(event.getElement());
            }
        });
        this.setControl((Control)container);
    }

    AvailableExamples.ExampleDescriptor[] getSelectedExamples() {
        Object[] selection = this.examplesList.getCheckedElements();
        AvailableExamples.ExampleDescriptor[] selectedExamples = new AvailableExamples.ExampleDescriptor[selection != null ? selection.length : 0];
        int i = 0;
        while (i < selectedExamples.length) {
            selectedExamples[i] = (AvailableExamples.ExampleDescriptor)selection[i];
            ++i;
        }
        return selectedExamples;
    }

    private void selectionChanged(Object selectedElement) {
        this.descriptionArea.setText("");
        if (selectedElement != null && selectedElement instanceof AvailableExamples.ExampleDescriptor) {
            try {
                AvailableExamples.ExampleDescriptor descriptor = (AvailableExamples.ExampleDescriptor)selectedElement;
                File descriptionFile = descriptor.getDescription();
                if (descriptionFile != null && descriptionFile.exists()) {
                    this.descriptionArea.setText(FileUtils.readFileToString((File)descriptionFile));
                }
            }
            catch (IOException ioe) {
                LOGGER.exception((Exception)ioe);
            }
        }
    }
}

