/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.producer.eclipse.persistency.ResourcesMgmt;
import net.ssehub.easy.producer.examples.AvailableExamples;
import net.ssehub.easy.producer.examples.ExampleInstallationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ExamplesInstaller {
    private Map<String, Boolean> projects = new HashMap<String, Boolean>();
    private AvailableExamples.ExampleDescriptor[] selectedExamples;
    private Set<String> importedProjects;
    private Set<String> skippedProjects;

    public ExamplesInstaller(AvailableExamples.ExampleDescriptor[] selectedExamples) {
        this.selectedExamples = selectedExamples;
        this.importedProjects = new HashSet<String>();
        this.skippedProjects = new HashSet<String>();
    }

    public Set<String> installExamples() throws ExampleInstallationException {
        if (this.selectedExamples != null) {
            int i = 0;
            while (i < this.selectedExamples.length) {
                this.unzip(this.selectedExamples[i].getSource());
                ++i;
            }
        }
        for (String projectName : this.importedProjects) {
            IProject project = ResourcesMgmt.INSTANCE.getProject(projectName);
            if (project == null || project.exists()) continue;
            try {
                project.create(null);
                project.open(null);
            }
            catch (CoreException e) {
                EASyLoggerFactory.INSTANCE.getLogger(ExamplesInstaller.class, "net.ssehub.easy.producer.examples").exception((Exception)((Object)e));
            }
        }
        if (!this.skippedProjects.isEmpty()) {
            throw new ExampleInstallationException(this.skippedProjects);
        }
        return this.importedProjects;
    }

    private void unzip(File zipLocation) {
        byte[] buffer = new byte[1024];
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipLocation));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                String projectName = ExamplesInstaller.determineProjectName(fileName);
                boolean considerFile = projectName != null ? this.addProject(projectName) : false;
                File newFile = new File(String.valueOf(ResourcesMgmt.INSTANCE.getWorspaceFolder()) + File.separator + fileName);
                new File(newFile.getParent()).mkdirs();
                if (considerFile) {
                    if (!ze.isDirectory()) {
                        int len;
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    } else if (!newFile.exists()) {
                        newFile.mkdirs();
                    }
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            EASyLoggerFactory.INSTANCE.getLogger(ExamplesInstaller.class, "net.ssehub.easy.producer.examples").exception((Exception)ex);
        }
    }

    private boolean addProject(String projectName) {
        Boolean validDestination = this.projects.get(projectName);
        if (validDestination == null) {
            IProject project = ResourcesMgmt.INSTANCE.getProject(projectName);
            File projectDestination = new File(ResourcesMgmt.INSTANCE.getWorspaceFolder(), projectName);
            if (project != null && !project.exists() && !projectDestination.exists()) {
                validDestination = true;
                this.importedProjects.add(projectName);
            } else {
                validDestination = false;
                this.skippedProjects.add(projectName);
            }
            this.projects.put(projectName, validDestination);
        }
        return validDestination;
    }

    public static synchronized String determineProjectName(String entryName) {
        String[] pathElement;
        String projectName = null;
        if (entryName != null && (pathElement = entryName.split("/")) != null && pathElement.length > 0) {
            projectName = pathElement[0];
        }
        return projectName;
    }
}

