/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.examples;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import net.ssehub.easy.basics.Environment;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.producer.ui.productline_editor.EasyProducerDialog;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class AvailableExamples {
    public static final AvailableExamples INSTANCE = new AvailableExamples();
    private ExampleDescriptor[] availableExamples = null;

    private AvailableExamples() {
        HashMap<String, ExampleDescriptor> tmpExamples = new HashMap<String, ExampleDescriptor>();
        Bundle bundle = Platform.getBundle((String)"net.ssehub.easy.producer.examples");
        URL fileURL = bundle.getEntry("examples");
        File folder = null;
        try {
            URL url = FileLocator.resolve((URL)fileURL);
            folder = Environment.toFile((URL)url);
        }
        catch (IOException e1) {
            EasyProducerDialog.showErrorDialog((String)("Could not load examples from: " + fileURL.getPath()));
            EASyLoggerFactory.INSTANCE.getLogger(AvailableExamples.class, "net.ssehub.easy.producer.examples").exception((Exception)e1);
        }
        if (folder != null && folder.isDirectory()) {
            File[] containedFiles = folder.listFiles();
            if (containedFiles != null) {
                String fileName;
                int i = 0;
                while (i < containedFiles.length) {
                    fileName = containedFiles[i].getName();
                    if (fileName.toLowerCase().endsWith("zip")) {
                        ExampleDescriptor descriptor = new ExampleDescriptor();
                        descriptor.name = fileName.substring(0, fileName.length() - 4);
                        descriptor.location = containedFiles[i];
                        tmpExamples.put(descriptor.name, descriptor);
                    }
                    ++i;
                }
                i = 0;
                while (i < containedFiles.length) {
                    String descriptorName;
                    ExampleDescriptor descriptor;
                    fileName = containedFiles[i].getName();
                    if (fileName.toLowerCase().endsWith("html") && (descriptor = (ExampleDescriptor)tmpExamples.get(descriptorName = fileName.substring(0, fileName.length() - 5))) != null) {
                        descriptor.description = containedFiles[i];
                    }
                    ++i;
                }
            }
            this.availableExamples = new ExampleDescriptor[tmpExamples.size()];
            this.availableExamples = tmpExamples.values().toArray(this.availableExamples);
            Arrays.sort(this.availableExamples);
        }
    }

    public ExampleDescriptor[] getExamples() {
        return this.availableExamples;
    }

    public static class ExampleDescriptor
    implements Comparable<ExampleDescriptor> {
        private File location;
        private String name;
        private File description;

        @Override
        public int compareTo(ExampleDescriptor other) {
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name;
        }

        public File getSource() {
            return this.location;
        }

        public File getDescription() {
            return this.description;
        }
    }
}

