/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.scenario_tests;

import java.io.File;
import java.io.IOException;
import net.ssehub.easy.producer.scenario_tests.AbstractRealTests;
import net.ssehub.easy.producer.scenario_tests.AbstractScenarioTest;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class RealMeasurementsTests
extends AbstractRealTests {
    private static RealMeasurementsTests tests;

    @BeforeClass
    public static void startUp() {
        tests = new RealMeasurementsTests();
        tests.cleanTemp();
    }

    @AfterClass
    public static void shutDown() {
        if (!debug && tests != null) {
            tests.cleanTemp();
            tests = null;
        }
    }

    @Override
    protected String getMeasurementFileName() {
        return "measurements-scenarioVariants.tsv";
    }

    protected File getTestFolder() {
        return new File(this.getTestDataDir(), "real");
    }

    @Test
    public void testQualiMasterSep17Variants() throws IOException {
        int[] tests;
        QMTestModifier modifier = new QMTestModifier();
        String[] versions = new String[]{"0", "0"};
        String[] names = new String[]{"sep17", "QM"};
        this.enableRealTimeAsserts = true;
        int[] nArray = new int[10];
        nArray[1] = 4;
        nArray[2] = 5;
        nArray[3] = 6;
        nArray[4] = 7;
        nArray[5] = 8;
        nArray[6] = 9;
        nArray[7] = 10;
        nArray[8] = 11;
        nArray[9] = 12;
        int[] nArray2 = tests = nArray;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray2[n2];
            System.out.println(">> Start Variant " + i);
            modifier.setVariantNr(i);
            this.executeCase(names, versions, "QualiMaster/", null, AbstractScenarioTest.Mode.REASON, (AbstractScenarioTest.ITestModifier)modifier);
            modifier.cleanUp();
            System.out.println("<< End Variant " + i);
            ++n2;
        }
        this.enableRealTimeAsserts = false;
    }

    private static class QMTestModifier
    implements AbstractScenarioTest.ITestModifier {
        private int variantNr;
        private File target;

        private QMTestModifier() {
        }

        @Override
        public void postCopy(File target) {
            this.target = target;
            this.copy(new File(target, "variants/PipelinesCfg_" + this.variantNr + ".ivml"), new File(target, "EASy/pipelines/PipelinesCfg.ivml"));
            this.copy(new File(target, "variants/InfrastructureCfg_" + this.variantNr + ".ivml"), new File(target, "EASy/infrastructure/InfrastructureCfg.ivml"));
            this.copy(new File(target, "variants/AlgorithmsCfg_" + this.variantNr + ".ivml"), new File(target, "EASy/infrastructure/AlgorithmsCfg.ivml"));
            this.copy(new File(target, "variants/FamiliesCfg_" + this.variantNr + ".ivml"), new File(target, "EASy/infrastructure/FamiliesCfg.ivml"));
            this.copy(new File(target, "variants/DataManagementCfg_" + this.variantNr + ".ivml"), new File(target, "EASy/infrastructure/DataManagementCfg.ivml"));
            try {
                FileUtils.deleteDirectory((File)new File(target, "variants"));
            }
            catch (IOException e) {
                System.out.println("ERROR: Cannot delete variants folder, " + e.getMessage());
            }
        }

        private void copy(File src, File tgt) {
            if (src.exists()) {
                System.out.println("Copying " + String.valueOf(src) + " to " + String.valueOf(tgt));
                try {
                    FileUtils.copyFile((File)src, (File)tgt);
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }

        private void cleanUp() {
            if (this.target != null) {
                FileUtils.deleteQuietly((File)this.target);
                this.target = null;
            }
        }

        private void setVariantNr(int variantNr) {
            this.variantNr = variantNr;
        }

        @Override
        public String getTempFolderName(String projectName) {
            return String.format("%02d_sv_%s", this.variantNr, projectName);
        }

        @Override
        public File getVilOutputFolder(File tmp) {
            return null;
        }

        @Override
        public String getVilStartRuleName() {
            return "main";
        }
    }
}

