/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.scenario_tests;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.scenario_tests.AbstractEasyScenarioTest;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.filter.DeclarationFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.rewrite.ProjectRewriteVisitor;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;
import net.ssehub.easy.varModel.model.rewrite.modifier.IProjectModifier;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.IVMLWriter;
import org.junit.Assert;
import org.junit.Test;

public class DynamicFreezeTest
extends AbstractEasyScenarioTest {
    private static final String PROJECT_OBSERVABLESCFG = "ObservablesCfg";
    private final File testdataDir = new File(this.getTestDataDir(), "real/QualiMaster/jun16");
    private final File expectedModelDir = new File(this.testdataDir, "expected");

    protected File getTestFolder() {
        return new File(this.testdataDir, "without_freeze");
    }

    private Project loadProject(File folder, String projectName, String version) {
        Project mainProject = null;
        try {
            VarModel.INSTANCE.locations().addLocation(folder, ProgressObserver.NO_OBSERVER);
        }
        catch (ModelManagementException e) {
            Assert.fail((String)("unexpected exception: " + e.getMessage()));
        }
        String fileName = version == null ? projectName : projectName + "_" + version;
        File modelFile = new File(folder, fileName + ".ivml");
        Assert.assertTrue((String)("Error: File \"" + modelFile.getAbsolutePath() + "\" does not exist."), (boolean)modelFile.exists());
        URI modelURI = modelFile.toURI();
        try {
            ModelInfo info = VarModel.INSTANCE.availableModels().getModelInfo(projectName, version, modelURI);
            Assert.assertNotNull((String)("IVML model " + projectName + " cannot be found"), (Object)info);
            mainProject = (Project)VarModel.INSTANCE.load(info);
        }
        catch (VersionFormatException e) {
            Assert.fail((String)"version information invalid");
        }
        catch (ModelManagementException e) {
            Assert.fail((String)("unexpected exception: " + String.valueOf((Object)e)));
        }
        Assert.assertNotNull((String)("cannot load IVML model \"" + projectName + "\" (syntax?)"), mainProject);
        return mainProject;
    }

    @Test
    public void testDynamicFreeze() {
        Project qmModel = this.loadProject(this.getTestFolder(), "QM", "0");
        Configuration config = new Configuration(qmModel);
        Project expectedModel = this.loadProject(this.expectedModelDir, "QM", "0");
        DeclarationFinder finder = new DeclarationFinder(qmModel, FilterType.ALL, null);
        ArrayList<DecisionVariableDeclaration> allDeclarations = new ArrayList<DecisionVariableDeclaration>();
        List tmpList = finder.getVariableDeclarations(DeclarationFinder.VisibilityType.ALL);
        int i = 0;
        int end = tmpList.size();
        while (i < end) {
            AbstractVariable declaration = (AbstractVariable)tmpList.get(i);
            if (declaration instanceof DecisionVariableDeclaration && !declaration.getNameSpace().equals(PROJECT_OBSERVABLESCFG)) {
                allDeclarations.add((DecisionVariableDeclaration)declaration);
            }
            ++i;
        }
        ProjectRewriteVisitor rewriter = new ProjectRewriteVisitor(qmModel, FilterType.ALL);
        ProjectFreezeModifier freezer = new ProjectFreezeModifier();
        freezer.declarations = allDeclarations;
        freezer.config = config;
        rewriter.addProjectModifier((IProjectModifier)freezer);
        qmModel.accept((IModelVisitor)rewriter);
        this.compare(qmModel, expectedModel, new HashSet<Project>());
    }

    private void compare(Project actual, Project expected, Set<Project> done) {
        if (!done.contains(actual)) {
            done.add(actual);
            Assert.assertEquals((String)("Project \"" + actual.getName() + "\" is not as expected:\n"), (Object)this.toString(expected), (Object)this.toString(actual));
            int i = 0;
            while (i < actual.getImportsCount()) {
                this.compare((Project)actual.getImport(i).getResolved(), (Project)expected.getImport(i).getResolved(), done);
                ++i;
            }
        }
    }

    private String toString(Project project) {
        StringWriter sWriter = new StringWriter();
        IVMLWriter iWriter = new IVMLWriter((Writer)sWriter);
        project.accept((IModelVisitor)iWriter);
        return sWriter.toString();
    }

    private static class ProjectFreezeModifier
    implements IProjectModifier {
        private static final String CFG_POSTFIX = "Cfg";
        private static final String PROJECT_ADAPTIVITYCFG = "AdaptivityCfg";
        private static final String ANNOTATION_BINDING_TIME = "bindingTime";
        private static final String CONST_BINDING_TIME_RUNTIME_MON = "runtimeMon";
        private static final int RUNTIME_LEVEL = 2;
        private static final Set<String> BLACKLIST = new HashSet<String>();
        private List<DecisionVariableDeclaration> declarations;
        private Configuration config;
        private Map<String, Project> usedProjects = new HashMap<String, Project>();

        static {
            BLACKLIST.add("qualityParameters");
        }

        private ProjectFreezeModifier() {
        }

        public void modifyProject(Project project, RewriteContext context) {
            String pName = project.getName();
            if (pName.endsWith(CFG_POSTFIX) && !pName.equals(PROJECT_ADAPTIVITYCFG)) {
                String projectNS = pName.substring(0, pName.length() - CFG_POSTFIX.length());
                ArrayList<DecisionVariableDeclaration> toFreeze = new ArrayList<DecisionVariableDeclaration>();
                int i = 0;
                int end = this.declarations.size();
                while (i < end) {
                    DecisionVariableDeclaration decl = this.declarations.get(i);
                    if (!(!decl.getNameSpace().equals(projectNS) && !decl.getNameSpace().equals(pName) || ConstraintType.TYPE.isAssignableFrom(decl.getType()) || this.isRuntimeVariable(this.config, decl) || BLACKLIST.contains(decl.getName()))) {
                        toFreeze.add(decl);
                    }
                    ++i;
                }
                IFreezable[] freezes = toFreeze.toArray(new IFreezable[0]);
                DecisionVariableDeclaration itr = null;
                OCLFeatureCall selector = null;
                Attribute annotation = this.getBindingTimeAnnotation(project);
                if (annotation != null && annotation.getType() instanceof OrderedEnum) {
                    OrderedEnum btType = (OrderedEnum)annotation.getType();
                    EnumLiteral lit = null;
                    ConstantValue cVal = null;
                    int i2 = 0;
                    int end2 = btType.getLiteralCount();
                    while (i2 < end2 && lit == null) {
                        if (btType.getLiteral(i2).getName().equals(CONST_BINDING_TIME_RUNTIME_MON)) {
                            lit = btType.getLiteral(i2);
                            try {
                                cVal = new ConstantValue(ValueFactory.createValue((IDatatype)btType, (Object[])new Object[]{lit}));
                            }
                            catch (ValueDoesNotMatchTypeException e) {
                                Assert.fail((String)e.getMessage());
                            }
                        }
                        ++i2;
                    }
                    if (cVal != null) {
                        FreezeVariableType freezeType = new FreezeVariableType(freezes, (IModelElement)project);
                        itr = new DecisionVariableDeclaration("var", (IDatatype)freezeType, (IModelElement)project);
                        AttributeVariable attrExpr = new AttributeVariable((ConstraintSyntaxTree)new Variable((AbstractVariable)itr), annotation);
                        selector = new OCLFeatureCall((ConstraintSyntaxTree)attrExpr, ">=", new ConstraintSyntaxTree[]{cVal});
                        try {
                            selector.inferDatatype();
                        }
                        catch (CSTSemanticException e) {
                            itr = null;
                            selector = null;
                        }
                    }
                }
                FreezeBlock block = new FreezeBlock(freezes, itr, selector, (IModelElement)project);
                project.add((ContainableModelElement)block);
            }
        }

        private boolean isRuntimeVariable(Configuration config, DecisionVariableDeclaration declaration) {
            boolean isRuntimeVar = false;
            IDecisionVariable var = config.getDecision((AbstractVariable)declaration);
            IDecisionVariable annotationVar = null;
            int i = 0;
            int end = var.getAttributesCount();
            while (i < end && annotationVar == null) {
                IDecisionVariable tmpVar = var.getAttribute(i);
                if (ANNOTATION_BINDING_TIME.equals(tmpVar.getDeclaration().getName())) {
                    annotationVar = tmpVar;
                }
                ++i;
            }
            if (annotationVar != null && annotationVar.getValue() != null && annotationVar.getValue() instanceof EnumValue) {
                EnumLiteral selectedLiteral = ((EnumValue)annotationVar.getValue()).getValue();
                isRuntimeVar = selectedLiteral.getOrdinal() >= 2;
            }
            return isRuntimeVar;
        }

        private Attribute getBindingTimeAnnotation(Project project) {
            Attribute btAnnotation = project.getAttribute(ANNOTATION_BINDING_TIME);
            if (btAnnotation == null && project.getName().endsWith(CFG_POSTFIX)) {
                int end;
                int i;
                String baseName = project.getName().substring(0, project.getName().length() - CFG_POSTFIX.length());
                Project baseProject = this.usedProjects.get(baseName);
                if (baseProject == null) {
                    i = 0;
                    end = project.getImportsCount();
                    while (i < end && baseProject == null) {
                        Project importedProject = (Project)project.getImport(i).getResolved();
                        String importedName = importedProject.getName();
                        if (!this.usedProjects.containsKey(importedName)) {
                            this.usedProjects.put(importedName, importedProject);
                        }
                        if (baseName.equals(importedName)) {
                            baseProject = importedProject;
                        }
                        ++i;
                    }
                }
                if (baseProject != null) {
                    i = 0;
                    end = baseProject.getAttributesCount();
                    while (i < end && btAnnotation == null) {
                        btAnnotation = baseProject.getAttribute(ANNOTATION_BINDING_TIME);
                        ++i;
                    }
                }
            }
            return btAnnotation;
        }
    }
}

