/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintList;
import net.ssehub.easy.reasoning.sseReasoner.model.ContextStack;
import net.ssehub.easy.reasoning.sseReasoner.model.SubstitutionVisitor;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public final class TypeCache {
    public static final boolean ENABLED = false;
    static final boolean ON_DEMAND_ACCESSORS = true;
    private Map<IDatatype, Entry> cache = new HashMap<IDatatype, Entry>();
    private transient SubstitutionVisitor substVisitor = new SubstitutionVisitor();

    public Entry get(IDatatype type) {
        return this.cache.get(type);
    }

    public boolean contains(IDatatype type) {
        return this.cache.containsKey(type);
    }

    public Entry createEntryFor(IDatatype type, AbstractVariable var) {
        Entry entry = new Entry(var);
        this.cache.put(type, entry);
        return entry;
    }

    public boolean transferConstraints(IDatatype type, IConstraintTarget target, IDecisionVariable register, AbstractVariable var) {
        Entry entry = this.cache.get(type);
        boolean done = entry != null ? entry.transferConstraints(target, register, var) : false;
        return done;
    }

    public void transferContext(IDatatype type, Map<AbstractVariable, ConstraintSyntaxTree> varMap, Map<String, ConstraintSyntaxTree> nameMap) {
        Entry entry = this.cache.get(type);
        if (entry != null) {
            entry.varMap = varMap;
            entry.nameMap = nameMap;
        }
    }

    public void transferToContext(IDatatype type, ContextStack contexts, AbstractVariable var) {
        Entry entry = this.cache.get(type);
        if (entry != null && entry.varMap != null) {
            for (Map.Entry<AbstractVariable, ConstraintSyntaxTree> e : entry.varMap.entrySet()) {
                contexts.registerMapping(e.getKey(), entry.instantiate(e.getValue(), var));
            }
        }
    }

    private class ConstraintTemplate {
        private ConstraintList target;
        private boolean first;
        private Constraint constraint;
        private boolean register;

        private ConstraintTemplate(ConstraintList target, boolean first, Constraint constraint, boolean register) {
            this.target = target;
            this.first = first;
            this.constraint = constraint;
            this.register = register;
        }

        private void transfer(IConstraintTarget target, IDecisionVariable register, AbstractVariable var, AbstractVariable self) {
            Constraint c = this.constraint;
            if (var != null && self != null) {
                TypeCache.this.substVisitor.addVariableMapping(var, self, 0);
                try {
                    c = this.constraint.createConstraint(TypeCache.this.substVisitor.acceptAndClear(this.constraint.getConsSyntax()));
                }
                catch (CSTSemanticException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(TypeCache.class, "net.ssehub.easy.reasoning.sseReasoner").exception((Exception)((Object)e));
                }
            }
            target.addConstraint(this.target, this.first, c, (IDecisionVariable)(this.register ? register : null));
        }
    }

    public class Entry {
        private AbstractVariable origvar;
        private List<ConstraintTemplate> constraints;
        private List<Entry> parents;
        private Map<AbstractVariable, ConstraintSyntaxTree> varMap;
        private Map<String, ConstraintSyntaxTree> nameMap;

        private Entry(AbstractVariable var) {
            this.origvar = var;
        }

        public void addConstraint(ConstraintList target, boolean first, Constraint constraint, boolean register) {
            if (this.constraints == null) {
                this.constraints = new LinkedList<ConstraintTemplate>();
            }
            this.constraints.add(new ConstraintTemplate(target, first, constraint, register));
        }

        public boolean hasMapping() {
            return this.varMap != null;
        }

        public boolean containsMapping(AbstractVariable var) {
            return this.varMap != null && this.varMap.containsKey(var);
        }

        private ConstraintSyntaxTree instantiate(ConstraintSyntaxTree cst, AbstractVariable var) {
            ConstraintSyntaxTree result = cst;
            if (result != null) {
                TypeCache.this.substVisitor.addVariableMapping(this.origvar, var, 0);
                result = TypeCache.this.substVisitor.acceptAndClear(result);
            }
            return result;
        }

        public ConstraintSyntaxTree getMapping(AbstractVariable var, AbstractVariable self) {
            ConstraintSyntaxTree result = null;
            if (this.varMap != null) {
                result = this.instantiate(this.varMap.get(var), self);
            }
            return result;
        }

        public ConstraintSyntaxTree getLocalMapping(String name, AbstractVariable self) {
            ConstraintSyntaxTree result = null;
            if (this.nameMap != null) {
                result = this.instantiate(this.nameMap.get(name), self);
            }
            return result;
        }

        public void addParent(Entry entry, IConstraintTarget target, IDecisionVariable register, AbstractVariable var) {
            if (this.parents == null) {
                this.parents = new ArrayList<Entry>();
            }
            this.parents.add(entry);
            entry.transferConstraints(target, register, var);
        }

        private boolean transferConstraints(IConstraintTarget target, IDecisionVariable register, AbstractVariable var) {
            boolean done;
            if (this.constraints != null) {
                boolean defaults = !target.inRescheduling();
                int e = 0;
                int n = this.constraints.size();
                while (e < n) {
                    ConstraintTemplate template = this.constraints.get(e);
                    if (defaults || !defaults && template.constraint.getType() != Constraint.Type.DEFAULT) {
                        template.transfer(target, register, this.origvar, var);
                    }
                    ++e;
                }
                if (this.parents != null) {
                    int p = 0;
                    n = this.parents.size();
                    while (p < n) {
                        this.parents.get(p).transferConstraints(target, register, var);
                        ++p;
                    }
                }
                done = true;
            } else {
                done = false;
            }
            return done;
        }

        public String toString() {
            return IvmlDatatypeVisitor.getQualifiedType((IDatatype)this.origvar.getType()) + " constr " + (this.constraints != null ? this.constraints.size() : 0) + " map " + (this.varMap != null ? this.varMap.size() : 0);
        }
    }

    public static interface IConstraintTarget {
        public void addConstraint(ConstraintList var1, boolean var2, Constraint var3, IDecisionVariable var4);

        public boolean inRescheduling();
    }
}

