/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElements;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.ResolvedVariable;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class ReasoningUtils {
    public static final boolean DEBUG = true;
    public static final Pool<Set<Compound>> SET_COMPOUND_POOL = new Pool((IPoolManager)new IPoolManager<Set<Compound>>(){

        public Set<Compound> create() {
            return new HashSet<Compound>();
        }

        public void clear(Set<Compound> instance) {
            instance.clear();
        }
    });
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ReasoningUtils.class, "net.ssehub.easy.reasoning.sseReasoner");

    public static IDatatype inferTypeSafe(ConstraintSyntaxTree cst, IDatatype dflt) {
        IDatatype result = dflt;
        try {
            result = cst.inferDatatype();
        }
        catch (CSTSemanticException e) {
            LOGGER.error(e.getMessage() + " in: " + StringProvider.toIvmlString((ConstraintSyntaxTree)cst));
            LOGGER.exception((Exception)((Object)e));
        }
        return result;
    }

    public static Value createTypeValue(IDatatype type) throws ValueDoesNotMatchTypeException {
        return ValueFactory.createValue((IDatatype)MetaType.TYPE, (Object[])new Object[]{type});
    }

    public static ConstraintSyntaxTree createTypeValueConstant(IDatatype type) throws ValueDoesNotMatchTypeException {
        return new ConstantValue(ReasoningUtils.createTypeValue(type));
    }

    public static void setValue(IDecisionVariable var, Constraint value) {
        if (value != null) {
            try {
                Value cstVal = ValueFactory.createValue((IDatatype)ConstraintType.TYPE, (Object[])new Object[]{value.getConsSyntax()});
                var.setValue(cstVal, var.getState());
            }
            catch (ConfigurationException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            catch (ValueDoesNotMatchTypeException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
    }

    public static ConstraintSyntaxTree createTypeValueConstantSafe(IDatatype type) {
        ConstraintSyntaxTree result = null;
        try {
            result = ReasoningUtils.createTypeValueConstant(type);
        }
        catch (ValueDoesNotMatchTypeException e) {
            LOGGER.exception((Exception)((Object)e));
        }
        return result;
    }

    public static ConstraintSyntaxTree createAsTypeCast(ConstraintSyntaxTree exp, IDatatype targetType) {
        return ReasoningUtils.createAsTypeCast(exp, null, targetType);
    }

    public static ConstraintSyntaxTree createAsTypeCast(ConstraintSyntaxTree exp, IDatatype sourceType, IDatatype targetType) {
        ConstraintSyntaxTree res = exp;
        if (targetType != null && sourceType != targetType) {
            try {
                IDatatype expType = exp.inferDatatype();
                if (!(TypeQueries.sameTypes((IDatatype)sourceType, (IDatatype)targetType) || TypeQueries.sameTypes((IDatatype)expType, (IDatatype)targetType) || TypeQueries.isAnyType((IDatatype)targetType))) {
                    res = new OCLFeatureCall(res, "asType", new ConstraintSyntaxTree[]{ReasoningUtils.createTypeValueConstant(targetType)});
                }
            }
            catch (CSTSemanticException e) {
                LOGGER.error("Creating type cast to " + IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)targetType) + ": " + e.getMessage());
                LOGGER.exception((Exception)((Object)e));
            }
            catch (ValueDoesNotMatchTypeException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
        return res;
    }

    public static void printProblemPoints(Set<IDecisionVariable> problemVariables) {
        if (problemVariables.size() > 0) {
            LOGGER.info("Problem points: ");
            for (IDecisionVariable problem : problemVariables) {
                LOGGER.info(String.valueOf(problem) + "; ");
            }
        }
    }

    public static String toStringAttributes(IDecisionVariable variable) {
        Object attributes = "Attributes: ";
        int i = 0;
        while (i < variable.getAttributesCount()) {
            attributes = (String)attributes + variable.getAttribute(i).toString() + " : " + String.valueOf(variable.getAttribute(i).getState()) + " : " + String.valueOf(variable.getAttribute(i).getValue()) + "; ";
            ++i;
        }
        return attributes;
    }

    public static void printModelElement(IDecisionVariable variable) {
        if (variable.getState() != null) {
            LOGGER.debug(String.valueOf(variable.getDeclaration()) + " : " + variable.getState().toString() + " : " + String.valueOf(variable.getValue()) + " | " + ReasoningUtils.toStringAttributes(variable));
            if (variable.getNestedElementsCount() > 0) {
                int i = 0;
                while (i < variable.getNestedElementsCount()) {
                    ReasoningUtils.printModelElement(variable.getNestedElement(i));
                    ++i;
                }
            }
        }
    }

    public static String toIvmlString(Constraint constraint) {
        return ReasoningUtils.toIvmlString(constraint.getConsSyntax());
    }

    public static String toIvmlString(ConstraintSyntaxTree cst) {
        return cst == null ? "-" : StringProvider.toIvmlString((ConstraintSyntaxTree)cst);
    }

    public static void printModelElements(Configuration config, String comment) {
        LOGGER.debug("-------------------");
        LOGGER.debug(comment);
        for (IDecisionVariable variable : config) {
            ReasoningUtils.printModelElement(variable);
        }
    }

    public static void printConstraints(String text, Iterable<Constraint> constraints) {
        if (text != null) {
            System.out.println("> " + text);
        }
        int count = 0;
        for (Constraint c : constraints) {
            System.out.println(count++ + " " + StringProvider.toIvmlString((ConstraintSyntaxTree)c.getConsSyntax()) + " : " + String.valueOf(c.getTopLevelParent()) + " : " + System.identityHashCode(c));
        }
        if (text != null) {
            System.out.println("< " + text);
        }
    }

    public static void printFailedElements(FailedElements failedElements) {
        if (failedElements.hasProblems()) {
            if (failedElements.problemConstraintCount() > 0) {
                Iterator<Constraint> failedConstraints = failedElements.getProblemConstraints();
                while (failedConstraints.hasNext()) {
                    Constraint failedRule = failedConstraints.next();
                    LOGGER.debug("Failed constraint: " + ReasoningUtils.toIvmlString(failedRule));
                }
            }
            if (failedElements.problemVariabletCount() > 0) {
                Iterator<AbstractVariable> failedVariables = failedElements.getProblemVariables();
                while (failedVariables.hasNext()) {
                    AbstractVariable failedVariable = failedVariables.next();
                    LOGGER.debug("Failed variable: " + String.valueOf(failedVariable));
                }
            }
        }
    }

    public static ContainerOperationCall createContainerCall(ConstraintSyntaxTree container, Operation op, ConstraintSyntaxTree iterEx, DecisionVariableDeclaration ... decl) {
        return new ContainerOperationCall(container, op.getName(), iterEx, decl);
    }

    public static boolean isOverriddenSlot(AbstractVariable decl) {
        boolean overridden = false;
        IModelElement iter = decl.getParent();
        while (iter != null && !(iter instanceof Compound)) {
            iter = iter.getParent();
        }
        if (iter instanceof Compound) {
            overridden = ReasoningUtils.countSlots((Compound)iter, decl.getName(), true) > 1;
        }
        return overridden;
    }

    public static int countSlots(Compound cmp, String name, boolean stopGreater1) {
        int result = 0;
        if (cmp.getElement(name) != null) {
            ++result;
        }
        int r = 0;
        while (r < cmp.getRefinesCount()) {
            if (stopGreater1 && (result += ReasoningUtils.countSlots(cmp.getRefines(r), name, stopGreater1)) > 1) break;
            ++r;
        }
        return result;
    }

    public static boolean isNestedContainer(IDatatype type) {
        return TypeQueries.isContainer((IDatatype)type) && 1 == type.getGenericTypeCount() && TypeQueries.isContainer((IDatatype)type.getGenericType(0));
    }

    public static Value getRelevantValue(AbstractVariable decl, IDecisionVariable var, boolean incremental) {
        ConstraintSyntaxTree dflt;
        Value val = null;
        if (var != null && var.getValue() != null) {
            val = var.getValue();
        } else if (!incremental && (dflt = decl.getDefaultValue()) instanceof ConstantValue) {
            val = ((ConstantValue)dflt).getConstantValue();
        }
        return val;
    }

    public static <D extends Value> D getRelevantValue(AbstractVariable decl, IDecisionVariable var, boolean incremental, Class<D> filter) {
        Value val = ReasoningUtils.getRelevantValue(decl, var, incremental);
        Value result = filter.isInstance(val) ? (Value)filter.cast(val) : null;
        return (D)result;
    }

    public static void addRefines(Compound cmp, Set<Compound> result) {
        result.add(cmp);
        int r = 0;
        int n = cmp.getRefinesCount();
        while (r < n) {
            ReasoningUtils.addRefines(cmp.getRefines(r), result);
            ++r;
        }
    }

    public static boolean getUsedCompoundTypes(Value val, Set<Compound> result) {
        boolean done = false;
        if (val instanceof ContainerValue) {
            ContainerValue cVal = (ContainerValue)val;
            int v = 0;
            while (v < cVal.getElementSize()) {
                IDatatype tType;
                Value tmp = cVal.getElement(v);
                if (!ReasoningUtils.getUsedCompoundTypes(tmp, result) && (tType = DerivedDatatype.resolveToBasis((IDatatype)tmp.getType())) instanceof Compound) {
                    result.add((Compound)tType);
                }
                ++v;
            }
            done = true;
        }
        return done;
    }

    public static void purgeRefines(Set<Compound> compounds, Set<Compound> result) {
        result.addAll(compounds);
        for (Compound c : compounds) {
            ReasoningUtils.purgeRefines(c, result);
        }
    }

    private static void purgeRefines(Compound comp, Set<Compound> result) {
        int r = 0;
        while (r < comp.getRefinesCount()) {
            Compound ref = comp.getRefines(r);
            result.remove(ref);
            ReasoningUtils.purgeRefines(ref, result);
            ++r;
        }
    }

    public static <T, S extends T> void addAll(Collection<T> target, S[] source) {
        if (source != null) {
            int s = 0;
            int n = source.length;
            while (s < n) {
                target.add(source[s]);
                ++s;
            }
        }
    }

    public static IDatatype getDeepestContainedType(Container cnt) {
        IDatatype result = cnt.getContainedType();
        if (result instanceof Container) {
            result = ReasoningUtils.getDeepestContainedType((Container)result);
        }
        return result;
    }

    public static void printConstraintEvaluationResult(Constraint constraint, EvaluationVisitor evaluator) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        System.out.println("EVAL " + StringProvider.toIvmlString((ConstraintSyntaxTree)cst) + " " + String.valueOf(constraint.getType()) + " fulfilled " + evaluator.constraintFulfilled() + " failed " + evaluator.constraintFailed());
        int m = 0;
        while (m < evaluator.getMessageCount()) {
            EvaluationVisitor.Message msg = evaluator.getMessage(m);
            System.out.println("  MSG: " + msg.getDescription() + " " + String.valueOf(msg.getStatus()) + " " + String.valueOf(msg.getVariable()));
            ++m;
        }
    }

    public static ConstraintSyntaxTree getConstraintValueExpression(Value value) {
        ConstraintSyntaxTree cst = null;
        if (value instanceof ConstraintValue) {
            cst = ((ConstraintValue)value).getValue();
        } else if (value != null && BooleanType.TYPE.isAssignableFrom(value.getType())) {
            cst = new ConstantValue(value);
        }
        return cst;
    }

    public static void removeAll(Collection<Constraint> collection, Collection<Constraint> remove) {
        for (Constraint cst : remove) {
            if (!collection.remove(cst)) continue;
            System.out.println("REMOVED " + ReasoningUtils.toIvmlString(cst));
        }
    }

    public static <K> void removeAll(Map<K, ?> map, Collection<K> remove) {
        for (K cst : remove) {
            map.remove(cst);
        }
    }

    public static Set<Compound> collectRefines(IDatatype start, IDatatype exclude) {
        Set result = (Set)SET_COMPOUND_POOL.getInstance();
        if (start instanceof Compound) {
            ReasoningUtils.collectRefines((Compound)start, exclude, true, result);
        }
        return result;
    }

    private static void collectRefines(Compound cmp, IDatatype exclude, boolean add, Set<Compound> result) {
        boolean bl = add = exclude != cmp;
        if (add) {
            result.add(cmp);
        } else {
            result.remove(cmp);
        }
        int r = 0;
        while (r < cmp.getRefinesCount()) {
            ReasoningUtils.collectRefines(cmp.getRefines(r), exclude, add, result);
            ++r;
        }
    }

    public static ConstraintSyntaxTree createParentExpression(IDecisionVariable variable) {
        Object result = null;
        IConfigurationElement parent = variable.getParent();
        if (parent instanceof ContainerVariable) {
            result = new ResolvedVariable(variable);
        } else if (parent instanceof IDecisionVariable) {
            ConstraintSyntaxTree parentAcc = ReasoningUtils.createParentExpression((IDecisionVariable)parent);
            result = variable.getDeclaration() instanceof Attribute ? new AttributeVariable(parentAcc, (Attribute)variable.getDeclaration()) : new CompoundAccess(parentAcc, variable.getDeclaration().getName());
        } else {
            result = new Variable(variable.getDeclaration());
        }
        return result;
    }

    public static <K, V> Map<K, V> copyMapNull(Map<K, V> source) {
        HashMap<K, V> result;
        if (source != null && source.size() > 0) {
            result = new HashMap<K, V>(source.size());
            result.putAll(source);
        } else {
            result = null;
        }
        return result;
    }
}

