/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelListener;
import net.ssehub.easy.basics.modelManagement.IModelProcessingListener;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.varModel.confModel.AllFreezeSelector;
import net.ssehub.easy.varModel.confModel.AssignmentResolver;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ConfigurationInitializerRegistry;
import net.ssehub.easy.varModel.confModel.ConfigurationSaver;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.ICollectionElementVariable;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IConfigurationChangeListener;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IConfigurationVisitable;
import net.ssehub.easy.varModel.confModel.IConfigurationVisitor;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.QueryCache;
import net.ssehub.easy.varModel.confModel.SharedQueryCache;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.cstEvaluation.FreezeEvaluator;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IProjectListener;
import net.ssehub.easy.varModel.model.IvmlModelQuery;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.DeclarationFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.filter.FrozenElementsFinder;
import net.ssehub.easy.varModel.model.rewrite.ProjectCopyVisitor;
import net.ssehub.easy.varModel.model.rewrite.ProjectRewriteVisitor;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenCompoundConstraintsOmitter;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenConstraintVarFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenConstraintsFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenTypeDefResolver;
import net.ssehub.easy.varModel.model.rewrite.modifier.ModelElementFilter;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class Configuration
implements IConfigurationVisitable,
IProjectListener,
Iterable<IDecisionVariable>,
IConfigurationElement,
IConfiguration {
    static final ConfigurationInitializerRegistry.IConfigurationInitializer DEFAULT_INITIALIZER = new ConfigurationInitializerRegistry.IConfigurationInitializer(){

        @Override
        public List<Message> initializeConfiguration(Configuration config, ProgressObserver observer) {
            AssignmentResolver resolver = new AssignmentResolver(config);
            resolver.resolve();
            config.freezeValues(config.project, FilterType.ALL);
            config.approximativeFreezing = true;
            return null;
        }

        @Override
        public boolean supportsElementCopy() {
            return false;
        }

        @Override
        public boolean resolveDefaultValue(IDecisionVariable variable) {
            return AssignmentResolver.resolveDefaultValue(variable);
        }
    };
    private Project project;
    private boolean assignValues;
    private boolean approximativeFreezing;
    private LinkedHashMap<AbstractVariable, IDecisionVariable> decisions = new LinkedHashMap();
    private List<IConfigurationChangeListener> listeners;
    private Map<IDatatype, Map<IDecisionVariable, ReferenceValue>> allInstances;
    private IAssignmentState resolutionState = AssignmentState.ASSIGNED;
    private QueryCache cache;

    public Configuration(Project project) {
        this(project, true, AssignmentState.ASSIGNED);
    }

    public Configuration(Project project, IAssignmentState resolutionState) {
        this(project, true, resolutionState);
    }

    public Configuration(Configuration configuration) {
        this.project = configuration.getProject();
        this.resolutionState = configuration.getResolutionState();
        this.cache = new QueryCache(this);
        VarModel.INSTANCE.events().addModelListener((IModel)this.project, (IModelListener)this);
        this.listeners = new ArrayList<IConfigurationChangeListener>();
        if (this.project != null) {
            this.createVariables();
            for (Map.Entry<AbstractVariable, IDecisionVariable> entry : configuration.decisions.entrySet()) {
                IDecisionVariable newVar = this.getDecision(entry.getKey());
                if (newVar == null) continue;
                IDecisionVariable oldVar = entry.getValue();
                Value value = oldVar.getValue();
                if (value != null) {
                    value = value.clone();
                }
                try {
                    newVar.setValue(value, oldVar.getState());
                }
                catch (ConfigurationException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").exception((Exception)e);
                }
            }
        }
    }

    public Configuration(Project project, boolean assignValues) {
        this(project, assignValues, AssignmentState.ASSIGNED);
    }

    public Configuration(Project project, boolean assignValues, IAssignmentState resolutionState) {
        this.project = project;
        this.assignValues = assignValues;
        this.resolutionState = resolutionState;
        this.cache = new QueryCache(this);
        VarModel.INSTANCE.events().addModelListener((IModel)project, (IModelListener)this);
        this.listeners = new ArrayList<IConfigurationChangeListener>();
        this.init();
    }

    @Override
    public boolean wasCreated() {
        return true;
    }

    public IAssignmentState getResolutionState() {
        return this.resolutionState;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isApproximatelyFrozen() {
        return this.approximativeFreezing;
    }

    Map<AbstractVariable, IDecisionVariable> getConfiguredDecisions() {
        return (Map)this.decisions.clone();
    }

    public void register(IConfigurationChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregister(IConfigurationChangeListener listener) {
        return this.listeners.remove(listener);
    }

    private ModelInfo<Project> getModelInfo() {
        return VarModel.INSTANCE.availableModels().getModelInfo((IModel)this.project);
    }

    private void init() {
        if (this.project != null) {
            ModelInfo<Project> info = this.getModelInfo();
            VarModel.INSTANCE.events().notifyModelProcessing(info, true, IModelProcessingListener.Type.INITIALIZING);
            VarModel.INSTANCE.resolveImports(this.project, null, null);
            this.createVariables();
            if (this.assignValues) {
                ConfigurationInitializerRegistry.IConfigurationInitializer init = ConfigurationInitializerRegistry.getInitializer();
                if (init == null) {
                    EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").error("No configuration initializer available");
                } else {
                    EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").info("Initializing configuration with: " + init.getClass().getName());
                    String msg = Message.toString(init.initializeConfiguration(this, ProgressObserver.NO_OBSERVER), (Status)Status.ERROR);
                    if (msg.length() > 0) {
                        EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").error(msg);
                    }
                }
            } else {
                EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.varModel").info("Not initializing configuration");
            }
            VarModel.INSTANCE.events().notifyModelProcessing(info, false, IModelProcessingListener.Type.INITIALIZING);
        }
    }

    private void createVariables() {
        DeclarationFinder finder = new DeclarationFinder(this.project, FilterType.ALL, null);
        List<AbstractVariable> topLevelDeclarations = finder.getVariableDeclarations(DeclarationFinder.VisibilityType.ONLY_EXPORTED);
        this.addVariables(topLevelDeclarations, true);
        topLevelDeclarations = finder.getVariableDeclarations(DeclarationFinder.VisibilityType.ONLY_HIDDEN);
        this.addVariables(topLevelDeclarations, false);
    }

    private void addVariables(List<AbstractVariable> topLevelDeclarations, boolean visible) {
        int i = 0;
        while (i < topLevelDeclarations.size()) {
            AbstractVariable declaration = topLevelDeclarations.get(i);
            try {
                this.createDecision(declaration, visible);
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public IDecisionVariable createDecision(AbstractVariable decl) throws ConfigurationException {
        IDecisionVariable result = null;
        if (decl.getParent() instanceof Project && this.getDecision(decl) == null) {
            result = this.createDecision(decl, true);
        }
        return result;
    }

    private IDecisionVariable createDecision(AbstractVariable decl, boolean visible) throws ConfigurationException {
        VariableCreator creator = new VariableCreator(decl, this, visible, false);
        IDecisionVariable variable = creator.getVariable();
        this.addDecision(variable);
        if (this.allInstances != null) {
            this.allInstances.remove(decl.getType());
        }
        return variable;
    }

    public void freezeValues(Project project, FilterType filter) {
        FrozenElementsFinder finder = new FrozenElementsFinder(project, filter);
        List<IFreezable> frozenElements = finder.getFrozenElements();
        FreezeEvaluator selector = new FreezeEvaluator(this);
        int i = 0;
        while (i < frozenElements.size()) {
            IFreezable frozenElement = frozenElements.get(i);
            selector.setFreeze(finder.getFreezeBlock(frozenElement));
            if (frozenElement instanceof AbstractVariable) {
                this.freezeValues((AbstractVariable)((Object)frozenElement), selector);
            } else if (frozenElement instanceof Project) {
                Project prj = (Project)frozenElement;
                int e = 0;
                while (e < prj.getElementCount()) {
                    ContainableModelElement elt = prj.getElement(e);
                    if (elt instanceof AbstractVariable) {
                        this.freezeValues((AbstractVariable)elt, selector);
                    }
                    ++e;
                }
            }
            ++i;
        }
    }

    private void freezeValues(AbstractVariable var, IFreezeSelector selector) {
        if (var.isTopLevel() || var.getParent() instanceof AttributeAssignment) {
            IDecisionVariable frozenVariable = this.getDecision(var);
            if (frozenVariable != null) {
                frozenVariable.freeze(selector);
            }
        } else {
            IModelElement parent = var.getParent();
            System.out.println("Config freeze for nested variable not implemented: " + String.valueOf(parent));
        }
    }

    public void refresh() {
        ModelInfo<Project> info = this.getModelInfo();
        VarModel.INSTANCE.events().notifyModelProcessing(info, true, IModelProcessingListener.Type.REFRESHING);
        this.decisions.clear();
        this.allInstances = null;
        this.init();
        this.cache.clear();
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).configurationRefreshed(this);
            ++i;
        }
        VarModel.INSTANCE.events().notifyModelProcessing(info, false, IModelProcessingListener.Type.REFRESHING);
    }

    public QueryCache getQueryCache() {
        return this.cache;
    }

    private void addDecision(IDecisionVariable variable) {
        this.decisions.put(variable.getDeclaration(), variable);
    }

    public int getDecisionCount() {
        return this.decisions.size();
    }

    @Override
    public IDecisionVariable getDecision(AbstractVariable declaration) {
        IDecisionVariable result = this.decisions.get(declaration);
        if (result == null && declaration instanceof ICollectionElementVariable) {
            result = ((ICollectionElementVariable)((Object)declaration)).resolve(this);
        }
        return result;
    }

    public boolean renameVariable(AbstractVariable declaration, String newName) {
        boolean done = false;
        IDecisionVariable result = this.decisions.get(declaration);
        AbstractVariable var = null;
        if (result == null) {
            String decQName = declaration.getQualifiedName();
            for (AbstractVariable v : this.decisions.keySet()) {
                if (!v.getQualifiedName().equals(decQName)) continue;
                var = v;
                break;
            }
        } else {
            var = declaration;
        }
        if (var != null) {
            IDecisionVariable dec = (IDecisionVariable)this.decisions.remove(var);
            var.getProject().renameElement(var, newName);
            this.decisions.put(var, dec);
            done = true;
        }
        return done;
    }

    public boolean renameVariable(String oldName, String newName) {
        boolean done = false;
        try {
            AbstractVariable var = IvmlModelQuery.findVariable(this.project, oldName, null);
            if (var != null) {
                done = this.renameVariable(var, newName);
            }
        }
        catch (ModelQueryException modelQueryException) {
            // empty catch block
        }
        return done;
    }

    @Override
    public Iterator<IDecisionVariable> iterator() {
        Collection<IDecisionVariable> variableCollection = this.decisions.values();
        return variableCollection.iterator();
    }

    public void clear() {
        this.decisions.clear();
        this.allInstances = null;
    }

    public boolean removeDecision(IDecisionVariable variable) {
        boolean containsKey = this.decisions.containsKey(variable.getDeclaration());
        this.decisions.remove(variable.getDeclaration());
        if (this.allInstances != null) {
            this.removeFromAllInstances(variable);
        }
        return containsKey;
    }

    private void removeFromAllInstances(IDecisionVariable variable) {
        Map<IDecisionVariable, ReferenceValue> inst = this.allInstances.get(variable.getDeclaration().getType());
        if (inst != null) {
            inst.remove(variable);
        }
    }

    public String getName() {
        return this.project.getName();
    }

    @Override
    public void accept(IConfigurationVisitor visitor) {
        visitor.visitConfiguration(this);
    }

    public void notifyReplaced(Project oldProject, Project newProject) {
        this.project = newProject;
        this.refresh();
    }

    public Project toProject(boolean ownProject) throws ConfigurationException {
        return this.toProject(ownProject, true);
    }

    public Project toProject(boolean ownProject, boolean onlyUserInput) throws ConfigurationException {
        ConfigurationSaver saver = new ConfigurationSaver(this, ownProject, onlyUserInput);
        return saver.getSavedConfiguration();
    }

    @Override
    public final Configuration getConfiguration() {
        return this;
    }

    @Override
    public IConfigurationElement getParent() {
        return null;
    }

    void variableChanged(IDecisionVariable var, Value oldValue) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).itemChanged(this, var, oldValue);
            ++i;
        }
        if (this.allInstances != null) {
            this.allInstancesVariableChanged(var);
        }
    }

    private void allInstancesVariableChanged(IDecisionVariable var) {
        IDatatype type = var.getDeclaration().getType();
        Map<IDecisionVariable, ReferenceValue> instances = this.allInstances.get(type);
        if (instances != null) {
            if (NullValue.INSTANCE == var.getValue()) {
                instances.remove(var);
            } else if (!instances.containsKey(var)) {
                Reference rType = new Reference("", type, this.project);
                try {
                    instances.put(var, (ReferenceValue)ValueFactory.createValue(rType, var.getDeclaration()));
                }
                catch (ValueDoesNotMatchTypeException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel").exception((Exception)e);
                }
            }
        }
        int n = 0;
        while (n < var.getNestedElementsCount()) {
            this.allInstancesVariableChanged(var.getNestedElement(n));
            ++n;
        }
    }

    void variableChangedState(IDecisionVariable var) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).stateChanged(this, var);
            ++i;
        }
    }

    protected void addAttributeDecision(Attribute attribute, Value value, IAssignmentState state) throws ConfigurationException {
        VariableCreator creator = new VariableCreator(attribute, this, true, false);
        IDecisionVariable var = creator.getVariable();
        var.setValue(value, state);
        this.decisions.put(attribute, var);
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public IAssignmentState getState() {
        return null;
    }

    @Override
    public void setValue(Value value, IAssignmentState state, IConfigurationElement nested) throws ConfigurationException {
        throw new ConfigurationException(this.getConfiguration(), "operation not supported", 19003);
    }

    @Override
    public AbstractVariable getDeclaration() {
        return null;
    }

    @Override
    public void freeze(IFreezeSelector selector) {
        for (IDecisionVariable variable : this.decisions.values()) {
            variable.freeze(selector);
        }
    }

    @Override
    public void unfreeze(IAssignmentState state) {
        for (IDecisionVariable variable : this.decisions.values()) {
            this.unfreezeVariable(variable, state);
        }
    }

    private void unfreezeVariable(IDecisionVariable variable, IAssignmentState state) {
        if (variable.getNestedElementsCount() > 0) {
            int i = 0;
            int n = variable.getNestedElementsCount();
            while (i < n) {
                this.unfreezeVariable(variable.getNestedElement(i), state);
                ++i;
            }
        }
        variable.unfreeze(state);
    }

    @Override
    public void freeze(String nestedElement) {
        for (IDecisionVariable nestedVariable : this.decisions.values()) {
            if (!nestedVariable.getDeclaration().getName().equals(nestedElement)) continue;
            nestedVariable.freeze(AllFreezeSelector.INSTANCE);
        }
    }

    public static IDecisionVariable dereference(IDecisionVariable var) {
        if (var != null && var.getConfiguration() != null) {
            AbstractVariable varDecl = var.getDeclaration();
            IDatatype type = varDecl.getType();
            while (type instanceof Reference) {
                type = ((Reference)type).getType();
                Value value = var.getValue();
                if (value == null || value == NullValue.INSTANCE) break;
                AbstractVariable refDecl = ((ReferenceValue)var.getValue()).getValue();
                if (refDecl == null) continue;
                IDecisionVariable res = var.getConfiguration().getDecision(refDecl);
                if (res == null) {
                    res = Configuration.findInParents(var, refDecl.getName());
                }
                var = res;
            }
        }
        return var;
    }

    public static IDecisionVariable findInParents(IDecisionVariable var, String name) {
        IDecisionVariable res = null;
        IConfigurationElement iter = var.getParent();
        while (res == null && iter instanceof IDecisionVariable) {
            res = ((IDecisionVariable)iter).getNestedElement(name);
            iter = iter.getParent();
        }
        return res;
    }

    public IDecisionVariable getDecision(String varName, boolean dereference) throws ModelQueryException {
        return this.getDecision(null, varName, dereference);
    }

    private IDecisionVariable getDecision(IDecisionVariable var, String varName, boolean dereference) throws ModelQueryException {
        IDecisionVariable result = null;
        int pos = varName.indexOf(46);
        String name = varName;
        String rest = null;
        if (pos >= 0) {
            name = varName.substring(0, pos);
            rest = varName.substring(pos + 1);
        }
        if (var != null) {
            result = var.getNestedElement(name);
        } else {
            AbstractVariable v = ModelQuery.findVariable(this.getProject(), name, null);
            if (v != null) {
                result = this.getDecision(v);
            }
        }
        if (result != null && dereference) {
            result = Configuration.dereference(result);
        }
        if (result != null && rest != null) {
            result = this.getDecision(result, rest, dereference);
        }
        return result;
    }

    @Override
    public Value getAllInstances(IDatatype type) {
        ContainerValue result;
        if (this.allInstances == null) {
            this.allInstances = new LinkedHashMap<IDatatype, Map<IDecisionVariable, ReferenceValue>>();
        }
        Map<IDecisionVariable, ReferenceValue> instances = this.allInstances.get(type);
        HashMap<IDatatype, Reference> referenceTypes = new HashMap<IDatatype, Reference>();
        Reference rType = new Reference("", type, this.project);
        referenceTypes.put(type, rType);
        if (instances == null && Compound.TYPE.isAssignableFrom(type)) {
            instances = new HashMap<IDecisionVariable, ReferenceValue>();
            this.allInstances.put(type, instances);
            for (IDecisionVariable var : this.decisions.values()) {
                this.collectAllInstances(var, type, referenceTypes, instances);
            }
        }
        Set setType = new Set(type.getName() + "Instances", rType, null);
        try {
            result = new ContainerValue((Container)setType, false, instances == null ? null : instances.values().toArray());
        }
        catch (ValueDoesNotMatchTypeException e) {
            result = null;
        }
        return result;
    }

    private void collectAllInstances(IDecisionVariable var, IDatatype type, Map<IDatatype, Reference> referenceTypes, Map<IDecisionVariable, ReferenceValue> instances) {
        AbstractVariable decl = var.getDeclaration();
        IDatatype varType = decl.getType();
        if (type.isAssignableFrom(varType) && NullValue.INSTANCE != var.getValue()) {
            try {
                Reference refType = referenceTypes.get(varType);
                if (refType == null) {
                    refType = new Reference("", varType, this.project);
                    referenceTypes.put(varType, refType);
                }
                instances.put(var, (ReferenceValue)ValueFactory.createValue(refType, decl));
            }
            catch (ValueDoesNotMatchTypeException e) {
                e.printStackTrace();
            }
        } else {
            int n = 0;
            while (n < var.getNestedElementsCount()) {
                this.collectAllInstances(var.getNestedElement(n), type, referenceTypes, instances);
                ++n;
            }
        }
    }

    public static IDecisionVariable mapVariable(IDecisionVariable var, Configuration cfg) {
        IDecisionVariable result = null;
        if (var.getParent() instanceof IDecisionVariable) {
            IDecisionVariable par = Configuration.mapVariable((IDecisionVariable)var.getParent(), cfg);
            if (par != null) {
                AbstractVariable decl = var.getDeclaration();
                int p = 0;
                while (result == null && p < par.getNestedElementsCount()) {
                    IDecisionVariable nested = par.getNestedElement(p);
                    if (nested.getDeclaration().equals(decl)) {
                        result = nested;
                    }
                    ++p;
                }
            }
        } else {
            result = cfg.getDecision(var.getDeclaration());
        }
        return result;
    }

    public static String getInstanceName(IDecisionVariable var) {
        return Configuration.getInstanceName(var, false);
    }

    public static String getInstanceName(IDecisionVariable var, boolean qualified) {
        Object result = "";
        IConfigurationElement iter = var;
        while (iter != null) {
            if (iter instanceof IDecisionVariable) {
                IDecisionVariable decVar = iter;
                if (((String)result).length() > 0) {
                    result = "::" + (String)result;
                }
                String name = qualified && !(iter.getParent() instanceof IDecisionVariable) ? decVar.getDeclaration().getQualifiedName() : decVar.getDeclaration().getName();
                result = name + (String)result;
            }
            iter = iter.getParent();
        }
        return result;
    }

    public static boolean equalsByInstanceName(IDecisionVariable var1, IDecisionVariable var2) {
        boolean equals;
        if (var1 != null && var2 != null) {
            equals = true;
            IConfigurationElement iter1 = var1;
            IConfigurationElement iter2 = var2;
            do {
                if (!iter1.getDeclaration().getName().equals(iter2.getDeclaration().getName())) {
                    equals = false;
                    break;
                }
                iter1 = iter1.getParent();
                iter2 = iter2.getParent();
            } while (iter1 instanceof IDecisionVariable && iter2 instanceof IDecisionVariable);
        } else {
            equals = false;
        }
        return equals;
    }

    public static void printConfig(PrintStream out, Configuration cfg) {
        for (IDecisionVariable var : cfg) {
            Configuration.printVariable(out, var, "");
        }
    }

    private static void printVariable(PrintStream out, IDecisionVariable var, String indent) {
        out.println(indent + var.getDeclaration().getName() + " = " + String.valueOf(var.getValue()) + " STATE " + String.valueOf(var.getState()));
        int i = 0;
        while (i < var.getNestedElementsCount()) {
            Configuration.printVariable(out, var.getNestedElement(i), indent + " ");
            ++i;
        }
        int a = 0;
        while (a < var.getAttributesCount()) {
            Configuration.printVariable(out, var.getAttribute(a), indent + " ");
            ++a;
        }
    }

    public void removeDerivedValues() {
        boolean changed = false;
        for (IDecisionVariable variable : this.decisions.values()) {
            changed &= variable.removeDerivedValues();
        }
        if (changed) {
            int i = 0;
            int n = this.listeners.size();
            while (i < n) {
                this.listeners.get(i).configurationRefreshed(this);
                ++i;
            }
        }
    }

    public void prune() {
        ProjectCopyVisitor copier = new ProjectCopyVisitor(this.project, FilterType.ALL);
        this.project.accept(copier);
        this.project = copier.getCopiedProject();
        ProjectRewriteVisitor rewriter = new ProjectRewriteVisitor(this.project, FilterType.ALL);
        rewriter.addModelCopyModifier(new ModelElementFilter(Comment.class));
        rewriter.addModelCopyModifier(new FrozenConstraintsFilter(this));
        rewriter.addModelCopyModifier(new FrozenTypeDefResolver(this));
        rewriter.addModelCopyModifier(new FrozenConstraintVarFilter(this));
        rewriter.addModelCopyModifier(new FrozenCompoundConstraintsOmitter(this));
        this.project.accept(rewriter);
    }

    public void shareQueryCacheWith(Configuration configToShare) {
        configToShare.cache = new SharedQueryCache(this.cache);
    }

    public static IDecisionVariable getNestedElement(IDecisionVariable base, String name) {
        IDecisionVariable result = null;
        if (base != null) {
            int n = 0;
            int c = base.getNestedElementsCount();
            while (result == null && n < c) {
                IDecisionVariable nested = base.getNestedElement(n);
                if (name.equals(nested.getDeclaration().getName())) {
                    result = nested;
                }
                ++n;
            }
        }
        return result;
    }

    public static IDecisionVariable getTopLevelDecision(IDecisionVariable var) {
        IConfigurationElement top = var;
        while (top != null && !(top.getParent() instanceof IConfiguration)) {
            top = top.getParent();
        }
        return top instanceof IDecisionVariable ? top : null;
    }

    public static Value dereference(IConfiguration conf, Value value) {
        while (value instanceof ReferenceValue) {
            IDecisionVariable var = conf.getDecision(((ReferenceValue)value).getValue());
            if (var == null) continue;
            value = var.getValue();
        }
        return value;
    }
}

